/*============================================================================
 *	D2D/98	- disc to disc copy for IBM-PC/AT compatible machines
 *	Header file contains data structures and typedefs
 *
 *	Copyright (c) 1987 - 1992, 1998 by
 *		Ulrich Windl
 *		Alte Regensburger Strae 11a
 *		D-93149 Nittenau
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *============================================================================
 *$Id: d2d.h'v 1.6.1.1 1998/12/24 22:22:52 UhW Exp $
 *$Log: d2d.h'v $
 * Revision 1.6.1.1  1998/12/24  22:22:52  UhW
 * This is the GPL version for the 10th anniversary of D2D.
 *
 * Revision 1.6  1992/04/03  19:18:37  UhW
 * Added DISK_STATE and FM_CREATE (which is the former FM_WRITE).
 *
 * Revision 1.5  1992/02/15  21:44:58  UhW
 * Reserved bytes at the end of device parameters are essential for correct
 * alignment with the track layout fields. Not documented in DOS 5.0!
 *
 * Revision 1.4  1992/02/15  19:08:52  UhW
 * Revised BPB structure and added MediaID structure. Added official DOS 5.0
 * formats.
 *
 * Revision 1.3  1991/12/19  15:32:32  UhW
 * Added fields in EMS and XMS memory information blocks that specifies the
 * amount of requested memory. Thus the user can specify the amount of memory
 * he wishes to be used.
 *
 * Revision 1.2  1991/11/06  16:56:16  UhW
 * Prepared for use with RCS
 *
 */

#define	IOCTL		0x44
#define	GENERIC_IOCTL	0x0d
#define	RAWIO		0x08

#define	MAX_SECT	36		/* HD discs: 2.88MB */
#define	SECT_SIZE	512		/* *2.10* */
#define	MAX_TRACK	160
#define	MAX_DISC	( (unsigned) (((long) MAX_SECT * SECT_SIZE * \
					      MAX_TRACK) / 1024) )
#define	DIR_ENTRY_SIZE	32		/* *1.23* (CP/M, isn't it ?) */

/*** GENERIC IOCTL 60H ***/
typedef	struct	{
	unsigned	BytPerSec;	/* BytesPerSector */
	char		SecPerClu;	/* SectorsPerCluster */
	unsigned	ResSec;		/* ReservedSectors */
	char		NumOfFATs;	/* NumberOfFATs */
	unsigned	RootEntr;	/* RootEntries */
	unsigned	TotalSec;	/* TotalSectors */
	char		MediaDesc;	/* MediaDecriptor */
	unsigned	SecPerFAT;	/* SectorsPerFAT */

	unsigned	SecPerTrk;	/* SectorsPerTrack */
	unsigned	Heads;		/* Heads */
	unsigned long	HiddSec;	/* HiddenSectors */
	/* Extensions */
	unsigned long	HugeSec;	/* HugeSectors (DOS 5.0) */
	char		reserved[6];	/* not documented */
}	a_BPB;				/* BIOS Parameter Block */

typedef	struct	{
	unsigned	SecPerTrk;	/* SectorsPerTrack */
	struct	{
		unsigned	number;	/* SectorNumber */
		unsigned	size;	/* SectorSize */
	}	Sector[MAX_SECT];	/* sector table  */
}	a_TrkLay;			/* TrackLayout (variable size) */

typedef	struct	{
	char		SpecFns;	/* SpecialFunctions */
	char		DevType;	/* DeviceType */
	unsigned	DevAttr;	/* DeviceAttributes */
	unsigned	NuOfCyl;	/* NumberOfCylinders */
	char		MediaType;	/* MediaType */
	a_BPB		DevBPB;		/* DeviceBPB */
	a_TrkLay	TrkLay;		/* TrackLayout (optional) */
} A_DEVPAR;				/* a_DeviceParameters */

/*** GENERIC IOCTL 41H/61H ***/
typedef	struct	{
	char		SpecFns;	/* Special Functions */
	unsigned	Head;		/* Head */
	unsigned	Cyl;		/* Cylinder */
	unsigned	FstSec;		/* FirstSector */
	unsigned	nOfSec;		/* NumberOfSectors */
	unsigned long	Transfer;	/* TransferAddress */
} RWTpacket;				/* a_ReadWriteTrackPacket */

/*** GENERIC IOCTL 42H/62H ***/
typedef	struct	{
	char		SpecFns;	/* SpecialFunctions */
	unsigned	Head;		/* Head */
	unsigned	Cyl;		/* Cylinder */
} A_FormPacket;				/* format/verify block */

/*** GENERIC IOCTL 46H/66H ***/
typedef	struct	{
	unsigned	InfoLevel;	/* information level */
	unsigned long	SerialNum;	/* serial number */
	char		VolLabel[11];	/* ASCII volume label */
	char		FileSysType[8];	/* file system type */
} MediaID;				/* Media ID (DOS 5.0) */

/*** linking track images together ***/
typedef	struct link	{
	unsigned long	trackRef;	/* pointer to data */
	struct link	*next;		/* pointer to next link */
}	LINK;

typedef	enum {
	SM_RAM, SM_XMS, SM_EMS, SM_DISC, SM_DONE
}	SWAPMODE;			/* state of read/write */

typedef struct	{
	unsigned	XMS : 1;	/* used XMS ? */
	unsigned	EMS : 1;	/* used EMS ? */
	unsigned	disc : 1;	/* used disc ? */
}	SWAPSTATE;

typedef	struct	{
	unsigned	request;	/* number of EMS pages requested */
	unsigned	handle;		/* EMS handle */
	char far	*frame;		/* EMS frame */
	unsigned	avail;		/* EMS pages available */
	unsigned	lastpg;		/* last used EMS page */
	unsigned	tracks;		/* number of tracks in EMS */
}	EMS_STATE;

typedef	struct	{
	XMS_sizeKB	request;	/* number of kB requested */
	XMS_handle	handle;		/* XMS handle */
	XMS_sizeKB	avail;   	/* number of kB available */
	XMS_offset	lastoffs;	/* last used offset in XMS */
	unsigned	tracks;		/* number of tracks in XMS */
}	XMS_STATE;

typedef	struct	{
	unsigned	request;	/* number of kB requested */
	unsigned	avail;		/* number of kB available */
}	DISK_STATE;

/* ====================================================================== */

#ifndef	OPT_CHAR
# define	OPT_CHAR	'/'
#endif

#define	FALSE	0
#define	TRUE	(!FALSE)
#define	ERR	(-1)

#define	FM_WRITE	(O_BINARY|O_WRONLY|O_TRUNC|O_DENYALL)
#define	FM_CREATE	(FM_WRITE|O_CREAT|O_EXCL)
#define	FM_READ		(O_BINARY|O_RDONLY|O_DENYALL)

#define	PAGESIZE	0x4000		/* size of EMS page */
#define	SEC_SIZE	512	/* preserve one trackbuffer at least */
#define	SLACK		( (long) (MAX_SECT * SEC_SIZE + 0x0800) )

typedef	enum {
	BPB_DOS,
	BPB_160,
	BPB_180,
	BPB_320,
	BPB_320S,
	BPB_360,
	BPB_360S,
	BPB_640,
	BPB_720,
	BPB_1M2,
	BPB_1M4,
	BPB_2M8,
}	BPB_MODE;			/* mode to build BPB */
