#include "syncdir.h"
#include <assert.h>

/*
   if a directory is marked ``delete'' or ``error''
     mark all files under it ``no action''
*/
static BOOL postProcess(FILETABLE *tbl)
{
  FILEINFO *inf = fileTableGetFirst(tbl);
  UINT32 ct = 0;

  if (!optionTest(OPT_QUIET))
    showPostProcessBegin(tbl->name, tbl->entryCt);

  while (inf)
  {
    if (fileInfoIsDirectory(inf) && ((inf->action == ACTION_DELETE) || (inf->action == ACTION_ERROR)))
    {
      /*
         set all descendants of this directory to ``ACTION_NONE''
      */
      FILEINFO *tmp = fileInfoDup(inf);
      inf = fileTableGetNext(tbl);
      while (inf && (fileInfoNameCompare(tmp, inf, TRUE) == 0))
      {
        if (inf->action == ACTION_DELETE)
        {
          tbl->stDelete.tCt--;
          tmp->size += inf->size;
        }
        fileInfoSetAction(inf, ACTION_NONE);
        inf = fileTableGetNext(tbl);
        ct++;
      }
      fileInfoFree(tmp);
    } else
    {
      inf = fileTableGetNext(tbl);
      ct++;
    }
    if (!optionTest(OPT_QUIET))
      showPostProcessUpdate(tbl->name, tbl->entryCt, ct);
  }
  if (!optionTest(OPT_QUIET))
    showPostProcessComplete(tbl->name, tbl->entryCt);
  return TRUE;
}

BOOL process(void)
{
  FILEINFO *srcInf = fileTableGetFirst(source);
  FILEINFO *dstInf = fileTableGetFirst(dest);

  UINT32 totalFiles = source->entryCt + dest->entryCt;
  UINT32 ct = 0;

  if (!optionTest(OPT_QUIET))
    showProcessBegin(totalFiles);

  while (srcInf && dstInf)
  {
    int cmp = fileInfoNameCompare(srcInf, dstInf, FALSE);
    if (cmp < 0)
    {
      /*
         [src] does not exist in [dst]
         possibility : add, delete
      */
      if (optionTest(OPT_ADD))
        fileInfoSetAction(srcInf, ACTION_ADD);
      else if (optionTest(OPT_BOTH | OPT_DELETE) && (!fileInfoIsDirectory(srcInf) || optionTest(OPT_DELETE_DIR)))
        fileInfoSetAction(srcInf, ACTION_DELETE);
      srcInf = fileTableGetNext(source);
      ct++;
    } else if (cmp == 0)
    {
      /*
         possibility : copy, update
      */
      if ((fileInfoIsDirectory(srcInf) && !fileInfoIsDirectory(dstInf))
        || (!fileInfoIsDirectory(srcInf) && fileInfoIsDirectory(dstInf)))
      {
        fileInfoSetAction(srcInf, ACTION_ERROR);
        fileInfoSetAction(dstInf, ACTION_ERROR);
      } else if (!fileInfoIsDirectory(srcInf))
      {
        cmp = fileInfoDateCompare(srcInf, dstInf);
        if (cmp < 0) 
        {
          /* src is older than dst */
          if (optionTest(OPT_COPY))
            fileInfoSetAction(srcInf, ACTION_COPY);
          else if (optionTest(OPT_BOTH | OPT_UPDATE))
            fileInfoSetAction(dstInf, ACTION_UPDATE);
        } else if (cmp == 0) 
        {
          /* same age */
          if (srcInf->size != dstInf->size)
          {
            if (optionTest(OPT_COPY))
              fileInfoSetAction(srcInf, ACTION_COPY);
            else
            {
              fileInfoSetAction(srcInf, ACTION_AMBIG);
              fileInfoSetAction(dstInf, ACTION_AMBIG);
            }
          }
        } else 
        {
          /* dst is older than source */
          if (optionTestOne(OPT_COPY | OPT_UPDATE))
            fileInfoSetAction(srcInf, ACTION_COPY);
        }
      }
      srcInf = fileTableGetNext(source);
      dstInf = fileTableGetNext(dest);
      ct+=2;
    } else 
    {
      /*
         [dst] does not exist in [src]
         possibility : add, delete
      */
      if (optionTest(OPT_DELETE) && (!fileInfoIsDirectory(dstInf) || optionTest(OPT_DELETE_DIR)))
        fileInfoSetAction(dstInf, ACTION_DELETE);
      else if (optionTest(OPT_BOTH | OPT_ADD))
        fileInfoSetAction(dstInf, ACTION_ADD);
      dstInf = fileTableGetNext(dest);
      ct++;
    }
    if (!optionTest(OPT_QUIET))
      showProcessUpdate(totalFiles, ct);
  }
  while (srcInf)
  {
    if (optionTest(OPT_ADD))
      fileInfoSetAction(srcInf, ACTION_ADD);
    else if (optionTest(OPT_BOTH | OPT_DELETE) && (!fileInfoIsDirectory(srcInf) || optionTest(OPT_DELETE_DIR)))
      fileInfoSetAction(srcInf, ACTION_DELETE);
    srcInf = fileTableGetNext(source);
    ct++;
    if (!optionTest(OPT_QUIET))
      showProcessUpdate(totalFiles, ct);
  }
  while (dstInf)
  {
    /*
       [dst] does not exist in [src]
       possibility : add, delete
    */
    if (optionTest(OPT_DELETE) && (!fileInfoIsDirectory(dstInf) || optionTest(OPT_DELETE_DIR)))
      fileInfoSetAction(dstInf, ACTION_DELETE);
    else if (optionTest(OPT_BOTH | OPT_ADD))
      fileInfoSetAction(dstInf, ACTION_ADD);
    dstInf = fileTableGetNext(dest);
    ct++;
    if (!optionTest(OPT_QUIET))
      showProcessUpdate(totalFiles, ct);
  }
  if (!optionTest(OPT_QUIET))
    showProcessComplete(totalFiles);
  postProcess(source);
  postProcess(dest);
  return TRUE;
}
