/*
 *			R E M I N D E R
 *
 *		Computer Reminder System for Important Events
 *
 *			by-	G. E. Toth
 *
 *		(C) - Copyright, 1980	All rights reserved
 *
 *	File format:
 *		<date>:<days before>:<occasion>:<receptor>:<status>
 *
 *	where	<date>			--> 01/04, 1-4, 01|00004, 12-31-85, etc.
 *			<days before>	--> 5, 10, 15, 05, 100, etc.
 *			<occasion>		--> Birthday, Anniversary, briefing, etc.
 *			<receptor>		--> James, George Washington, etc., or empty
 *			<status>		--> Done, D, N, !, etc.
 *
 *	Comments:	The <date> must a string of digits followed by
 *		a non-digit, non-colon, followed by another string of digits,
 *		followed optionally by another non-digit, non-colon and more
 *		digits. The <receptor> if present will appear with a possessive
 *		apostrophe trailing it.  <Status> is used by the program
 *		to tell when one has taken care of an occasion.  When a 'D'
 *		is present as the first character, the occasion is no longer
 *		reported.  A file with a 'D' automatically has the 'D' can-
 *		celled when the program is invoked anytime after the event.
 *		A line with an 'X' has the same effect as a 'D' with the
 *		difference that the line is nulled out completely.
 *
 *			R E V I S I O N   H I S T O R Y
 *		================================================
 *
 *	01-15-80	GET		Designed and wrote program
 *
 *	01-23-80	GET		'X' Status option installed.
 *
 *	08-30-83	RFD		Modified to compile on SYS V
 *
 *	10-30-84	GR-P	Modified to accept files with blank
 *						or null lines; to accept dates with
 *						year specified.
 *
 *	12-20-84	GR-P	LBUFS changed from 100 to 256
 *
 *	1-08-85 	GR-P	Options -n, -b, -e, -f, -t added
 *
 *	10-01-87	KVC		Adapted for MSDOS under Turbo C
 *						(version uses "\DATES" instead of ".dates")
 *
 *	11-18-89	RjR		Port to MS C.  Uses ".\dates"; added -x
 *						(eXplicit), format type 3; added -p (print
 *                      Past events).
 */

#define MSC

#ifdef MSC	/* first try at compatibility with Turbo; it worked! */
#define TURBOC
#endif

/* #define TURBOC */

#ifdef TURBOC
#include <stdio.h>
#include <fcntl.h>
#endif
#ifdef sgi
#define SYSV
#endif
#ifdef SYSV
#include <fcntl.h>
#endif

#define NNESTS	5	/* Number of `chain' nests */
#define NFIELDS 5	/* Number of fields */
#define LBUFS	256	/* Line buffer size */

#ifdef TURBOC
#define DATEFILE ".\\dates"
#endif

#define SECSPERDAY 86400L

char HOME[] = { "HOME" } ;		/* set HOME variable */
char lbuf[LBUFS], *cvec[NFIELDS];	/* Line-buffer, and buffer division vector */

#ifdef TURBOC
FILE *fdstk[NNESTS], *fopen();
int stkind;
#else /* TURBOC */
int fdstk[NNESTS], stkind;	/* Fildes stack for `chain', and stack index */
#endif /* TURBOC */
int thedate, ndays;		/* The date sought for, and its previous days */
int theyear;			/* The year sought for */
int dayslft,kspan;		/* Days left, span for "X" and "D" action */
int *ltimret;			/* localtime() return */
int options,debug,format;	/* Number of options and printout format */
int paste;				/* print past events? */
int from,to;			/* Range of dates to be reported */

int month[12] = {			/* Sum of the days for the months */
	0,
	31,
	59,
	90,
	120,
	151,
	181,
	212,
	243,
	273,
	304,
	334
};

/* need 3 letters in the 1st row cuz we use those for output too.  the others
	are used only for tests, and we test only on the 1st 2 chars */
char *week_days[] =
	{"Sun","Mon","Tue","Wed","Thu","Fri","Sat",
	 "su", "mo", "tu", "we", "th", "fr", "sa",
	 "SU", "MO", "TU", "WE", "TH", "FR", "SA"};

extern int errno;
extern int *localtime();
extern char *asctime();
extern long time();
/*
 *	MAIN( )
 *
 *	Calls:	time(II), localtime(III), printf(III), fopen()
 *		getln(), timespan()
 *
 */

main(argc,argv)
int argc;
char **argv;
{
	register int file, count, nondash;
	char *cp1;
	long ltime, tmpltime;

	options = 0; debug = 0; nondash = 0;
	from = 0 ; to = -1; format = 0; paste = 0;
	time(&ltime);
	ltimret = localtime(&ltime);

	while (++options < argc && nondash == 0) {
/*		cp1 = *++argv; */
		cp1 = argv[options];
		if (*cp1 != '-') {
			nondash++;options--; /* *argv--; */
		}
		else {
			while ((*++cp1) != '\0') {
				switch (*cp1)
				{
					case 'b': from=timespan(++cp1);break;
					case 'd': debug++;break;
					case 'e': to=timespan(++cp1);break;
					case 'f': from=atoi(++cp1);break;
					case 'n': format=1;break;
					case 't': to=atoi(++cp1);break;
					case 'i': format=2;break;
					case 'x': format=3;break;
					case 'p': paste++;break;
				}
			}
		}
	}
	options--;

	if(--argc == options) {
#ifdef TURBOC
		if( (fdstk[stkind=0]=fopen(DATEFILE,"r")) == NULL){
			printf("Cannot open `%s'.\n", DATEFILE);
#else /* TURBOC */
		if( (fdstk[stkind=0]=fopen(".dates")) < 0 && !chdirhome() &&
		    (fdstk[stkind=0]=fopen(".dates")) < 0) {
			printf("Cannot open `.dates'.\n");
#endif /* TURBOC */
			exit(errno);
		}
	}
	file = options;

	if (debug) {
		printf("options=%d, from=%d, to=%d, format=%d\n",
			options,from,to,format);
	}

loop:
	if(argc > options) {
#ifdef TURBOC
		if( (fdstk[stkind=0]=fopen(argv[++file],"r")) == NULL){
#else /* TURBOC */
		if((fdstk[stkind=0]=fopen(argv[++file])) < 0) {
#endif /* TURBOC */
			if (errno == 21) printf("`%s' is a directory.\n",
				argv[file]);
			else printf("Cannot open `%s'\n",argv[file]);
			goto chk;
		}
		else {
			if (debug) printf("Opening `%s'\n",argv[file]);
		}
	}
	while(!getln()) {
		int earliest,latest;
		if (debug > 1)
			printf ("Back from getln\n");
		earliest=0;latest=ndays;
		earliest = from;
		if(paste)	/* if we're printing past events */
			earliest=-32768;
		if (to >= from) latest = to;
		if(dayslft < earliest || dayslft > latest || *cvec[4] == 'D')
			continue;
		switch(format) {
		case 0:
			switch(dayslft) {
			case 0: 	/* Today is the day */
				printf("Today is");		/* RjR: removed BEL */
				break;
			case 1:
				printf("Only one more day before");
				break;
			default:
				printf("%d days before",dayslft);
			}
			break;
		case 1:
			printf("%s",cvec[0]);
			break;
		case 2:
			printf("%s:%s:%s:%s:%s\n",cvec[0],cvec[1],cvec[2],
				cvec[3],cvec[4]);
			break;
		case 3:
			/* print the date as 'yy.mm.dd' so it can be piped to sort */
			tmpltime = ltime + (dayslft * SECSPERDAY);
			ltimret = localtime(&tmpltime);
			printf("%2.2d.%2.2d.%2.2d ",ltimret[5],ltimret[4]+1,ltimret[3]);
			printf("(%3s) ",week_days[ltimret[6]]);
			ltimret = localtime(&ltime); /* set it back for the date tests */
			
			switch(dayslft) {
			case 0: 	/* Today is the day */
				printf("(*today*) ");
				break;
			case 1:
				printf("(tomorrow)");
				break;
			default:
				printf("(%3d days)",dayslft); /* fixed width, same reason */
			}
		}
		if(format != 2) {
			if(*cvec[3])
				printf(" %s's %s\n",cvec[3],cvec[2]);
			else
				printf(" %s\n",cvec[2]);
		}
	}
chk:
	if(--argc > options) goto loop;
	exit(0);
}

/*
 *	GETLN( )
 *
 *	Calls:	close(II), read(II), lseek(II), write(II), atoi(III)
 *		printf(III)
 *
 *	Returns:	0	success
 *			-1	error
 *
 */

getln() 	/* Get and process a line from the input buffer */
{
	register char *cp, **cvecp;
	register int count;
	int i,m,nonblk,magic;

start:
	if (debug > 1)
		printf ("At start: in getln()\n");
	*(cvecp = cvec) = cp = lbuf;
	magic = 1;
	nonblk = 0;
#ifdef TURBOC
	cp = fgets (lbuf,LBUFS, fdstk[stkind]);
	if (*cp == NULL)
		count = 0;
	else
		count = strlen(lbuf);
	if (count <= 0){
#else
	if((count=read(fdstk[stkind],lbuf,LBUFS)) <= 0) {
#endif
		if (debug)
			printf ("Read %d chars in getln\n", count);
		if(stkind) {
#ifdef TURBOC
			fclose (fdstk[stkind--]);
#else
			close(fdstk[stkind--]);
#endif
			goto start;;
		}
		else {
			if (debug)
				printf ("Returning -1 from getln (nothing left)\n");
#ifdef TURBOC
			fclose(fdstk[0]);
#else
			close(fdstk[0]);
#endif
			return(-1);	/* Nothing left; all done */
		}
	}


	/* Now that we have a linebuffer more or less full, find the NL */
	if (debug){
		printf ("Debug level is %d\n", debug);
		printf ("Evaluating linebuffer with %d chars:\n", count);
/*		  printf ("%s\n", lbuf);	*/
	}

	for(cp=lbuf; *cp != '\n' && cp-lbuf < count; cp++) {
		if (debug>1)
			printf ("%c[%3d]", *cp, *cp);
		if(*cp != ' ' && *cp != '\0') nonblk++;
		if(magic){
			if(*cp == '\\') {magic=0;*cp=1;}
			if(*cp == ':') {
				if(++cvecp-cvec < NFIELDS) {
					*cp = 0;	/* Null out colon */
					*cvecp = cp+1;	/* Next field after colon */
				}
			}
		}
		else magic=1;
	}
	if(cp == lbuf || *cp == '\0') { /* Skip empty  or null line */
		if (debug)
			printf("Skipping empty line\n");
		*cp = 0;
#ifndef TURBOC
		lseek(fdstk[stkind],(cp-lbuf)-count+1,1);
#endif
		goto start;
	}
	if(*cp != '\n') {
		printf("Line format error: ");
#ifndef TURBOC
		write(1,lbuf,count);
#endif
		exit(75);
	}
	if(cvecp-cvec != NFIELDS-1 && cvecp != cvec) {
		printf("Line buffer division error\n");
		count = cp-lbuf;
		for(cp=lbuf; cp-lbuf < count; cp++)
			if(!*cp) *cp = ':';	/* Put colons back */
		*cp = '\n';
#ifndef TURBOC
		write(1,lbuf,count+1);
#endif
		exit(76);
	}
	*cp = 0;

#ifndef TURBOC
	lseek(fdstk[stkind],(cp-lbuf)-count+1,1);
#endif

	if(nonblk == 0)goto start;

	if(cvec == cvecp) {	/* A `chain' */
		if (debug)
			printf("Evaluating chain\n");
		if(cvec[0] == '\0') {
			printf("Cannot open for `chain': %s\n",cvec[0]);
			goto start;
		}
		if(stkind < NNESTS-1) {
#ifdef TURBOC
			if((fdstk[++stkind]=fopen(cvec[0],"r")) == NULL) {
#else /* TURBOC */
			if((fdstk[++stkind]=fopen(cvec[0])) < 0) {
#endif /* TURBOC */
				printf("Cannot open for `chain': %s\n",cvec[0]);
				stkind--;
			}
		}
		else {
			printf("Exceeded nesting limits: %d\n",NNESTS);
		}
		goto start;
	}

	timespan(cvec[0]);		/* Get number of days left */

	ndays = atoi(cvec[1]);		/* Get span of days before */

	if (debug)
		printf ("Evaluating days left...\n");

	if(dayslft < 0 || dayslft > kspan) {
		if(*cvec[4] == 'D' && dayslft > 0) {
			for(cp=cvec[4]; *cp; cp++);
#ifndef TURBOC
			lseek(fdstk[stkind],-(i=cp-cvec[4]+1),1);
#endif
			*cvec[4] = 'N';
#ifndef TURBOC
			write(fdstk[stkind],cvec[4],i-1);	/* Save Newline */
			lseek(fdstk[stkind],1,1);
#endif
		}
		if(*cvec[4] == 'X') {
			for(cp=cvec[4]; *cp; cp++);	/* Find length of last string */
#ifndef TURBOC
			lseek(fdstk[stkind],-(i=cp-cvec[0]+1),1);
			for(cvec[1]=cvec[0]; cvec[1]-cvec[0] < i-1; *cvec[1]++ = ' ');
			write(fdstk[stkind],cvec[0],i-1);	/* Save Newline */
#endif
		}
	}
	return(0);
}

/*
 *	TIMESPAN( <name pointer> )
 *
 *
 *	Called by:	main(), getln()
 *
 *	Returns:	ndays
 */

timespan(ptr)
register char *ptr;
{
	register char *cp;
	int i,m;
	for(cp=ptr; *cp == ' '; cp++);
	if((*cp < '0' || *cp > '9') && *cp != '\0') {
		for (i=0; i<21 ; i++) {
			if(equal_first_2_chars(week_days[i],cp)) break;
		}
		if (i == 21) {
			printf(" Error in date format: %s\n",cp);
			dayslft = -1;
			return (dayslft);
		}
		i=i % 7;
		dayslft=i-ltimret[6];
		if(dayslft < 0) dayslft=dayslft+7;
		kspan=3;
		return (dayslft);
	}
	else {
		for(cp=ptr; *cp < '0' || *cp > '9'; cp++);
		m=atoi(ptr);
		for(++cp; *cp >= '0' && *cp <= '9'; cp++);
		thedate = 0;
		if (*cp != '\0') thedate=atoi(++cp);
		if (thedate == 0) {
			thedate=m;
			m=0;
		}
		if (m == 0) {
			kspan=20;
			m=ltimret[4]+1;
			if (thedate < ltimret[3]) ++m;
		}
		else kspan=275;
		if (m == 13) m=1;
		thedate += month[i=m-1]-1;	/* Counting 0->364 */
		theyear=0;
		for(cp++; *cp >= '0' && *cp <= '9'; cp++);
		if (*cp != '\0') theyear=atoi(++cp);
		if (*cp == 'c') theyear=ltimret[5];cp++;
		if (*cp == 'n') theyear=ltimret[5]+1;cp++;

		if(i > 1 && !(ltimret[5]%4))		/* If a leap year */
			thedate++;
		if(theyear == 0) {
			if((dayslft=thedate-ltimret[7]) < 0) {
				dayslft = 365-ltimret[7]+thedate;
				if(i < 2 && !(ltimret[5]%4))dayslft++;	/* If a leap year */
			}
		}
		else {
			kspan=9999999;
			dayslft = thedate-ltimret[7]+365*(theyear-ltimret[5])
				+(theyear-ltimret[5])/4;
				if(theyear != ltimret[5] && i < 2 && !(ltimret[5]%4))dayslft++;
		}			/* Close enough for gov't work */
	}
	return(dayslft);
}
/*
 *
 * Test if first 2 characters of two strings are equal.
 *  Program from Stephen Kochan,
 * "Programming in C", Hayden, 1983.
 *
 */
int equal_first_2_chars (s1,s2)
	char s1[],s2[];
	{
		int answer;
		answer=1;
		if (s1[0] != s2[0] || s1[1] != s2[1]) answer=0;
			/* answer = 1;	   they are equal
			*  answer = 0;	  they are not equal */
		return (answer);
	}
/*
/*
 *	FOPEN( <name pointer> )
 *
 *	Calls:	open(II)
 *
 *	Called by:	main()
 *
 *	Returns:	<open()>
 */

#ifdef BSD
#define O_RDWR		2
#define O_RDONLY	0
#endif

#ifndef TURBOC
fopen(ptr)		/* Try opening R/W, if doesn't go, try RO */
register char *ptr;
{
	register int fd;

	if((fd=open(ptr,O_RDWR)) < 0) {
		if(debug)printf("Cannot open for writing: %s, fd=%d\n",
				ptr,errno);
		if(errno != 21) return(open(ptr,O_RDONLY));
	}
	return(fd);
}
#endif /* TURBOC */
#ifdef SYSV
/*
 *	CHDIRHOM()
 *
 *	Calls:	chdir(II), getenv(III)
 *
 *	Called by:	main()
 *
 *	Returns:	<chdir>
 */

chdirhome()		/* Make use of getenv() call to find ".dates" */
{
	int chdir() ;
	char *getenv() ;

	return( chdir( getenv(HOME) ) ) ;
}
#endif
