#ifndef __DATA_H
#define __DATA_H

#include "bstring.h"
#include "vector.h"

/* If the default constructor is used, you MUST use the .init function
   or an assert error will occur if you try to use any other function! */


class data
	{
	friend int operator == (const data one, const data two)

	public:

		data (); // if you you this you MUST use the init
			 // function on the data.
		data (bstring hme);
		data (bstring hme, long int loc);
		/* above:
			sets location to 0 if error in reading file.
		*/

		~data ();

		bstring home;

		void init (bstring hme); // this MUST be called if
				// the default constructor is used.

		void init (bstring hme, long int loc);

		void		erase ();


		long int search (bstring the_string, long int loc = 0);
		/* same as below except reads in data */

		long int quicksearch (bstring the_string, long int loc = 0);
		/* find a pattern match in the given data starting with
			data at location loc.

			-1 returned if error in reading data file
			0  returned if no match found
			location  returned if match found */

		long int realfind (int month, int day, int year, long int loc);
		long int realquickfind (int month, int day, int year, long int loc);
		/* realfind & realquickfind are much like quickfind & find -
		   however they (find) based on the real dates versus the
		   next occuring dates.  Also, realfinds find only events
		   that occur on that exact day.  Find/quickfind also
		   report events that WERE to occur, but were missed.

		USED IN CALENDAR.
		*/


		long int quickfind (int month, int day, int year,
			   long int loc = 0);
		 /* see find : EXCEPT quickfind does NOT read in the
			entire data.  It only sets next year,
			month, day and occur level.
		 */


		long int find (int month, int day, int year,
			   long int loc = 0);
		/* above returns:
			-1 = cannot read file
			 0 = match not found
			>0 = match found at returned location

		also -- this CHANGES the data!

		NOTE!  To do a search with a given month and year,
		       but NOT a given date, pass a value of ZERO
		       for day.  NOTE!  You cannot use this if FINDALL
		       is on.  If you try to, an assert error will occur.

		       The class, however, will FAIL an assert if you
		       fail to pass a positive month or year.

		SPECIAL CLASS
		NOTE ----> this finds not only events set to occur
			   on given day, but missed events that were
			   to occur before specified day.

		USED IN MESSAGES */

		int remove ();
			// -1 cannot read

		int write ();
			// -1 cannot read, > 0 = location (okay)
		int read ();
			/*	returns:
				   0 = read file, but no information @
				       given location.
				  -1 = cannot read file
				  -2  = file at given location is marked as
				       deleted.
				  1   = read okay
			*/

	void set_occurance (int type1, int type2, int type3, int type4,
		int type5, int type6);

	void set_real (int month, int day, int year);

	void set_next (int month, int day, int year);

	long int get_loc ();


	int	viewed; // 1 = not viewed, 3 = deleted
	int	next_year;
	int	next_month;
	int	next_day;
	int	occur_level; // 3 = very important, 2 = important, 1 = nonessential
	int	real_year;
	int	real_month;
	int	real_day;
	int	warning;
	int	occur_type1;
	int     occur_type2;
	int	occur_type3;
	int	occur_type4;
	int	occur_type5;
	int	occur_type6;
	int	occur_length;

	vector<bstring>		note;



	private:

	long int	location; // location begs. @ 1, if it is at zero
				  // indicates an error in trying to read
				  // the file.  @ -1 if no data exists.

	int		initialized; // this must be

	bstring 	file_name;
	};

#endif /* __DATA_H */