/* class written by jeff goke, jjgoke@cs.csbsju.edu -- (c) 1994.
   this class may be freely used/distributed as long as credit is
   given to the author, jeff goke */


#include <ctype.h>
#include "prepare.h"
#include "mouser.h"
#include "gifford.h"
#include "vector.h"

prepare::prepare (bstring hm, Mcursor & mouse) : the_mouse (mouse)
	{
	home = hm;
	date d;
	}

prepare::~prepare ()
	{
	}

bstring prepare::destination ()
	{
	gr_clear ();

	write3d (50,"You cannot install INTERMEM Professional in any directory or subdirectory");
	write3d (60,"named \\IMPRO.  Example:  C:\\IMPRO and C:\\UTIL\\IMPRO are");
	write3d (70,"both illegal directories.");

	Bevel nice;
	nice.init(13,187,618,106,THICK);
	nice.show ();

	Gstring dest;
	dest.init(35,254,70,1);
	dest.preset ("C:\\INTERMEM");

	write3d (210,"Enter drive and directory where you want INTERMEM Professional installed");
	dest.show();
	dest.get_input ();
	bstring destin = dest.getstring ();

	if (dest.escapehit())
		{
		closegraph ();

		clrscr ();

		cprintf ("INTERMEM Professional installation was canceled by the user.\n\n\n");

		exit (1);
		}

	return (destin);
	}


void prepare::show ()
	{
	pcx ();
	int loop = 1;

	while (loop)
		{
		gr_clear ();
		loop = is_okay ();
		if (loop == 1)
			{
			gr_clear ();
			the_date ();
			}
		}

	gr_clear ();
	}

void prepare::pcx ()
	{
	Screen screen;
	screen.VGA_480_16();

	bstring the_pcx = home;
	bstring file = "SETUP.PCX";

	the_pcx = home + file;

	PCX pcx;
	pcx.init (the_pcx.return_string(),0,0);
	pcx.show (150,50);

	delay (3000);
	outtextxy (getmaxx()/2-100,getmaxy()-50,"Press any key to continue");
	getch();
	}

int prepare::is_okay ()
	{
	vector<Button> buttons(5);

	date	d;
	getdate (&d);

	gifford	df;

	write3d (getmaxy ()/2-60,"IT IS VERY IMPORTANT THE DATE IS CORRECT");
	write3d (getmaxy ()/2-50,"Your clock reports the date as being");

	bstring the_string = "";
	the_string += df.DayName (df.DayOfWeek (d.da_day, d.da_mon, d.da_year));
	the_string += " ";
	the_string += df.pretty_date (d.da_day, d.da_mon, d.da_year);

	write3d (getmaxy ()/2-30,the_string.return_string());
	write3d (getmaxy ()/2, "Is this correct?");

	the_mouse.init ();
	the_mouse.arm ();
	the_mouse.show ();

	buttons[0].init(getmaxx()/2 - 80,getmaxy()/2+20," Yes ",TEXT);
	buttons[1].init(getmaxx()/2 + 50,getmaxy()/2+20," No ",TEXT);

	mouser 	read_mouse (buttons, 2, the_mouse, 0);
	read_mouse.show();

	int the_exit = 0;

	while (!the_exit)
		{
		char keypress;
		int option = read_mouse.get (keypress);

		keypress = tolower (keypress);

		if (option == 0)
			{
			return 0;
			}
		if (option == 1)
			the_exit = 1;
		if (option == -1 && keypress == 'y')
			{
			return 0;
			}
		if (option == -1 && keypress == 'n')
			the_exit = 1;

		if (option == -1 && keypress == 27) // escape
			{
			closegraph ();

			clrscr ();

			cprintf ("INTERMEM Professional installation was canceled by the user.\n\n\n");

			exit (1);
			}
		}
	return 1;
	}

void prepare::the_date ()
	{
	date new_date;

	gifford df;

	Bevel nice;
	nice.init(128,167,369,112,THICK);

	Gstring g_month;
	g_month.init(305,205,2,0);
	Gstring g_year;
	g_year.init(305,233,4,0);
	Gstring g_day;
	g_day.init(305,260,2,0);
//	Gtext question;
//	question.init(144,178,"Please enter the correct date.",0,7,1);
	write3d (178,"Please enter the correct date.");
//	Gtext da_month;
//	da_month.init(235,200,"Month:",0,7,1);
//	Gtext da_year;
//	da_year.init(235,229,"Year:",0,7,1);
//	Gtext da_day;
//	da_day.init(236,256,"Day:",0,7,1);
//	question.show();

// do month
	settextjustify(CENTER_TEXT,TOP_TEXT);
	setcolor(WHITE);
	outtextxy (235,200,"Month:");
	g_month.show();
	g_month.get_input ();

	int month_num = 0;
	bstring month_string;
	month_string = g_month.getstring();
	if (strlen(month_string) == 2)
		month_num = ((month_string[0]-48) * 10) + month_string[1] -48;
	else
		month_num = month_string[0] - 48;
	if (month_num < 1 || month_num > 12)
		return;

// do year
	settextjustify(CENTER_TEXT,TOP_TEXT);
	setcolor(WHITE);
	outtextxy (235,229,"Year:");
	g_year.show();
	g_year.get_input ();

	int year_num = 0;
	bstring	year_string;
	year_string = g_year.getstring();
	if (strlen(year_string) != 4)
		return;
	else
		year_num = (year_string[0]-48) * 1000 + (year_string[1]-48) * 100 +
			(year_string[2]-48) * 10 + (year_string[3]-48);

	if (!year_string || year_num < 1900)
		return;

// day
	settextjustify(CENTER_TEXT,TOP_TEXT);
	setcolor(WHITE);
	outtextxy (235,256,"Day:");
	g_day.show();
	g_day.get_input ();

	int day_num = 0;
	bstring day_string;
	day_string = g_day.getstring();
	if (strlen(day_string) == 2)
		day_num = ((day_string[0]-48) * 10) + day_string[1] -48;
	else
		day_num = day_string[0] - 48;

	if (day_num < 1 || day_num > df.DaysInMonth (month_num, year_num))
		return;

	new_date.da_mon = month_num;
	new_date.da_year = year_num;
	new_date.da_day = day_num;

	setdate (&new_date);
	}

void prepare::write3d (int y,char *text)
	{
	settextjustify(CENTER_TEXT,TOP_TEXT);
	setcolor(BLACK);
	outtextxy(getmaxx()/2,y,text);
	setcolor(WHITE);
	outtextxy((getmaxx()/2)-1,y-1,text);
	}

void prepare::gr_clear (void)
	{
	the_mouse.hide();
	setfillstyle (SOLID_FILL,BLUE);
	bar (0,0,getmaxx(),getmaxy());
	}