/* This file and the accompanying mouser.cpp file are intended for use
   with David S. Reinhart's Object Ease.  This class may be freely used
   as long as, in the documentation, it is acknowledged that this class
   was used in your program.

   Author of Mouser.H :  Jeff Goke, email at jjgoke@norcia.cs.csbsju.edu

   Description:  Mouser.H takes an array of Buttons and then waits for
		 input.

	    (0) #include "mouser.h" in your program, DO NOT INCLUDE GUI.H
		IN YOUR PROGRAM!
	    (1) declare your array of buttons and initialize them.
	    (2) declare mouser var(array_of_buttons, number_of_buttons,
				   the_mouse, default);
		-- note the default is optional : it draws an outline
		   around the defaulted item, and if enter is pressed
		   it returns the value of the default item.
	    (3) use var.show() to show your button array.
	    (4) call option = var.get (the_mouse, char_keypress); where
		the_mouse is your extern Mcursor.  option will be set
		to -1 if a key was pressed otherwise it will represent
		the element # in your array.  if option = -1 keypress
		will return the key that was pressed.

		Element # - so if you had button[0] being "EXIT" and
		that button was pressed, zero would be returned.


		STRIPPED DOWN SETUP VERSION DOES NOT INCLUDE
		BELOW!

*/

#ifndef __MOUSER_H
#define __MOUSER_H

#include "vector.h"
#include "gui.h"

class mouser
	{
	public:
		mouser(const vector<Button> & the_buttons, const int & the_number, Mcursor & mouse, int def = -1);
/*		mouser(Button * the_buttons, int the_number); */
		~mouser();

		void init (const vector<Button> & the_buttons, const int & the_number, int def = -1);

/* init Allows you to reinitialize the buttons being used. */

		void show (void);
		int get (char & keypress);
//		int get (char & keypress, vector<Gstring> & strings, int num_strings);

	private:

		int check_buttons(int &);
//		int check_strings (vector<Gstring> & strings, int num_strings);


		int  the_default;
		Mcursor & the_mouse;
		vector<Button>		buttons;
/*		button		* buttons; */
		int	num_buttons;
	};
#endif /* __MOUSER_H */