/*
**  NUMCNVRT.H - Header file for SNIPPETS numerical <=> string conversions
*/

/* Public domain from SNIPPETS, see snippets.org */

#ifndef NUMCNVRT__H
#define NUMCNVRT__H

#include <stddef.h>		/* For size_t     */
#include "sniptype.h"


/*
**  Callable library functions begin here
*/

size_t commafmt (char *buf, int bufsize, long N);	/* Commafmt.C     */

char *ltostr (long num, char *string, size_t max_chars, unsigned base);	/* Ltostr.C       */

char *ordinal_text (int number);	/* Ord_Text.C     */

#if defined(__ZTC__) && !defined(__SC__)
char *ltoa (long val, char *buf, int base);	/* Ltoa.C         */
#endif




#endif /* NUMCNVRT__H */
