/* str_fun.c
   Stringfunktionen fr eigene Programmprojekte Version fuer
   Kommandozeilenprogramme
*/

#include <stdio.h>
#include <string.h>

#include <ctype.h>
#include <conio.h>
#include <math.h>
#include <stdlib.h>
#include "str_fun.h"


void upper(char * sp)
{
  int i;
  for (i = 0; i < strlen(sp) ; i++)
  {
    if (sp[i]=='') sp[i]='';
    else if (sp[i]=='') sp[i]='';
    else if (sp[i]=='') sp[i]='';
    else if (sp[i]=='') sp[i]='';
    else if (sp[i]=='') sp[i]='';
    else if (sp[i]=='') sp[i]='';
    else if (sp[i]=='') sp[i]='';
    else if (sp[i]=='') sp[i]='';

    sp[i] = toupper(sp[i]);
  }
  sp[i] = '\0';
}



int countitem(const char * s1, const char * sepstring)
/*
 gibt die Anzahl der Wrter in s1 zurck, Wrter sind durch die
 in sepstring enthaltenen Zeichen getrennten Zeichenketten
*/

{
     unsigned int i     = 0;
     unsigned int count = 0;
     unsigned int len   = strlen(s1);
     while (i < len)
     {
       while ((i < len) && strchr(sepstring,s1[i])) i++;
       if (i<len) count++;
       while ((i < len) && strchr(sepstring,s1[i])==NULL) i++;
     }
     return count;
}

void extractitem(int num, const char * s1, const char * sepstring, char * itemstr)
/*
  in itemstr wird das num-te Wort in s1 zurckgegeben, Woerter sind durch die
  in sepstring enthaltenen Zeichen getrennten Zeichenketten.
  zuvor einen itemstring der Lnge strlen(s1)+1 bereitstellen
*/

{
     unsigned int i     = 0;
     unsigned int count = 0;
     unsigned int len   = strlen(s1);
     char zwstr[10];
     strcpy(itemstr,"");

     while (i < len)
     {
       while ((i < len) && strchr(sepstring,s1[i])) i++;
       if (i<len) count++;
       while ((i < len) && strchr(sepstring,s1[i])==NULL)
       {
          if (count==num)
          {
             zwstr[0] = s1[i];
             zwstr[1] = '\0';
             strncat(itemstr,zwstr,1);
          }
          i++;
        }
     }
}


void komma_in_punkt(char * zeile)
{
  int i;
  for (i = 0;i < strlen(zeile); i++)
  {
    if (zeile[i] == ',')
         zeile[i] = '.';
  }
}


void string_in_long(const char *s, long * zahl, int * f_code)
{
   int lauf;
   double testwert;
   * zahl = atol(s);
   * f_code = 1;
   testwert = 0;
   for (lauf = 1;lauf < strlen(s); lauf++)
   {
     if (!isdigit(s[lauf]))
        *f_code=0;
   }
   testwert = atof(s);
   if (fabs(testwert) >= 2147483647L)
     * f_code = 0;
   if ((* zahl==0) && (strcmp("0",s)!=0))
     * f_code = 0;
}

void string_in_double(char *s, double * zahl, int * f_code)
{

   int lauf;
   komma_in_punkt(s);
   * f_code = 1;     /* Umwandlung erfolgreich */


   if ((s[0]=='e') || (s[0]=='E'))
      *f_code = 0;   /* Umwandlung fehlerhaft */

   if (!strlen(s))
   {
      * f_code = 0;
      * zahl = 0;
   }
   else
      {
      if ((s[0]=='-') || (s[0]=='+'))
      {
        for (lauf = 1;lauf < strlen(s); lauf++)
        {
          if ((!isdigit(s[lauf])) &&
              (s[lauf] != '.') &&
              (s[lauf] != 'e') &&
              (s[lauf] != 'E'))
                 * f_code = 0;
        }
      }
      else
      {
        for (lauf = 0;lauf < strlen(s); lauf++)
        {
          if ((!isdigit(s[lauf])) &&
              (s[lauf] != '.') &&
              (s[lauf] != 'e') &&
              (s[lauf] != 'E'))
                 * f_code=0;
        }
      }
      * zahl = atof(s);
   }
}





/*
   fgt das Zeichen 'c1' nach der Position 'posit' in 'str1' ein -
   wenn posit grer als die Lnge von str1, wird c1 hinten angehngt
*/

void str_ins_char(char * str1,char c1,int posit)
{
  int i;
  /* wenn hier unsigned int steht, strzt das Programm ab */

  if (posit < 0) posit = 0;
  if (posit > strlen(str1)) posit = strlen(str1);
  i=strlen(str1);
  str1[i+1]='\0';
  for (i=strlen(str1);i >= posit;i--)
  {
    if (i > posit)
    {
      str1[i] = str1[i-1];
    } else
    {
      str1[i] = c1;
    }
  }
  /* str1[strlen(str1)+1]='\0'; gendert am 14.11.1995 */
  str1[strlen(str1)]='\0';
}


void str_del_char(char * str1, int posit)
{
  int i;
  if (posit < 1) return;
  if (strlen(str1)==0) return;
  if (posit > strlen(str1)) return;
  for (i=posit;i <= strlen(str1)-1;i++)
  {
      str1[i-1] = str1[i];
  }
  str1[strlen(str1)-1]='\0';
}



void ltrim(char * zeile, const char c)
{
   unsigned int i,laenge;

   while ((strlen(zeile)> 0 ) && (zeile[0]==c))
   {
      laenge = strlen(zeile);
      for (i=0; i<=laenge-1;i++)
        zeile[i] = zeile[i+1];
   }
}

void rtrim(char * zeile, const char c)
{
    unsigned int laenge;
    while ((strlen(zeile) > 0) && (zeile[strlen(zeile)-1]==c))
    {
        laenge = strlen(zeile);
        zeile[laenge-1] = '\0';
    }
}

void trim (char * zeile, const char c)
{
    rtrim(zeile,c);
    ltrim(zeile,c);
}


/*
    Gibt zurck:
    1..strlen(textzeile)-strlen(subs), wenn subs in textzeile
       enthalten ist;
    0, wenn subs in textzeile nicht enthalten ist.
*/


unsigned int is_substring(const char * subs, const char * textzeile)
{
   char * ptr;
   if ((strlen(subs)==0) || (strlen(textzeile)==0))
   {
      return 0;
   }
   if (strlen(subs) > strlen(textzeile))
   {
      return 0;
   }
   ptr = strstr(textzeile,subs);
   if (ptr==NULL)
      return 0;

   else return ((unsigned int) ptr - (unsigned int) textzeile + 1);
}


/*
   wwrap fgt Zeilenumbrche in den String 'tzeile' ein, so da Zeilen
   mit der maximalen Lnge 'zlaenge' entstehen. Umbrche entstehen durch
   Ersetzen von ' ' durch '\n'. Wrter, die lnger als 'tzeile' sind,
   werden nicht getrennt.
*/

void wwrap(char * tzeile, long zlaenge)
{
   unsigned int i,j,k,laenge;

   i = 0;
   j = 0;
   k = 0;
   laenge = strlen(tzeile);
   for (;;)
   {
      if (j >= laenge-1)        return;
      if ((laenge-i) < zlaenge) return;
      do
      {
        j++;
        if ((tzeile[j]=='\0') || (tzeile[j]=='\n') || (tzeile[j]==' ')) break;
      } while (1);
      if ((j-i) < zlaenge)
      {
         k = j;
         continue;
      }
      if (k >= (laenge-1)) return;
      if (k!=0)  tzeile[k] = '\n';
      i = k;
      k = j;
   }
}


int strlimcat(char * dest, const char * src, long maxl)
{
   if ((strlen(dest) + strlen(src)) < maxl)
   {
      strcat(dest,src);
      return 1;
   }
   return 0;
}


int strcmp_fun(const char * s1,const char * s2,const char * sortstring)
{
    char * ptr;
    unsigned int l1, l2;
    unsigned int i, min_l;
    long pos1, pos2;

    l1 = strlen(s1); l2 = strlen(s2);
    if (l1 <= l2) min_l = l1; else min_l = l2;

    if((l1==0) && (l2==0))
       return 0;
    if ((l1==0) && (l2 > 0))
       return -1;
    if ((l2==0) && (l1 > 0))
       return 1;

    for (i=0;i<=min_l-1;i++)
    {
        ptr = strchr(sortstring,s1[i]);
        if (ptr==NULL) pos1 = -1;
           else pos1=ptr - (char *) sortstring;

        ptr = strchr(sortstring,s2[i]);
        if (ptr==NULL) pos2 = -1;
           else pos2=ptr - (char *) sortstring;

        if (pos1 < pos2) return -1;
        if (pos1 > pos2) return 1;
    }
    if (l1 < l2) return -1;
    else if (l1 > l2) return 1;
     else return 0;
}

/* ist fname ein gltiger Dateiname? */

int isdosfilename(const char * fname)
{
   int i;
   char charmenge[] ="AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz"
                     "1234567890_";
   if (strlen(fname) < 1) return 0;
   if (strlen(fname) > 8) return 0;
   for (i=0;i<=strlen(fname)-1;i++)
   {
      if ((strchr(charmenge,fname[i])) == NULL)  return 0;
   }
   return 1;
}

/* kompletten Dateinamen untersuchen */

int isdosfilename2(const char * fname)
{
   int i,laenge,punkt_gelesen;

   char charmenge[] ="AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz"
                     "1234567890_";
   laenge=strlen(fname);
   punkt_gelesen = 0; /* ein Punkt wurde bereits gelesen */

   if (laenge < 1) return 0;

   if (laenge > 12) return 0;
   for (i=0;i<=laenge-1;i++)
   {
      if (fname[i]=='.')
      {
         if (punkt_gelesen) return 0;  /* zweiter Punkt */
             else punkt_gelesen = 1;

         if (i==0) return 0;
         if (i>8) return 0; /* mehr als 8 Zeichen vor dem Punkt */
         if (laenge-i <= 4)
         {
           continue;
         }
         else return 0;
      }
      else
      {
         if (!punkt_gelesen && i > 7) return 0;
                  /* mehr als 8 Zeichen vor dem Punkt */
      }
      if ((strchr(charmenge,fname[i])) == NULL)  return 0;
   }
   return 1;
}


/*
   Extrahiert aus instring ab position eine Teilzeichenkette der Lnge
   laenge und kopiert diesen nach outstring. Die Position des ersten
   Zeichens sei 0 die Position des letzten Zeichens strlen(instring)-1.
*/

void extract_subs(
                  char * outstring,
                  const char * instring,
                  unsigned position,
                  unsigned laenge
                 )
{
   unsigned slaenge, i,j;
   i=0;j=0;
   slaenge = strlen(instring);
   strcpy(outstring,"");
   for (i=0;i<=slaenge-1;i++)
   {
      if (i>=position && i<position+laenge)
      {
         outstring[j]=instring[i];
         j++;
      }
   }
   outstring[j]='\0';
}



int locate_substring(const char * subs, const char * textzeile)
{
   char * ptr;
   if ((strlen(subs)==0) || (strlen(textzeile)==0))
   {
      return -1;
   }
   if (strlen(subs) > strlen(textzeile))
   {
      return -1;
   }
   ptr = strstr(textzeile,subs);
   if (ptr==NULL)
   {
      return -1;
   }
   else return ((int) ptr - (int) textzeile);
}

/*
   lokalisiert 'subs' ab einer bestimmten Position 'pos' in 'textzeile',
   der erste Buchstabe in Textzeile ist 0;
*/

int locate_substring_from_pos(const char * subs, const char * textzeile, int pos)
{
   char * ptr;
   if (pos < 0)
   {
      return -1;
   }
   if ((strlen(subs)==0) || (strlen(textzeile) - pos <= 0))
   {
      return -1;
   }
   if (strlen(subs) > strlen(textzeile+pos))
   {
      return -1;
   }
   ptr = strstr(textzeile+pos,subs);
   if (ptr==NULL)
   {
      return -1;
   }
   else return ((int) ptr - (int) textzeile);
}


/*
   Funktion:
   search-replace: fuehrt Strinoperation suchen-ersetzen aus: in 'ziel'
   wird die Zeichenkette 'such' durch 'ers' ersetzt, aber nur, wenn der
   resultierende String nicht laenger als 'maxlen' wuerde. Der Puffer
   'zieltemp' wird temporaer gebraucht, er soll mindestens 'maxlen+1'
   Bytes aufnehmen koennen. Die Ziffer 'pos_vor_rest' kennzeichnet die
   Position im Zielstring, ab der beim naechsten Aufruf weiter ersetzt
   werden soll.

   Rueckgabewerte:
   1 : 'search-replace' erfolgreich ausgefuehrt, eine Wiederholung ist
       solange zu empfehlen, bis Rueckgabewert !=1, im Regelfall 0.

   0 : 'such' nicht (mehr) gefunden

   -1: 'such' wurde nicht durch 'ers' ersetzt, da Ziel sonst laenger
       als maxlen geworden waere, das Anwendungsprogramm muss ueber
       eine solche Fehlermeldung berichten!

   -2: 'such' wurde nicht durch 'ers' ersetzt, da 'such' oder 'ziel'
       ein leerer String ist, auf diese Bedingung muss man i. A.
       nicht reagieren.

   -3: 'such' wurde nicht durch 'ers' ersetzt, da 'such' und 'ers'
       identisch sind

*/

int serepl(char * ziel,
           const char * such,
           const char * ers,
           int maxlen,
           int * pos_vor_rest,
           char * zieltemp)
{
   int return_ok;
   int ziel_len;
   int such_len;
   int ers_len;
   /*
     pos1: Beginn von 'such' und ('ziel'),
   */
   int pos1;
   return_ok = 0;

   if(strlen(such)==0 || strlen(ziel)==0)
   {
      return_ok = -2;
      return return_ok;
   }

   if (!strcmp(such,ers))
   {
      return_ok = -3;
      return return_ok;
   }
   /*
   if (is_substring(such,ers))
   {
      return_ok = -4;
      return return_ok;
   }
   */

   ziel_len = strlen(ziel);
   such_len = strlen(such);
   ers_len = strlen(ers);

   /* nachsehen, ob such in ziel enthalten ist */

   pos1 = locate_substring_from_pos(such,ziel,* pos_vor_rest);
   if (pos1==-1)
   {
      return_ok = 0;
      return return_ok;
   }

   if ((ziel_len-such_len+ers_len) > maxlen)
   {
      return_ok = -1;
      return return_ok;
   }
   strcpy(zieltemp,ziel);

   /* in den folgenden Zeilen wird die Funktion ausgefuehrt */
   ziel[0] = '\0';
   if (pos1 > 0)
   {
       extract_subs(ziel, zieltemp, 0, pos1);
   }
   strcat(ziel,ers);
   /* an dieser Stelle wird beim naechsten Programmaufruf weitergemacht */
   * pos_vor_rest = strlen(ziel);
   strcat(ziel,(zieltemp+pos1+such_len));

   return_ok = 1;
   return return_ok;
}

/*
 Diese Funktion wertet die Kommandozeilenparameter eines Programms aus.
 Die Funktion kann nur von 'main()' aus aufgerufen werden. Als erste beide
 Argumente sind argc und argv zu uebergeben. Als 'muster' ist die Kennung
 eines Kommanozeilenparameters zu uebergeben wie "-p" oder "+", "/path"
 "/?" Die Funktion gibt in 'aus' zurueck, was an 'muster' angehaengt
 gefunden wurde: z. B. 'c:\test' bei muster '-p' und dem
 Kommandozeilenparameter '-pc:\test'. Die Funktion gibt 0 zurueck, wenn
 kein Kommandozeilenparameter gefunden wurde, '1' wenn ein
 Kommandozeilenparameter mit 'muster' gefunden wurde, dabei wird in 'aus'
 eine leere Zeichenkette zurueckgegeben, wenn an 'muster' in der
 Kommandozeile nichts angehaengt war.
*/


int parameter_auswerten_str(int ac, char * av[], char * muster, char * aus)
{
   int i;

   strcpy(aus,"");
   for (i=0;i<ac;i++)
   {
      if(locate_substring(muster,av[i])==0)
      {
         extract_subs(aus,av[i],strlen(muster),PFAD_LEN);
         return 1;
      }
   }
   return 0;
}

/* Beispiel: -z34 gib 32 zurueck */

int parameter_auswerten_long(int ac, char * av[], char * muster, long * wert)
{
   char zs[PFAD_LEN];
   int ok,i;
   strcpy(zs,"");
   for (i=0;i<ac;i++)
   {
      if(locate_substring(muster,av[i])==0)
      {
         extract_subs(zs,av[i],strlen(muster),PFAD_LEN);
         string_in_long(zs,wert,&ok);
         if(!ok)
         {
           * wert = 0;
           return 0;
         }
         return 1;
      }
   }
   return 0;
}

