*-------------------------------------------------------------------------------
*-- Program...: MEASURE.PRG
*-- Programmer: Ken Mayer (KENMAYER)
*-- Date......: 06/25/1992
*-- Notes.....: These routines handle conversion from various forms of 
*--             measurement to others ... see the file: README.TXT for details
*--             on the use of this library file.
*-------------------------------------------------------------------------------

FUNCTION Kg2Lb
*-------------------------------------------------------------------------------
*-- Programmer..: Jay Parsons (JPARSONS)
*-- Date........: 11/05/90
*-- Notes.......: converts kilograms to pounds
*-- Written for.: dBASE IV
*-- Rev. History: None
*-- Calls.......: None
*-- Called by...: Any
*-- Usage.......: Kg2Lb(<nKg>)
*-- Example.....: ? Kg2Lb(40)
*-- Returns.....: dBASE number
*-- Parameters..: nKg -- mass in kilograms
*-------------------------------------------------------------------------------

	parameters nKg
	
RETURN nKg / 0.45359237
*--EoF: Kg2Lb()

FUNCTION Lb2Kg
*-------------------------------------------------------------------------------
*-- Programmer..: Jay Parsons (JPARSONS)
*-- Date........: 11/05/90
*-- Notes.......: converts pounds to kilograms
*-- Written for.: dBASE IV
*-- Rev. History: None
*-- Calls.......: None
*-- Called by...: Any
*-- Usage.......: Lb2Kg(<nPounds>)
*-- Example.....: ? Lb2Kg(66)
*-- Returns.....: dBASE number
*-- Parameters..: nPounds -- mass in pounds
*-------------------------------------------------------------------------------

	parameters nPounds
	
RETURN nPounds * 0.45359237
*-- EoF: Lb2Kg()

FUNCTION Inch2Cm
*-------------------------------------------------------------------------------
*-- Programmer..: Jay Parsons (JPARSONS)
*-- Date........: 11/05/90
*-- Notes.......: converts inches to centimeters
*-- Written for.: dBASE IV
*-- Rev. History: None
*-- Calls.......: None
*-- Called by...: Any
*-- Usage.......: Inch2Cm(<nInches>)
*-- Example.....: ? inch2cm(12)
*-- Returns.....: dBASE number
*-- Parameters..: nInches -- length in inches
*-------------------------------------------------------------------------------

	parameters nInches
	
RETURN nInches * 2.54
*--EoF: Inch2Cm()

FUNCTION Cm2Inch
*-------------------------------------------------------------------------------
*-- Programmer..: Jay Parsons (JPARSONS)
*-- Date........: 11/05/90
*-- Notes.......: converts centimeters to inches
*-- Written for.: dBASE IV
*-- Rev. History: None
*-- Calls.......: None
*-- Called by...: Any
*-- Usage.......: Cm2Inch(<nCm>)
*-- Example.....: ? cm2inch(100)
*-- Returns.....: dBASE number
*-- Parameters..: nCm -- length in Cm
*-------------------------------------------------------------------------------

	parameters nCm
	
RETURN nCm / 2.54
*-- EoF: Cm2Inch()

FUNCTION Km2Mile
*-------------------------------------------------------------------------------
*-- Programmer..: Jay Parsons (JPARSONS)
*-- Date........: 03/01/92
*-- Notes.......: converts kilometers to miles
*-- Written for.: dBASE IV
*-- Rev. History: Ver. 1.1 eliminates one multiplication
*-- Calls.......: None
*-- Called by...: Any
*-- Usage.......: Km2Mile(<nKm>)
*-- Example.....: ? km2mile(80)
*-- Returns.....: dBASE number
*-- Parameters..: nKm -- length in kilometers
*-------------------------------------------------------------------------------

	parameters nKm
	
RETURN nKm / 1.609344
*-- EoF: Km2Mile()

FUNCTION Mile2Km
*-------------------------------------------------------------------------------
*-- Programmer..: Jay Parsons (JPARSONS)
*-- Date........: 03/01/92
*-- Notes.......: converts Miles to Kilometers
*-- Written for.: dBASE IV
*-- Rev. History: Ver. 1.1 eliminates one multiplication
*-- Calls.......: None
*-- Called by...: Any
*-- Usage.......: mile2km(<nMiles>)
*-- Example.....: ? mile2km(50)
*-- Returns.....: dBASE number
*-- Parameters..: nMiles -- length in miles
*-------------------------------------------------------------------------------

	parameters nMiles
	
RETURN nMiles * 1.609344
*-- EoF: Mile2Km()

FUNCTION Km2Naut
*-------------------------------------------------------------------------------
*-- Programmer..: Jay Parsons (JPARSONS)
*-- Date........: 03/01/92
*-- Notes.......: converts Kilometers to Nautical Miles
*-- Written for.: dBASE IV
*-- Rev. History: None
*-- Calls.......: None
*-- Called by...: Any
*-- Usage.......: Km2Naut(<nKm>)
*-- Example.....: ? Km2Naut(50)
*-- Returns.....: dBASE number
*-- Parameters..: nKm -- length in kilometers
*-------------------------------------------------------------------------------

	parameters nKm
	
RETURN nKm / 1.852
*-- EoF: Km2Naut

FUNCTION Naut2Km
*-------------------------------------------------------------------------------
*-- Programmer..: Jay Parsons (JPARSONS)
*-- Date........: 03/01/92
*-- Notes.......: converts Nautical Miles to Kilometers
*-- Written for.: dBASE IV
*-- Rev. History: None
*-- Calls.......: None
*-- Called by...: Any
*-- Usage.......: Naut2Km(<nNautMiles>)
*-- Example.....: ? Naut2km(50)
*-- Returns.....: dBASE number
*-- Parameters..: nNautMiles -- length in miles
*-------------------------------------------------------------------------------

	parameters nNautmiles
	
RETURN nNautmiles * 1.852
*-- EoF: Naut2Km()

FUNCTION Naut2Stat
*-------------------------------------------------------------------------------
*-- Programmer..: Jay Parsons (JPARSONS)
*-- Date........: 03/01/92
*-- Notes.......: converts Nautical Miles to Statute Miles
*-- Written for.: dBASE IV
*-- Rev. History: None
*-- Calls.......: None
*-- Called by...: Any
*-- Usage.......: Naut2Stat(<nNautMiles>)
*-- Example.....: ? Naut2Stat(50)
*-- Returns.....: dBASE number
*-- Parameters..: nNautMiles -- length in miles
*-------------------------------------------------------------------------------

	parameters nNautmiles
	
RETURN nNautmiles * 1.150779448
*-- EoF: Naut2Stat()

FUNCTION Stat2Naut
*-------------------------------------------------------------------------------
*-- Programmer..: Jay Parsons (JPARSONS)
*-- Date........: 03/01/92
*-- Notes.......: converts Statute Miles to Nautical Miles
*-- Written for.: dBASE IV
*-- Rev. History: None
*-- Calls.......: None
*-- Called by...: Any
*-- Usage.......: Stat2Naut(<nStatMiles>)
*-- Example.....: ? Stat2Mile(50)
*-- Returns.....: dBASE number
*-- Parameters..: nStatMiles -- length in miles
*-------------------------------------------------------------------------------

	parameters nstatmiles
	
RETURN nStatmiles / 1.150779448
*-- EoF: Stat2Naut()

FUNCTION Fahr2Cel
*-------------------------------------------------------------------------------
*-- Programmer..: Jay Parsons (JPARSONS)
*-- Date........: 03/01/92
*-- Notes.......: converts Fahrenheit to Celsius
*-- Written for.: dBASE IV
*-- Rev. History: None
*-- Calls.......: None
*-- Called by...: Any
*-- Usage.......: Fahr2Cel(<nFahrTemp>)
*-- Example.....: ? Fahr2Cel(50)
*-- Returns.....: dBASE number
*-- Parameters..: nFahrTemp -- temperature Fahrenheit
*-------------------------------------------------------------------------------

	parameters nFahrTemp
	
RETURN 5 * (nFahrtemp - 32 ) / 9
*-- EoF: Fahr2Cel()

FUNCTION Cel2Fahr
*-------------------------------------------------------------------------------
*-- Programmer..: Jay Parsons (JPARSONS)
*-- Date........: 03/01/92
*-- Notes.......: converts Celsius to Fahrenheit 
*-- Written for.: dBASE IV
*-- Rev. History: None
*-- Calls.......: None
*-- Called by...: Any
*-- Usage.......: Cel2Fahr(<nCelTemp>)
*-- Example.....: ? Cel2Fahr(50)
*-- Returns.....: dBASE number
*-- Parameters..: nCelTemp -- temperature Celsius
*-------------------------------------------------------------------------------

	parameters nCelTemp
	
RETURN 9 * nCelTemp / 5 + 32
*-- EoF: Cel2Fahr()

FUNCTION Gal2Ltr
*-------------------------------------------------------------------------------
*-- Programmer..: Jay Parsons (JPARSONS)
*-- Date........: 03/01/92
*-- Notes.......: converts Gallons (US) to Liters
*-- Written for.: dBASE IV
*-- Rev. History: None
*-- Calls.......: None
*-- Called by...: Any
*-- Usage.......: Gal2Ltr(<nGal>)
*-- Example.....: ? Gal2Ltr(50)
*-- Returns.....: dBASE number
*-- Parameters..: nGal -- US Gallons
*-------------------------------------------------------------------------------

	parameters nGal
	
RETURN nGal * 3.785411784
*-- EoF: Gal2Ltr()

FUNCTION Ltr2Gal
*-------------------------------------------------------------------------------
*-- Programmer..: Jay Parsons (JPARSONS)
*-- Date........: 03/01/92
*-- Notes.......: converts Liters to Gallons (US) 
*-- Written for.: dBASE IV
*-- Rev. History: None
*-- Calls.......: None
*-- Called by...: Any
*-- Usage.......: Ltr2Gal(<nLiter>)
*-- Example.....: ? Ltr2Gal(50)
*-- Returns.....: dBASE number
*-- Parameters..: nLiter -- Liters
*-------------------------------------------------------------------------------

	parameters nLiter
	
RETURN nLiter / 3.785411784
*-- EoF: Ltr2Gal()

FUNCTION CuFt2Gal
*-------------------------------------------------------------------------------
*-- Programmer..: Jay Parsons (JPARSONS)
*-- Date........: 03/01/92
*-- Notes.......: converts Cubic Feet to Gallons (US) 
*-- Written for.: dBASE IV
*-- Rev. History: None
*-- Calls.......: None
*-- Called by...: Any
*-- Usage.......: CuFt2Gal(<nCubic>)
*-- Example.....: ? CuFt2Gal(50)
*-- Returns.....: dBASE number
*-- Parameters..: nCubic -- Cubic Feet
*-------------------------------------------------------------------------------

	parameters nCubic
	
RETURN nCubic * 1728 / 231
*-- EoF: CuFt2Gal()

FUNCTION Gal2CuFt
*-------------------------------------------------------------------------------
*-- Programmer..: Jay Parsons (JPARSONS)
*-- Date........: 03/01/92
*-- Notes.......: converts Gallons (US) to Cubic Feet
*-- Written for.: dBASE IV
*-- Rev. History: None
*-- Calls.......: None
*-- Called by...: Any
*-- Usage.......: Gal2CuFt(<nGal>)
*-- Example.....: ? Gal2CuFt(50)
*-- Returns.....: dBASE number
*-- Parameters..: nGal -- Gallons
*-------------------------------------------------------------------------------

	parameters nGal
	
RETURN nGal * 231 / 1728
*-- EoF: Gal2CuFt()

*-------------------------------------------------------------------------------
*-- EoP: MEASURE.PRG
*-------------------------------------------------------------------------------
