/*ͻ*\
   Filename:  FILE\DEL.CPP                    
   Name:      John Wiggins                    
   Course:    Programming II                  
   Function:  Remove record from linked list. 
\*ͼ*/
#include <graphics.h>
#include <stdlib.h>
#include "medusa.h"
#include "msi_wndw.h"
#include "mous.h"   // includes dos.h
#include "windw.h"  // includes string.h & event.h

void DelData(ProgramPtr &ProgramHead)
{
  // Find record pointer.
  ProgramPtr DelRecord;
  // Used to remove record.
  ProgramPtr TempPtr;
  View2Pick("Remove Record", ProgramHead, DelRecord);
  // Offer the user a last chance.
  YesNoWindw LastChance("Delete record", "Are you sure you wish to",
                        "delete this record?");
  LastChance.DrawWindow();
  LastChance.RunWindow();
  if (LastChance.GetButton() == YES)
  {
    TempPtr = DelRecord;
    // Test to see if the record to be removed is the head and the tail.
    if ((DelRecord->prev == NULL) && (DelRecord->next == NULL))
    {
      TempPtr = ProgramHead;
      ProgramHead = NULL;
    }
    // Test to see if the record to be removed is the head but not also
    // the tail.
    if ((DelRecord->prev == NULL) && (DelRecord->next != NULL))
    {
      TempPtr = ProgramHead;
      ProgramHead = ProgramHead->next;
    }
    // Otherwise, remove the record.
    else
    {
      // Go back one record.
      DelRecord = DelRecord->prev;
      // Skip over to the next record.
      DelRecord->next = TempPtr->next;
      // Go to the record after the one to be removed.
      DelRecord = TempPtr->next;
      // Make the next one linked with the prev.
      if (DelRecord != NULL)
        DelRecord->prev = TempPtr->prev;
    }
    delete TempPtr; // Remove the record.
    mouse.ShowMouse();
  }
  else
  {
    OKWindw NotDeleted("Not Deleted", "Your record was not removed.", "");
    NotDeleted.DrawWindow();
    NotDeleted.RunWindow();
  }
}
