#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include "cmdline.h"
#include "umem.h"
#include "module.h"
#include "data.h"
#include "section.h"
#include "public.h"
#include "extern.h"
#include "errors.h"
#include "local.h"
#include "lines.h"
#include "types.h"

extern BOOL prm_debug;
extern PUBLIC **publictable;
extern EXTERN **externtable;
extern LOCAL **localtable;
extern PUBLIC **publictable;
extern EXTERN **externtable;
extern LOCAL **localtable;
extern FILENAME *nametable[1];

unsigned maxtype;
TYPE *globaltypetable;

static long typebuf[512];
static int typeindex = 1;
static TYPE **typetable;

void SetType(uint mode)
{
	int id;
	char ch, type;
	int module;
	long typenum;
	type = ReadChar();
	id = ReadNumber(0);
	CheckForComma(TRUE);
	ch = ReadChar();
	if (ch != 'T')
		putbackch(ch);
	typenum = ReadNumber(0);
	if (ch == 'T')
		typenum |= TY_TYPE;
	switch (type) {
		case 'I':
			publictable[id]->datatype = typenum;
			break;
		case 'X':
			externtable[id]->datatype = typenum;
			break;
		case 'N':
			CheckForComma(TRUE);
			module = ReadNumber(0);
			LocalRegisterName(mode, id,nametable[module]->id, typenum);
			break;
		default:
			BadObjectFile();
	}
	CheckForPeriod();
}
void ReadType(uint mode)
{
	int ch;
	long typenum = ReadNumber(0);
	int count = 0;
	TYPE *p;
	if (mode == RESOLVE) {
		p = AllocateMemory(sizeof (TYPE));
		p->link = globaltypetable;
		globaltypetable = p;
		p->index = typeindex++;
		typetable[typenum] = p;
	}
	
	CheckForComma(TRUE);
	do {
		ch = ReadChar();
		switch (ch) {
			case 'T':
				typebuf[count] = TY_TYPE;
				break;
			case 'N':
				typebuf[count] = TY_NAME;
				break;
			default:
				typebuf[count] = 0;
				putbackch(ch);
				break;
		}
		typebuf[count++]  += ReadNumber(0);
		
	} while ((ch = ReadChar()) == ',');
	if (mode == RESOLVE) {
		p->count = count;
		p->types = AllocateMemory(sizeof(long) * count);
		memcpy(p->types,typebuf,count * sizeof(long));
	}
	putbackch(ch);
	CheckForPeriod();
}
void TypeModuleRundown(uint mode)
{
	int i;
	if (mode == RESOLVE) {
		PUBLIC **p=publictable;
		EXTERN **e =externtable;
		LOCAL **l = localtable;
		TYPE **t = typetable;
		for (i=0; i< MAX_PUBLICS; i++) {
			if (*p && (*p)->datatype & TY_TYPE)
				(*p)->datatype = typetable[(*p)->datatype &~TY_TYPE]->index | TY_TYPE;
			p++;
		}
		for (i=0; i< MAX_EXTERNS; i++) {
			if (*e && (*e)->datatype & TY_TYPE)
				(*e)->datatype = typetable[(*e)->datatype &~TY_TYPE]->index | TY_TYPE;
			e++;
		}
		for (i=0; i< MAX_LOCALS; i++) {
			if (*l&& (*l)->datatype & TY_TYPE)
				(*l)->datatype = typetable[(*l)->datatype &~TY_TYPE]->index | TY_TYPE;
			l++;
		}
		
		for (i=0; i< MAX_TYPES; i++) {
			*t = 0;
			t++;
		}
	}
}
void TypeTableInit(void)
{
	PUBLIC **p;
	int i;
	typetable = AllocateMemory(sizeof(TYPE *) * MAX_TYPES);
	p = publictable;
	for (i=0; i < MAX_TYPES; i++) {
		*p = 0;
		p++;
	}
	globaltypetable = 0;
}
void TypeTableRundown(void)
{
	TYPE *p = globaltypetable;
	DeallocateMemory(typetable);
	while (p) {
		TYPE *r = p->link;
		DeallocateMemory(p->types);
		DeallocateMemory(p);
		p = r;
	}
}