#include <stdio.h>
#include "cmdline.h"
#include "umem.h"
#include "data.h"
#include "section.h"
#include "output.h"
extern int prm_phipos;
extern int prm_mode;

static long offset;
static int track = 1, sector = 2, block = 1;
static long fs=0;
static int max = 1016;
static BOOL nogood = FALSE;
static void WriteLink(FILE *file, long len)
{
	if (len <= 252 - 5)
		track = sector = 0;
	fputc(track,file);
	fputc(sector,file);
	fputc(block >> 8,file);
	fputc(block & 255, file);
	fs+=4;
  if (sector++ > 68) {
		sector = 1;
		track++;
	}
	block++;
}
static void WriteHeader(FILE *file, uint size, long base)
{
	if (!(fs++ % 256))
		WriteLink(file,0);
	fputc(1,file);
	if (!(fs++ % 256))
		WriteLink(file,0);
	fputc(base >> 24, file);
	if (!(fs++ % 256))
		WriteLink(file,0);
	fputc((base >> 16 ) &0xff, file);
	if (!(fs++ % 256))
		WriteLink(file,0);
	fputc((base >> 8 ) &0xff, file);
	if (!(fs++ % 256))
		WriteLink(file,0);
	fputc((base ) &0xff, file);
	if (!(fs++ % 256))
		WriteLink(file,0);
	fputc(size >> 8, file);
	if (!(fs++ % 256))
		WriteLink(file,0);
	fputc(size & 0xff, file);
}
static void WriteTrailer(FILE *file, long start)
{
	long append;
	if (!(fs++ % 256))
		WriteLink(file,0);
	fputc(0x16,file);
	if (!(fs++ % 256))
		WriteLink(file,0);
	fputc(start >> 24, file);
	if (!(fs++ % 256))
		WriteLink(file,0);
	fputc((start >> 16 ) &0xff, file);
	if (!(fs++ % 256))
		WriteLink(file,0);
	fputc((start >> 8 ) &0xff, file);
	if (!(fs++ % 256))
		WriteLink(file,0);
	fputc((start ) &0xff, file);
	append = 256 - (fs & 255);
	if (append != 256) {
		int i;
		for (i=0; i < append; i++)
			fputc(0,file);
	}
}
static void WriteBlock(FILE *file, BYTE *pos, long size)
{
	while (size) {
		long len = 256 - (fs & 255);
		if (len == 256) {
			WriteLink(file,size);
			len -= 4;
		}
		if (len > size)
			len = size;
		fwrite(pos,1,len,file);
		fs+=len;
		size -= len;
		pos += len;
	}
}
void bit32(long size, FILE * file)
{
	fputc(size>>24,file);
	fputc((size>>16)&0xff,file);
	fputc((size>>8)&0xff,file);
	fputc((size)&0xff,file);
}
void bit64(long size, FILE *file)
{
	fputc(0,file);
	fputc(0,file);
	fputc(0,file);
	fputc(0,file);
	bit32(size,file);
}
void OutputInit(char *q, FILE *file)
{
	max = 1016;
	nogood = FALSE;
}

void OutputRundown(FILE *file)
{
}
void OutputPhiHeader(long size, long base, FILE *file)
{
		rewind(file);
		bit32(size,file);
		bit32(base,file);
}
void OutputData(SECTION *q, char *overlay, FILE *file)
{
	offset = 0;
	if (prm_phipos) {
		long size = q->size;
		while (size) {
			long asize = size <= MAX_EMS_READWRITE ? size : MAX_EMS_READWRITE;
			size -= asize;
			while (asize) {
				int qsize;
				if (max == 0) {
					nogood = FALSE;
					max = 1016; 
				}
				qsize = asize <= max ? asize : max;
				if (!nogood)
					bit64(prm_phipos++,file);
				else {
					nogood = FALSE;
				}
				if (qsize < max) {
					nogood = TRUE;
					max = max - qsize;
				}
				else
					max = 1016;
				asize -= qsize;
				fwrite(PtrToEMSMem(q->buffer,offset),1, qsize,file);
				offset += qsize;
			}
		}
	}
	else {
		if (prm_mode == PRM_MONK) {
			long size = q->size, base = q->base,offset = 0;
			WriteLink(file,size);
			while (size) {
				long asize = size <= MAX_EMS_READWRITE ? size : MAX_EMS_READWRITE;
				WriteHeader(file,asize,base);
				WriteBlock(file, PtrToEMSMem(q->buffer,offset),asize);
				offset += asize;
				base += asize;
				size -= asize;
			}
			WriteTrailer(file,q->base);
		}
		else {
			long offset = 0;
			while (q->size) {
				long size = q->size <= MAX_EMS_READWRITE ? q->size : MAX_EMS_READWRITE;
				BYTE *t = PtrToEMSMem(q->buffer, offset);
				fwrite(t,1,size,file);
				q->size -= size;
				offset += size;
			}
		}
	}
}