/* 1802pst.c */

/*
 * (C) Copyright 2002-2003
 * All Rights Reserved
 *
 * Shujen Chen
 * 605 Balmoral Circle
 * Naperville, IL 60540
 */

#include <stdio.h>
#include <setjmp.h>
#include "asxxxx.h"
#include "1802.h"

/*
 * Coding Banks
 */
struct	bank	bank[2] = {
    /*	The '_CODE' area/bank has a NULL default file suffix.	*/
    {	NULL,		"_CSEG",	NULL,		0,	0,	0,	0,	0	},
    {	&bank[0],	"_DSEG",	"_DS",		1,	0,	0,	0,	B_FSFX	}
};

/*
 * Coding Areas
 */
struct	area	area[2] = {
    {	NULL,		&bank[0],	"_CODE",	0,	0,	0,	A_1BYTE|A_BNK|A_CSEG	},
    {	&area[0],	&bank[1],	"_DATA",	1,	0,	0,	A_1BYTE|A_BNK|A_DSEG	}
};

/*
 * Basic Relocation Mode Definition
 *
 *	#define		R_NORM	0000		No Bit Positioning
 */
char	mode0[32] = {	/* R_NORM */
	'\200',	'\201',	'\202',	'\203',	'\204',	'\205',	'\206',	'\207',
	'\210',	'\211',	'\212',	'\213',	'\214',	'\215',	'\216',	'\217',
	'\220',	'\221',	'\222',	'\223',	'\224',	'\225',	'\226',	'\227',
	'\230',	'\231',	'\232',	'\233',	'\234',	'\235',	'\236',	'\237'
};

/*
 * Additional Relocation Mode Definitions
 *
 * Specification for the 8-bit branch addressing mode:
 */
char	mode1[32] = {	/* R_BR */
	'\200',	'\201',	'\202',	'\203',	'\204',	'\205',	'\206',	'\207',
	'\010',	'\011',	'\012',	'\013',	'\014',	'\015',	'\016',	'\017',
	'\020',	'\021',	'\022',	'\023',	'\024',	'\025',	'\026',	'\027',
	'\030',	'\031',	'\032',	'\033',	'\034',	'\035',	'\036',	'\037'
};

/*
 * Specification for the 3-bit I/O addressing mode:
 */
char	mode2[32] = {	/* R_IO */
	'\200',	'\201',	'\202',	'\003',	'\004',	'\005',	'\006',	'\007',
	'\010',	'\011',	'\012',	'\013',	'\014',	'\015',	'\016',	'\017',
	'\020',	'\021',	'\022',	'\023',	'\024',	'\025',	'\026',	'\027',
	'\030',	'\031',	'\032',	'\033',	'\034',	'\035',	'\036',	'\037'
};

/*
 *     *m_def is a pointer to the bit relocation definition.
 *	m_flag indicates that bit position swapping is required.
 *	m_mask contains the active bit positions for the output.
 *	m_mbro contains the active bit positions for the input.
 *
 *	struct	vsd
 *	{
 *		char *	m_def;		Bit Relocation Definition
 *		int	m_flag;		Bit Swapping Flag
 *		int	m_mask;		Bit Mask
 *		int	m_mbro;		Bit Range Overflow Mask
 *	};
 */
struct	mode	mode[3] = {
    {	&mode0[0],	0,	0x0000FFFF,	0x0000FFFF	},
    {	&mode1[0],	0,	0x000000FF,	0x000000FF	},
    {	&mode2[0],	0,	0x00000007,	0x00000007	}
};

/*
 * Array of Pointers to VSD Structures
 */
struct	mode	*modep[16] = {
	&mode[0],	&mode[1],	&mode[2],	NULL,
	NULL,		NULL,		NULL,		NULL,
	NULL,		NULL,		NULL,		NULL,
	NULL,		NULL,		NULL,		NULL
};

/*
 * Mnemonic Structure
 */
struct	mne	mne[] = {

	/* machine */

    {	NULL,	"CSEG",		S_ATYP,		0,	A_CSEG|A_1BYTE	},
    {	NULL,	"DSEG",		S_ATYP,		0,	A_DSEG|A_1BYTE	},

	/* system */

    {	NULL,	"BANK",		S_ATYP,		0,	A_BNK	},
    {	NULL,	"CON",		S_ATYP,		0,	A_CON	},
    {	NULL,	"OVR",		S_ATYP,		0,	A_OVR	},
    {	NULL,	"REL",		S_ATYP,		0,	A_REL	},
    {	NULL,	"ABS",		S_ATYP,		0,	A_ABS	},
    {	NULL,	"NOPAG",	S_ATYP,		0,	A_NOPAG	},
    {	NULL,	"PAG",		S_ATYP,		0,	A_PAG	},

    {	NULL,	"BASE",		S_BTYP,		0,	B_BASE	},
    {	NULL,	"SIZE",		S_BTYP,		0,	B_SIZE	},
    {	NULL,	"FSFX",		S_BTYP,		0,	B_FSFX	},
    {	NULL,	"MAP",		S_BTYP,		0,	B_MAP	},

    {	NULL,	".page",	S_PAGE,		0,	0	},
    {	NULL,	".title",	S_HEADER,	0,	O_TITLE	},
    {	NULL,	".sbttl",	S_HEADER,	0,	O_SBTTL	},
    {	NULL,	".module",	S_MODUL,	0,	0	},
    {	NULL,	".include",	S_INCL,		0,	0	},
    {	NULL,	".area",	S_AREA,		0,	0	},
    {	NULL,	".bank",	S_BANK,		0,	0	},
    {	NULL,	".org",		S_ORG,		0,	0	},
    {	NULL,	".radix",	S_RADIX,	0,	0	},
    {	NULL,	".globl",	S_GLOBL,	0,	0	},
    {	NULL,	".local",	S_LOCAL,	0,	0	},
    {	NULL,	".if",		S_CONDITIONAL,	0,	O_IF	},
    {	NULL,	".else",	S_CONDITIONAL,	0,	O_ELSE	},
    {	NULL,	".endif",	S_CONDITIONAL,	0,	O_ENDIF	},
    {	NULL,	".ifdef",	S_CONDITIONAL,	0,	O_IFDEF	},
    {	NULL,	".ifndef",	S_CONDITIONAL,	0,	O_IFNDEF},
    {	NULL,	".list",	S_LISTING,	0,	O_LIST	},
    {	NULL,	".nlist",	S_LISTING,	0,	O_NLIST	},
    {	NULL,	".equ",		S_EQU,		0,	O_EQU	},
    {	NULL,	".gblequ",	S_EQU,		0,	O_GBLEQU},
    {	NULL,	".lclequ",	S_EQU,		0,	O_LCLEQU},
    {	NULL,	".byte",	S_DATA,		0,	O_1BYTE	},
    {	NULL,	".db",		S_DATA,		0,	O_1BYTE	},
    {	NULL,	".fcb",		S_DATA,		0,	O_1BYTE	},
    {	NULL,	".word",	S_DATA,		0,	O_2BYTE	},
    {	NULL,	".dw",		S_DATA,		0,	O_2BYTE	},
    {	NULL,	".fdb",		S_DATA,		0,	O_2BYTE	},
/*    {	NULL,	".3byte",	S_DATA,		0,	O_3BYTE	},	*/
/*    {	NULL,	".triple",	S_DATA,		0,	O_3BYTE	},	*/
/*    {	NULL,	".4byte",	S_DATA,		0,	O_4BYTE	},	*/
/*    {	NULL,	".quad",	S_DATA,		0,	O_4BYTE	},	*/
    {	NULL,	".blkb",	S_BLK,		0,	O_1BYTE	},
    {	NULL,	".ds",		S_BLK,		0,	O_1BYTE	},
    {	NULL,	".rmb",		S_BLK,		0,	O_1BYTE	},
    {	NULL,	".rs",		S_BLK,		0,	O_1BYTE	},
    {	NULL,	".blkw",	S_BLK,		0,	O_2BYTE	},
/*    {	NULL,	".blk3",	S_BLK,		0,	O_3BYTE	},	*/
/*    {	NULL,	".blk4",	S_BLK,		0,	O_4BYTE	},	*/
    {	NULL,	".ascii",	S_ASCIX,	0,	O_ASCII	},
    {	NULL,	".ascis",	S_ASCIX,	0,	O_ASCIS	},
    {	NULL,	".asciz",	S_ASCIX,	0,	O_ASCIZ	},
    {	NULL,	".str",		S_ASCIX,	0,	O_ASCII	},
    {	NULL,	".strs",	S_ASCIX,	0,	O_ASCIS	},
    {	NULL,	".strz",	S_ASCIX,	0,	O_ASCIZ	},
    {	NULL,	".fcc",		S_ASCIX,	0,	O_ASCII	},
    {	NULL,	".define",	S_DEFINE,	0,	O_DEF	},
    {	NULL,	".undefine",	S_DEFINE,	0,	O_UNDEF	},
    {	NULL,	".even",	S_BOUNDARY,	0,	O_EVEN	},
    {	NULL,	".odd",		S_BOUNDARY,	0,	O_ODD	},
    {	NULL,	".msg"	,	S_MSG,		0,	0	},
    {	NULL,	".assume",	S_ERROR,	0,	O_ASSUME},
    {	NULL,	".error",	S_ERROR,	0,	O_ERROR	},
/*    {	NULL,	".msb",		S_MSB,		0,	0	},	*/
/*    {	NULL,	".8bit",	S_BITS,		0,	O_1BYTE	},	*/
/*    {	NULL,	".16bit",	S_BITS,		0,	O_2BYTE	},	*/
/*    {	NULL,	".24bit",	S_BITS,		0,	O_3BYTE	},	*/
/*    {	NULL,	".32bit",	S_BITS,		0,	O_4BYTE	},	*/
    {	NULL,	".end",		S_END,		0,	0	},

	/* 1802 */

    {	NULL,	"R0",		S_REG,	0,	R0	},
    {	NULL,	"R1",		S_REG,	0,	R1	},
    {	NULL,	"R2",		S_REG,	0,	R2	},
    {	NULL,	"R3",		S_REG,	0,	R3	},
    {	NULL,	"R4",		S_REG,	0,	R4	},
    {	NULL,	"R5",		S_REG,	0,	R5	},
    {	NULL,	"R6",		S_REG,	0,	R6	},
    {	NULL,	"R7",		S_REG,	0,	R7	},
    {	NULL,	"R8",		S_REG,	0,	R8	},
    {	NULL,	"R9",		S_REG,	0,	R9	},
    {	NULL,	"R10",		S_REG,	0,	R10	},
    {	NULL,	"R11",		S_REG,	0,	R11	},
    {	NULL,	"R12",		S_REG,	0,	R12	},
    {	NULL,	"R13",		S_REG,	0,	R13	},
    {	NULL,	"R14",		S_REG,	0,	R14	},
    {	NULL,	"R15",		S_REG,	0,	R15	},
    {	NULL,	"SP",		S_REG,	0,	R2	},
    {	NULL,	"PC",		S_REG,	0,	R3	},
    {	NULL,	"CALL",		S_REG,	0,	R4	},
    {	NULL,	"RETURN",	S_REG,	0,	R5	},
    {	NULL,	"ARGR",		S_REG,	0,	R6	},

    {	NULL,	"B1",		S_BR,	0,	0x34	},
    {	NULL,	"B2",		S_BR,	0,	0x35	},
    {	NULL,	"B3",		S_BR,	0,	0x36	},
    {	NULL,	"B4",		S_BR,	0,	0x37	},
    {	NULL,	"BDF",		S_BR,	0,	0x33	},
    {	NULL,	"BGE",		S_BR,	0,	0x33	},
    {	NULL,	"BL",		S_BR,	0,	0x38	},
    {	NULL,	"BM",		S_BR,	0,	0x38	},
    {	NULL,	"BN1",		S_BR,	0,	0x3C	},
    {	NULL,	"BN2",		S_BR,	0,	0x3D	},
    {	NULL,	"BN3",		S_BR,	0,	0x3E	},
    {	NULL,	"BN4",		S_BR,	0,	0x3F	},
    {	NULL,	"BNF",		S_BR,	0,	0x38	},
    {	NULL,	"BNQ",		S_BR,	0,	0x39	},
    {	NULL,	"BNZ",		S_BR,	0,	0x3A	},
    {	NULL,	"BPZ",		S_BR,	0,	0x33	},
    {	NULL,	"BQ",		S_BR,	0,	0x31	},
    {	NULL,	"BR",		S_BR,	0,	0x30	},
    {	NULL,	"BZ",		S_BR,	0,	0x32	},
    {	NULL,	"NBR",		S_BR,	0,	0x38	},
    {	NULL,	"ADCI",		S_IMM,	0,	0x7C	},
    {	NULL,	"ADI",		S_IMM,	0,	0xFC	},
    {	NULL,	"ANI",		S_IMM,	0,	0xFA	},
    {	NULL,	"LDI",		S_IMM,	0,	0xF8	},
    {	NULL,	"ORI",		S_IMM,	0,	0xF9	},
    {	NULL,	"SDBI",		S_IMM,	0,	0x7D	},
    {	NULL,	"SDI",		S_IMM,	0,	0xFD	},
    {	NULL,	"SMBI",		S_IMM,	0,	0x7F	},
    {	NULL,	"SMI",		S_IMM,	0,	0xFF	},
    {	NULL,	"XRI",		S_IMM,	0,	0xFB	},
    {	NULL,	"ADC",		S_INH,	0,	0x74	},
    {	NULL,	"ADD",		S_INH,	0,	0xF4	},
    {	NULL,	"AND",		S_INH,	0,	0xF2	},
    {	NULL,	"DIS",		S_INH,	0,	0x71	},
    {	NULL,	"IDL",		S_INH,	0,	0x00	},
    {	NULL,	"IRX",		S_INH,	0,	0x60	},
    {	NULL,	"LDX",		S_INH,	0,	0xF0	},
    {	NULL,	"LDXA",		S_INH,	0,	0x72	},
    {	NULL,	"LSDF",		S_INH,	0,	0xCF	},
    {	NULL,	"LSIE",		S_INH,	0,	0xCC	},
    {	NULL,	"LSKP",		S_INH,	0,	0xC8	},
    {	NULL,	"LSNF",		S_INH,	0,	0xC7	},
    {	NULL,	"LSNQ",		S_INH,	0,	0xC5	},
    {	NULL,	"LSNZ",		S_INH,	0,	0xC6	},
    {	NULL,	"LSQ",		S_INH,	0,	0xCD	},
    {	NULL,	"LSZ",		S_INH,	0,	0xCE	},
    {	NULL,	"MARK",		S_INH,	0,	0x79	},
    {	NULL,	"NOP",		S_INH,	0,	0xC4	},
    {	NULL,	"OR",		S_INH,	0,	0xF1	},
    {	NULL,	"REQ",		S_INH,	0,	0x7A	},
    {	NULL,	"RET",		S_INH,	0,	0x70	},
    {	NULL,	"RSHL",		S_INH,	0,	0x7E	},
    {	NULL,	"RSHR",		S_INH,	0,	0x76	},
    {	NULL,	"SAV",		S_INH,	0,	0x78	},
    {	NULL,	"SD",		S_INH,	0,	0xF5	},
    {	NULL,	"SDB",		S_INH,	0,	0x75	},
    {	NULL,	"SEQ",		S_INH,	0,	0x7B	},
    {	NULL,	"SHL",		S_INH,	0,	0xFE	},
    {	NULL,	"SHLC",		S_INH,	0,	0x7E	},
    {	NULL,	"SHR",		S_INH,	0,	0xF6	},
    {	NULL,	"SHRC",		S_INH,	0,	0x76	},
    {	NULL,	"SKP",		S_INH,	0,	0x38	},
    {	NULL,	"SM",		S_INH,	0,	0xF7	},
    {	NULL,	"SMB",		S_INH,	0,	0x77	},
    {	NULL,	"STXD",		S_INH,	0,	0x73	},
    {	NULL,	"XOR",		S_INH,	0,	0xF3	},
    {	NULL,	"LBDF",		S_LBR,	0,	0xC3	},
    {	NULL,	"LBNF",		S_LBR,	0,	0xC8	},
    {	NULL,	"LBNQ",		S_LBR,	0,	0xC9	},
    {	NULL,	"LBNZ",		S_LBR,	0,	0xCA	},
    {	NULL,	"LBQ",		S_LBR,	0,	0xC1	},
    {	NULL,	"LBR",		S_LBR,	0,	0xC0	},
    {	NULL,	"LBZ",		S_LBR,	0,	0xC2	},
    {	NULL,	"NLBR",		S_LBR,	0,	0xC8	},
    {	NULL,	"DEC",		S_NIB,	0,	0x20	},
    {	NULL,	"GHI",		S_NIB,	0,	0x90	},
    {	NULL,	"GLO",		S_NIB,	0,	0x80	},
    {	NULL,	"INC",		S_NIB,	0,	0x10	},
    {	NULL,	"LDA",		S_NIB,	0,	0x40	},
    {	NULL,	"LDN",		S_NIB,	0,	0x00	},
    {	NULL,	"PHI",		S_NIB,	0,	0xB0	},
    {	NULL,	"PLO",		S_NIB,	0,	0xA0	},
    {	NULL,	"SEP",		S_NIB,	0,	0xD0	},
    {	NULL,	"SEX",		S_NIB,	0,	0xE0	},
    {	NULL,	"STR",		S_NIB,	0,	0x50	},
    {	NULL,	"INP",		S_INP,	0,	0x68	},
    {	NULL,	"OUT",		S_OUT,	S_END,	0x60	}
};
