#include <stdio.h>

typedef unsigned char * block;
typedef unsigned char * wgtfont;
typedef unsigned short * wgtmap;


extern struct {
  short xres;
  short yres;
  short videomode;
  int   videobanksize;
  short (*bankswitch)(short);
  short screenwidth;
  short screenheight;
} WGT_SYS;

extern char kbdon[256];

#define NORMAL 0
#define XRAY 1

/* Text transparency settings */
#define TEXTFG 0
#define TEXTBG 1
#define TEXTFGBG 2


/* A single palette register definition */
typedef struct 
{
  unsigned char r,g,b;
} color;


extern unsigned char *abuf;
extern short xc, yc, cstart, cend, curspeed;
//extern int tx, ty, bx, by;
//extern int ptx, pty, pbx, pby;

/* WGTLIB variables */
extern int lfpos;
extern FILE *libf;
extern short lresult;
extern int   lsize;
extern char  password[16];
extern char  *wgtlibrary;

void setlib (char *libraryname);
void setpassword (char *password_to_set);
void *lib2buf (char *filename);
void findfile (char *filename);
void readheader (void);
short checkpassword (char *temppassword);


/* Timer services */
#define TICKS(hz) (hz)
typedef void (*wtimerproc)(void);
extern volatile int    wtimer_time;

void winittimer (void);
void wdonetimer (void);
void wsettimerspeed (int speed);
void wstarttimer (wtimerproc timer, int speed);
void wstoptimer (void);


void wsetmode (int mode);
void wclip (int x0, int y0, int x1, int y1);
void wsetscreen (block scr);

block wallocblock (short width, short height);
void wfreeblock (block ptr);
short wgetblockwidth (block ptr);
short wgetblockheight (block ptr);

void wresize (int x, int y, int x2, int y2, block image, int mode);

block wloadbmp (char *filename, color *pal);
short wsavebmp (char *filename, block image, color *pal);

block wloadiff (char *filename, color *pal);
short wsaveiff (char *filename, block image, color *pal);

block wloadblock (char *filename);
short wsaveblock (char *filename, block image);

block wloadpak (char *filename);
short wsavepak (char *filename, block image);

block wloadpcx (char *filename, color *pal);
short wsavepcx (char *filename, block savepcx, color *pal);

short wgettextwidth (char *string, wgtfont font);
short wgettextheight (char *string, wgtfont font);
wgtfont wloadfont (char *fontfile);
void wfreefont (wgtfont ptr);

void wloadpalette (char *filename, color *pal);
void wsavepalette (char *filename, color *pal);
void wsetrgb (unsigned char num, unsigned char red, unsigned char green, 
             unsigned char blue, color *pal);

short wloadsprites (color *pal, char *filename, block *image_array, short start,
                    short end);
short wsavesprites (color *pal, char *filename, block *image_array, short start, short end);
void wfreesprites (block *image_array, short start, short end);
