/*  OUTWIN.H    Window for output of the hypertext. Use different fonts,
		colors, icons. Context jmps and jmps back.
*/

#ifndef __OUTPIUT_WINDOW_H_
#define __OUTPIUT_WINDOW_H_

#include "window.h"
#include "cursor.h"
#include "icon.h"

enum { REFLECT, VIEW };

			       // Maximum number of contexts on one page
#define MAXKEYS 100

#define st_page_height 60
#define max_string_len 100
#define num_pages 200
#define previous_num 50

struct context
    {                      // We use 8-char identifier for marking of the
    char cont_name[10];    // context.
    int page;              // Page to which we must jump
    int line;              // line at this page

/*
Unremark for BC++ 2.0

   context()
	{ cont_name[0] = page = line = 0; }
*/
    context(char* c_n = 0, int p = 0, int l = 0)
	{
	if(c_n)
	    strcpy(cont_name, c_n);
	else                             // c_n == 0
	    cont_name[0] = 0;
	page = p;
	line = l;
	}
    };
/////////////////////
struct special              // ltrb is the rectangle - if mouse or OK - like
    {                       // key is pressed at this area we jumps to the
    rect ltrb;              // corresponding context
    char cont_name[10];
    };
//////////////////////
struct prev_stek                    // This stek contains pages and lines
    {                               // of previous contexts. It is used
    loc previous[previous_num];     // in the same maner as in BC++ help
    int used;                       // system, when ALT-F1 pressed.
    prev_stek() { used = 0; }
    void add(loc to_add);
    loc remove()
	{
	if(used)
	    {
	    used--;
	    return previous[used + 1];
	    }
	else return loc(0, 0);
	}
    };
//////////////////////
class OutputWindow : public Window
    {
	protected:
	    special* key_rects;  // around "special" places at the page
	    context* contexts;   // list of contexts and its coordinates in file
	    int number;          // number of special rectangles

	    loc curs;            // curs (0, 0) is in left-top screen corner
	    loc start;           // text coordinates
	    char* page;          // 1/2 page (1/2 of page is the loaded unit)
	    char* viewName;      // hypertext file name
	    int bak_color;
	    int attr_color;
	    int interval;        // text output interval
	    int end;             // flag end shows, is this page last in file
	    Cursor cursor;       // in screen coords
	    int page_height;
	    long file_position;
	    long* pages;         // page file positions list

	    prev_stek listed;    // stek of previously visited contexts
	public:
	OutputWindow(rect coordinates, char* vName,
	       int b_type = 1, int s = 3, int bak = pColorSet->colors.BAK_COLOR,
	       int attr = pColorSet->colors.ATTR_COLOR,
	       int interv = pScreenSet->sub_interval,
	       int p_height = st_page_height);

	virtual ~OutputWindow();

	void init_pages(); //pages[0] keeps current page number

	loc process(char*, char*, int flag,           // commands processing,
		    int count_ret, int is_first = 0); // f.e. change color
	void view();                                  // output
	void box_move(int dir);                       // navigation
	virtual void show();
	virtual void exe(int act = 0);
	void mouse_curs(loc ms_pos);                  // move cursor to ms position
	int load();                                   // create index table
	void load_file();                             // load part of file
	void key_add(loc wh, char* name);             // to context list
	int on_special();                             // is it special place?
	void jmp_to(char* context);
    };


#endif __OUTPIUT_WINDOW_H_