// OUTPUT.H
			       //////////////////////////////////////////////
#ifndef __OUTPUT_H_            // Output.h  file controls screen <--> text //
#define __OUTPUT_H_            //        coordinates recalculation         //
			       // Text screen is the 25 x 80 rectangle     //
#include <graphics.h>          // which is  independent from concrete type //
#include "colors.h"            //            of graphic adapter            //
#include "geom.h"              //////////////////////////////////////////////

/*  There are 4 types of functions ...L, T and ...R, B. L (left) returns
        left coordinate (0, 8, 16 ...), R - right (7, 15 ...).
        For loc(s) we have ...LT, ...LB, ...RT and ...RB versions.
        Rectangle (0, 0, 10, 10) in text mode for VGA (8 x 19 pixels)
        is represented as (0, 0, 79, 189) in screen mode.
*/
///////////////////////////////
inline int screenXL(int x) { return x << pScreenSet->log2cell_width;       }
inline int screenYT(int y) { return y * pScreenSet->cell_height;           }
inline int screenXR(int x) { return (x << pScreenSet->log2cell_width) - 1; }
inline int screenYB(int y) { return (y * pScreenSet->cell_height)     - 1; }

inline int textX(int x)    { return x >> pScreenSet->log2cell_width;     }
inline int textY(int y)    { return y / pScreenSet->cell_height;         }
///////////////////////////////
inline loc screenLocLT(loc l)  { return loc(screenXL(l.X), screenYT(l.Y)); }
inline loc screenLocLB(loc l)  { return loc(screenXL(l.X), screenYB(l.Y)); }
inline loc screenLocRT(loc l)  { return loc(screenXR(l.X), screenYT(l.Y)); }
inline loc screenLocRB(loc l)  { return loc(screenXR(l.X), screenYB(l.Y)); }

inline loc textLoc(loc l)      { return loc(textX(l.X), textY(l.Y));       }
/////////////////////////////
inline rect screenRect(rect rectangle)
    {
    return rect(screenXL(rectangle.origin.X), screenYT(rectangle.origin.Y),
	        screenXR(rectangle.corner.X), screenYB(rectangle.corner.Y));
    }

inline rect textRect(rect rectangle)
    {
    return rect(textX(rectangle.origin.X),     textY(rectangle.origin.Y),
	        textX(rectangle.corner.X + 1), textY(rectangle.corner.Y + 1));
    }


#endif __OUTPUT_H_
