#ifndef _TAB_VIEW_H_
#define _TAB_VIEW_H_

#include "simple.h"
#include "geom.h"
#include <alloc.h>
/* This class incapsulates scroll view functions for viewing the table.
	We suppose that width of columns is not constant, but height
	of raw is fixed. "chars" is the size of default font.
	Class is window-independent.
*/

class KH_TableView
    {
    protected:
	ulong yStart;       // From beginning to page top, lines
	int  xStart;        // From beginning column to page left, "chars"
	int  yPos;          // From page top to y cursor position, lines
	int  xPos;          // From page left to x cursor position, "chars"
	int  xCurs;         // Current column number
	ulong yCurs;        // Current raw number

	int xScreen;        // Screen viewport width, "chars"
	int yScreen;        // Screen viewport height, "chars"

	int nColumns;       // Total columns number, -1 for detect
	int* iColWidth;     // Array of widths of col.
	int* colNumbers;    // Change order of col. to show

    public:
	KH_TableView(int w, int h, int col = -1,
		  int* wid = NULL, int* colNum = NULL);

	~KH_TableView()    {}

	void setWidth(int w) { xScreen = w; }
	void setHeight(int h) { yScreen = h; }
	int Left();
	int Right();
	int Up();
	int Down();
	void Home();
	void End();
	void PgUp();
	void PgDown();
	void CtrlPgUp();
	void CtrlPgDown();
	void PgLeft();
	void PgRight();
	void Rotate();
	virtual void insRecord() {}
	virtual void delRecord() {}
	void SetScreen(int x, int y)   { xScreen = x; yScreen = y; }
	void moveToCell(loc ms);
// Return value: number of records in table or -1 if table have not
// the fixed number of records.
	virtual long RecordNumber()    { return 1L; }
	virtual int getColumnNumber()  { return 1; }
    };

#endif _TAB_VIEW_H_