/****************************************************************************/
/* SHORTCUT                                                                 */
/*--------------------------------------------------------------------------*/
/* Fonctions de gestion des acclrateurs                                   */
/*--------------------------------------------------------------------------*/
/* Auteur     : DELPRAT Jean-Pierre                                         */
/* Cr le    : 07/05/95                                                    */
/****************************************************************************/

#include <stdlib.h>
#include <string.h>

#include "Settings.h"

#include "Vocab.h"

#include "ShortCut.h"

#define NB_SHORT_CUTS           139
#define MAX_SHORT_CUT_LENGTH     25

// Attention  ne pas prendre des valeurs existantes pour les caractres

#define NONE        (-1)
#define CTRL        (-2)
#define ALT         (-3)
#define SHIFT       (-4)
#define CTRL_SHIFT  (-5)

/*ͻ*/
/*                            VARIABLES STATIQUES                         */
/*ͼ*/

static struct {int short_cut; int label1; int label2;}
 s_short_cut_label[NB_SHORT_CUTS+1]=
  {
    { SC_NONE             , NONE         , NONE     },

    { SC_CTRL_A           , CTRL         , 'A'      },
    { SC_CTRL_B           , CTRL         , 'B'      },
    { SC_CTRL_C           , CTRL         , 'C'      },
    { SC_CTRL_D           , CTRL         , 'D'      },
    { SC_CTRL_E           , CTRL         , 'E'      },
    { SC_CTRL_F           , CTRL         , 'F'      },
    { SC_CTRL_G           , CTRL         , 'G'      },
    { SC_CTRL_H           , CTRL         , 'H'      },
    { SC_CTRL_I           , CTRL         , 'I'      },
    { SC_CTRL_J           , CTRL         , 'J'      },
    { SC_CTRL_K           , CTRL         , 'K'      },
    { SC_CTRL_L           , CTRL         , 'L'      },
    { SC_CTRL_M           , CTRL         , 'M'      },
    { SC_CTRL_N           , CTRL         , 'N'      },
    { SC_CTRL_O           , CTRL         , 'O'      },
    { SC_CTRL_P           , CTRL         , 'P'      },
    { SC_CTRL_Q           , CTRL         , 'Q'      },
    { SC_CTRL_R           , CTRL         , 'R'      },
    { SC_CTRL_S           , CTRL         , 'S'      },
    { SC_CTRL_T           , CTRL         , 'T'      },
    { SC_CTRL_U           , CTRL         , 'U'      },
    { SC_CTRL_V           , CTRL         , 'V'      },
    { SC_CTRL_W           , CTRL         , 'W'      },
    { SC_CTRL_X           , CTRL         , 'X'      },
    { SC_CTRL_Y           , CTRL         , 'Y'      },
    { SC_CTRL_Z           , CTRL         , 'Z'      },

    { SC_ALT_A            , ALT          , 'A'      },
    { SC_ALT_B            , ALT          , 'B'      },
    { SC_ALT_C            , ALT          , 'C'      },
    { SC_ALT_D            , ALT          , 'D'      },
    { SC_ALT_E            , ALT          , 'E'      },
    { SC_ALT_F            , ALT          , 'F'      },
    { SC_ALT_G            , ALT          , 'G'      },
    { SC_ALT_H            , ALT          , 'H'      },
    { SC_ALT_I            , ALT          , 'I'      },
    { SC_ALT_J            , ALT          , 'J'      },
    { SC_ALT_K            , ALT          , 'K'      },
    { SC_ALT_L            , ALT          , 'L'      },
    { SC_ALT_M            , ALT          , 'M'      },
    { SC_ALT_N            , ALT          , 'N'      },
    { SC_ALT_O            , ALT          , 'O'      },
    { SC_ALT_P            , ALT          , 'P'      },
    { SC_ALT_Q            , ALT          , 'Q'      },
    { SC_ALT_R            , ALT          , 'R'      },
    { SC_ALT_S            , ALT          , 'S'      },
    { SC_ALT_T            , ALT          , 'T'      },
    { SC_ALT_U            , ALT          , 'U'      },
    { SC_ALT_V            , ALT          , 'V'      },
    { SC_ALT_W            , ALT          , 'W'      },
    { SC_ALT_X            , ALT          , 'X'      },
    { SC_ALT_Y            , ALT          , 'Y'      },
    { SC_ALT_Z            , ALT          , 'Z'      },

    { SC_ALT_1            , ALT          , '1'      },
    { SC_ALT_2            , ALT          , '2'      },
    { SC_ALT_3            , ALT          , '3'      },
    { SC_ALT_4            , ALT          , '4'      },
    { SC_ALT_5            , ALT          , '5'      },
    { SC_ALT_6            , ALT          , '6'      },
    { SC_ALT_7            , ALT          , '7'      },
    { SC_ALT_8            , ALT          , '8'      },
    { SC_ALT_9            , ALT          , '9'      },
    { SC_ALT_0            , ALT          , '0'      },

    { SC_F1               , F1           , NONE     },
    { SC_F2               , F2           , NONE     },
    { SC_F3               , F3           , NONE     },
    { SC_F4               , F4           , NONE     },
    { SC_F5               , F5           , NONE     },
    { SC_F6               , F6           , NONE     },
    { SC_F7               , F7           , NONE     },
    { SC_F8               , F8           , NONE     },
    { SC_F9               , F9           , NONE     },
    { SC_F10              , F10          , NONE     },
    { SC_F11              , F11          , NONE     },
    { SC_F12              , F12          , NONE     },

    { SC_CTRL_F1          , CTRL         , F1       },
    { SC_CTRL_F2          , CTRL         , F2       },
    { SC_CTRL_F3          , CTRL         , F3       },
    { SC_CTRL_F4          , CTRL         , F4       },
    { SC_CTRL_F5          , CTRL         , F5       },
    { SC_CTRL_F6          , CTRL         , F6       },
    { SC_CTRL_F7          , CTRL         , F7       },
    { SC_CTRL_F8          , CTRL         , F8       },
    { SC_CTRL_F9          , CTRL         , F9       },
    { SC_CTRL_F10         , CTRL         , F10      },
    { SC_CTRL_F11         , CTRL         , F11      },
    { SC_CTRL_F12         , CTRL         , F12      },

    { SC_SHIFT_F1         , SHIFT        , F1       },
    { SC_SHIFT_F2         , SHIFT        , F2       },
    { SC_SHIFT_F3         , SHIFT        , F3       },
    { SC_SHIFT_F4         , SHIFT        , F4       },
    { SC_SHIFT_F5         , SHIFT        , F5       },
    { SC_SHIFT_F6         , SHIFT        , F6       },
    { SC_SHIFT_F7         , SHIFT        , F7       },
    { SC_SHIFT_F8         , SHIFT        , F8       },
    { SC_SHIFT_F9         , SHIFT        , F9       },
    { SC_SHIFT_F10        , SHIFT        , F10      },
    { SC_SHIFT_F11        , SHIFT        , F11      },
    { SC_SHIFT_F12        , SHIFT        , F12      },

    { SC_ALT_F1           , ALT          , F1       },
    { SC_ALT_F2           , ALT          , F2       },
    { SC_ALT_F3           , ALT          , F3       },
    { SC_ALT_F4           , ALT          , F4       },
    { SC_ALT_F5           , ALT          , F5       },
    { SC_ALT_F6           , ALT          , F6       },
    { SC_ALT_F7           , ALT          , F7       },
    { SC_ALT_F8           , ALT          , F8       },
    { SC_ALT_F9           , ALT          , F9       },
    { SC_ALT_F10          , ALT          , F10      },
    { SC_ALT_F11          , ALT          , F11      },
    { SC_ALT_F12          , ALT          , F12      },


    { SC_HOME             , HOME         , NONE     },
    { SC_PGUP             , PGUP         , NONE     },
    { SC_END              , END          , NONE     },
    { SC_PGDN             , PGDN         , NONE     },
    { SC_BACKSPACE	  , BACKSPACE    , NONE     },
    { SC_INSERT           , INSERT       , NONE     },
    { SC_DELETE           , DELETE       , NONE     },

    { SC_CTRL_HOME        , CTRL         , HOME     },
    { SC_CTRL_PGUP        , CTRL         , PGUP     },
    { SC_CTRL_END         , CTRL         , END      },
    { SC_CTRL_PGDN        , CTRL         , PGDN     },
    { SC_CTRL_BACKSPACE   , CTRL         , BACKSPACE},
    { SC_CTRL_INSERT      , CTRL         , INSERT   },
    { SC_CTRL_DELETE      , CTRL         , DELETE   },

    { SC_CTRL_UP          , CTRL         , UP       },
    { SC_CTRL_DOWN        , CTRL         , DOWN     },
    { SC_CTRL_LEFT        , CTRL         , LEFT     },
    { SC_CTRL_RIGHT       , CTRL         , RIGHT    },

    { SC_SHIFT_INSERT     , SHIFT        , INSERT   },
    { SC_SHIFT_DELETE     , SHIFT        , DELETE   },

    { SC_ALT_HOME         , ALT		 , HOME     },
    { SC_ALT_END	  , ALT          , END      },
    { SC_ALT_BACKSPACE    , ALT          , BACKSPACE},
    { SC_ALT_DELETE       , ALT          , DELETE   },

    { SC_CTRL_SHIFT_UP    , CTRL_SHIFT   , UP       },
    { SC_CTRL_SHIFT_DOWN  , CTRL_SHIFT   , DOWN     },
    { SC_CTRL_SHIFT_LEFT  , CTRL_SHIFT   , LEFT     },
    { SC_CTRL_SHIFT_RIGHT , CTRL_SHIFT   , RIGHT    },

// Sentinelle

    { SC_NONE             , NONE     , NONE     },
  };




/*ͻ*/
/*                                 FONCTIONS                              */
/*ͼ*/

static char *GetLabel(int label1, int label2)
{
  static char s_label[MAX_SHORT_CUT_LENGTH+1];

  char *fxx[12]={"F1","F2","F3","F4","F5","F6",
		 "F7","F8","F9","F10","F11","F12"};

  char *letter="X";

  int available;
  char *text;

  if (label1==NONE)
    return("");

  switch (label1)
    {
      case CTRL      : text=GetString(VOC_CTRL);break;
      case ALT       : text=GetString(VOC_ALT);break;
      case SHIFT     : text=GetString(VOC_SHIFT);break;
      case CTRL_SHIFT: text=GetString(VOC_CTRL_SHIFT);break;
      case F1        :
      case F2        :
      case F3        :
      case F4        :
      case F5        :
      case F6        :
      case F7        :
      case F8        :
      case F9        :
      case F10       : text=fxx[label1-F1];break;
      case F11       :
      case F12       : text=fxx[label1-F11+10];break;
      case HOME      : text=GetString(VOC_HOME);break;
      case PGUP      : text=GetString(VOC_PGUP);break;
      case END       : text=GetString(VOC_END);break;
      case PGDN      : text=GetString(VOC_PGDN);break;
      case BACKSPACE : text=GetString(VOC_BACKSPACE);break;
      case INSERT    : text=GetString(VOC_INSERT);break;
      case DELETE    : text=GetString(VOC_DELETE);break;
      default        : text="?";
    }

  strncpy(s_label,text,MAX_SHORT_CUT_LENGTH);
  s_label[MAX_SHORT_CUT_LENGTH]=0;

  available=MAX_SHORT_CUT_LENGTH-strlen(s_label);
  if ((label2!=NONE) && (available>0))
    {
      switch (label2)
	{
	  case F1        :
	  case F2        :
	  case F3        :
	  case F4        :
	  case F5        :
	  case F6        :
	  case F7        :
	  case F8        :
	  case F9        :
	  case F10       : text=fxx[label2-F1];break;
	  case F11       :
	  case F12       : text=fxx[label2-F11+10];break;
	  case HOME      : text=GetString(VOC_HOME);break;
	  case PGUP      : text=GetString(VOC_PGUP);break;
	  case END       : text=GetString(VOC_END);break;
	  case PGDN      : text=GetString(VOC_PGDN);break;
	  case BACKSPACE : text=GetString(VOC_BACKSPACE);break;
	  case INSERT    : text=GetString(VOC_INSERT);break;
	  case DELETE    : text=GetString(VOC_DELETE);break;
	  case UP        : text="<\x18>";break;
	  case DOWN      : text="<\x19>";break;
	  case LEFT      : text="<\x1B>";break;
	  case RIGHT     : text="<\x1A>";break;
	  default        : *letter=(char)label2;
			   text=letter;

	}
      strcat(s_label,"+");
      strncat(s_label,text,available-1);
    }
  return(s_label);
}



char *GetShortCutLabel(int short_cut)
{
  register int i=-1;
  register int sc;

  s_short_cut_label[NB_SHORT_CUTS].short_cut=short_cut;
  do
    sc=s_short_cut_label[++i].short_cut;
  while (sc!=short_cut);

  return(GetLabel(s_short_cut_label[i].label1,s_short_cut_label[i].label2));
}

int GetShortCutLabelLength(int short_cut)
{
  return((short_cut==SC_NONE)?0:strlen(GetShortCutLabel(short_cut)));
}
