/****************************************************************************/
/* CALLBACK                                                                 */
/*--------------------------------------------------------------------------*/
/* Fonctions de gestion des callbacks                                       */
/*--------------------------------------------------------------------------*/
/* Auteur     : DELPRAT Jean-Pierre                                         */
/* Cr le    : 06/09/95                                                    */
/****************************************************************************/

#include <stdlib.h>
#include <string.h>

#include "JPAppli.h"

#include "Callback.h"

void InitCallback(void (*&callback_action)(char *),char (*&callback_argument))
{
  callback_action=NULL;
  callback_argument=NULL;
}

void DestroyCallback(void (*&callback_action)(char *),char (*&callback_argument))
{
  callback_action=NULL;
  if (callback_argument!=NULL)
    {
      delete[] callback_argument;
      callback_argument=NULL;
    }
}

void SetCallback(void (*&callback_action)(char *),char (*&callback_argument),
                 void (*action)(char *),char *argument)
{
  callback_action=action;

  if (callback_argument!=NULL)
    delete[] callback_argument;

  callback_argument=new char [strlen(argument)+1];
  strcpy(callback_argument,argument);
}

void CallCallback(void (*callback_action)(char *),char (*callback_argument))
{
  if ((JPCallbacksEnabled()) && (callback_action!=NULL))
    callback_action(callback_argument);
}





void InitCallback(void (*&callback_action)(PObject,char *),char (*&callback_argument))
{
  callback_action=NULL;
  callback_argument=NULL;
}

void DestroyCallback(void (*&callback_action)(PObject,char *),char (*&callback_argument))
{
  callback_action=NULL;
  if (callback_argument!=NULL)
    {
      delete[] callback_argument;
      callback_argument=NULL;
    }
}

void SetCallback(void (*&callback_action)(PObject,char *),char (*&callback_argument),
                 void (*action)(PObject,char *),char *argument)
{
  callback_action=action;

  if (callback_argument!=NULL)
    delete[] callback_argument;

  callback_argument=new char [strlen(argument)+1];
  strcpy(callback_argument,argument);
}

void CallCallback(PObject object,void (*callback_action)(PObject,char *),char (*callback_argument))
{
  if ((JPCallbacksEnabled()) && (callback_action!=NULL))
    callback_action(object,callback_argument);
}



void InitCallback(void (*&callback_action)(PObject,int,char *),char (*&callback_argument))
{
  callback_action=NULL;
  callback_argument=NULL;
}

void DestroyCallback(void (*&callback_action)(PObject,int,char *),char (*&callback_argument))
{
  callback_action=NULL;
  if (callback_argument!=NULL)
    {
      delete[] callback_argument;
      callback_argument=NULL;
    }
}

void SetCallback(void (*&callback_action)(PObject,int,char *),char (*&callback_argument),
                 void (*action)(PObject,int,char *),char *argument)
{
  callback_action=action;

  if (callback_argument!=NULL)
    delete[] callback_argument;

  callback_argument=new char [strlen(argument)+1];
  strcpy(callback_argument,argument);
}

void CallCallback(PObject object,void (*callback_action)(PObject,int,char *),char (*callback_argument),int index)
{
  if ((JPCallbacksEnabled()) && (callback_action!=NULL))
    callback_action(object,index,callback_argument);
}
