* Function: FILEDATE
* Author..: Richard Low
* Syntax..: FILEDATE( <expC> )
* Returns.: Date of <filename> from directory entry.

FUNCTION FILEDATE
PARAMETER p_fname

*-- make sure a parameter was passed
IF PCOUNT() = 1

   *-- set up array to hold the file date from ADIR()
   DECLARE f_fdate[1]

   *-- call ADIR to check filespec given and fill date array
   IF ADIR( p_fname, '', '', f_fdate ) = 1
      *-- return date if all is well
      RETURN f_fdate[1]
   ENDIF

ENDIF
*-- otherwise, return an empty date
RETURN CTOD('  /  /  ')
