* Program: Db_demo.prg
* Author:  Don L. Powells
* Version: Summer '87
* Note(s): Routine to demonstrate DBEDIT()
*          with a user-defined function.
*
*          Database Files:
*            Customer.dbf   Serialno.dbf
*          Index Files:
*            Cust_no.NTX    State.ntx
*            Company.NTX    Zip.NTX
*            Last.ntx
*
* Copyright (c) 1988 Nantucket Corp.

* Save original DOS screen to restore
* upon exit.
SAVE SCREEN TO dosscrn
CLEAR SCREEN
SET WRAP ON
beep_on = .T.   && Turn on Beep function.

* Open the database and associated indexes.
USE Customer
SET INDEX TO Company,Cust_no,Last,Zip,State

* Declare and initialize arrays and memory
* variable parameters.
t = 6
l = 1
b = 20
r = 78

DECLARE fields[FCOUNT()-1],pics[FCOUNT()-1],;
   heads[FCOUNT()-1],foots[FCOUNT()-1]

* Fill fields array with field names.
AFIELDS(fields)

udf = "Db_func"

AFILL(pics,"")
pics[3] = "@R 999-999-9999"
pics[9] = "99999-9999"
pics[11] = "@!"

heads[1] = "Customer No."
heads[2] = "Company Name"
heads[3] = "Phone No."
heads[4] = "Extension"
heads[5] = "Address"
heads[6] = "Address"
heads[7] = "City"
heads[8] = "State"
heads[9] = "Zip code"
heads[10] = "First Name"
heads[11] = "MI"
heads[12] = "Last Name"

headsep = CHR(205)   && CHR(205) = ''
colsep = CHR(179)    && CHR(179) = ''
footsep = CHR(196)   && CHR(196) = ''

foots[1] = "NO EDIT Allowed"
foots[5] = "Line one"
foots[6] = "Line two"

* Incremental seek string for speed scroll.
mstring = ""

* Draw screen constants.
Saycenter(1,"Clipper Summer 87")
Saycenter(2,"DBEDIT() Demo")
@ 3,0 SAY REPLICATE(CHR(196),80)
* Draw box to surround table.
@ 5,0 TO 21,79

* Draw Browse menu.
Saycenter(22,"<ESC>:Exit <Return>:Edit "+;
   "<F3>:Order <Del>:Del/Recall <F4>:Pack")

* If Empty file force EOF() bang and user
* function call.
IF RECCOUNT() = 0
   KEYBOARD CHR(24)
ENDIF

* Call DBEDIT() and start browsing.
DBEDIT(t,l,b,r,fields,udf,pics,heads,headsep,;
   colsep,footsep,foots)
CLOSE DATABASES
RESTORE SCREEN FROM dosscrn
RETURN


* Db_func() - User-defined function
* for DBEDIT().
*
FUNCTION Db_func
PARAMETERS mstatus,fld_ptr
PRIVATE request

* Assume normal return.
request = 1

* Save last keystroke.
keystroke = LASTKEY()

* Assign current field name to mem variable.
curfield = fields[fld_ptr]

* Save current cursor position.
mrow = ROW()
mcol = COL()

IF mstatus = 0
   * Idle.
   request = Idlestat()
      
ELSEIF mstatus = 1
   * Beginning-of-file.
   request = Pasttop()

ELSEIF mstatus = 2
   * End-of-file.
   request = Pastbott(curfield)

ELSEIF mstatus = 3
   * Empty database file.
   request = Emptydbf(curfield,fld_ptr)

ELSEIF mstatus = 4
   * Keystroke exception.
   request = Keyexcep(keystroke,curfield,fld_ptr,mrow,mcol)

ELSE
   request = Idlestat()

ENDIF
RETURN(request)

* Idlestat()
* Process idle status (0) of DBEDIT().
* Updates record number and deleted status.
*
FUNCTION Idlestat
mrecno = RECNO()
@ 1,60 SAY "Record " +;
   ALLTRIM(TRANSFORM(mrecno,"@Z"))
IF DELETED()
   @ 2,60 SAY "** DELETED **"
ELSE
   @ 2,60 SAY "             "
ENDIF

morder = INDEXORD()
@ 2,5 SAY "Order: "+ UPPER(INDEXKEY(morder))+;
   SPACE(5)

* Draw Incremental Seek Prompt.
@ 23,0 SAY "Enter " + TRIM(INDEXKEY(0))+":   "

@ 4,0
Saycenter(4,"BROWSE MODE")
RETURN(1)


* Pasttop()
* Process status (1) of DBEDIT().
*
FUNCTION Pasttop
Beep("NORM")
@ 0,0
@ 0,0 SAY "** Beginning of File **"
INKEY(.5)
@ 0,0
RETURN(1)


* Pastbott()
* Process status (2) of DBEDIT().
*
FUNCTION Pastbott
PRIVATE curfield,retval
PARAMETERS curfield
@ 0,0
@ 0,0 SAY "** End of File **"
Beep("NORM")
retval = Apendrec(curfield)
@ 0,0
RETURN(retval)


* Apendrec()
* Append a blank record to the file.
*
FUNCTION Apendrec
PRIVATE curfield,fld_ptr,retval
PARAMETERS curfield, fld_ptr
retval = 1
@ 4,0
Saycenter(4,"BROWSE MODE")
resp = "N"
@ 24,0
@ 24,0 SAY "Do you want to add a new " + ;
   "record (Y/N)? " GET resp PICTURE "@!"
READ
@ 24,0
IF resp = "Y"
   APPEND BLANK
   * Get the next unique serial number from
   * the serial number file.
   currarea = SELECT()
   SELECT 0
   USE Serialno
   mCust_no = Ser_num + 1
   REPLACE Ser_num WITH mCust_no
   USE
   SELECT (currarea)
   REPLACE Cust_no WITH mCust_no
   IF curfield != "CUST_NO"
      Fld_edit(curfield,fld_ptr)
   ENDIF
   retval = 2
   Idlestat()
ENDIF
RETURN(retval)


* Emptydbf()
* Process status (3) of DBEDIT().
*
FUNCTION Emptydbf
PRIVATE curfield,fld_ptr,retval
PARAMETERS curfield, fld_ptr
* Enter append mode.
request = Apendrec(curfield,fld_ptr)
* Display status.
Idlestat()
RETURN(retval)


* Keyexcep()
* Process keystroke exceptions.
*
FUNCTION Keyexcep
PRIVATE request,keystroke,curfield,;
   fld_ptr,mrow,mcol
PARAMETERS keystroke,curfield,fld_ptr,;
   mrow,mcol
IF keystroke = 27       && <ESC>.
   * Exit.
   request = 0

ELSEIF keystroke = 13
   * Edit current cell.
   request = Fld_edit(curfield,fld_ptr)

ELSEIF keystroke = 7    && <Del>.
   * Delete/Recall current record.
   request = Delrecall()

ELSEIF keystroke = -2   && <F3>.
   * Select index order.
   request = Pickordr()
      
ELSEIF keystroke = -3   && <F4>.
   * Pack the file.
   request = Fil_pack()

ELSEIF ASC(CHR(keystroke)) >= 32 .AND.;
   ASC(CHR(keystroke)) <= 126  && Alphanumeric
   * Speed Scroll/Incremental Seek.
   request = Incseek(curfield,keystroke)

ELSEIF keystroke = 8    && <Backspace>.
   * Decremental Seek.
   request = Decseek()

ELSE
   Not_yet()
   request = 1
ENDIF

RETURN(request)


* Delrecall()
* Delete/Recall records toggle.
*
FUNCTION Delrecall
IF DELETED()
   RECALL
ELSE
   DELETE
ENDIF
* Update Deleted status.
Idlestat()
RETURN(1)


* Pickordr()
* Select the index order for file.
*
FUNCTION Pickordr
PRIVATE retval,ntxcnt,ntxkey,maxntx,subscrpt,;
   tr,lc,br,rc,ordscrn
retval = 1
* Count the number of indexes.
ntxcnt = 0
ntxkey = INDEXKEY(ntxcnt)
IF "" != ntxkey
   DO WHILE "" != ntxkey
      ntxcnt = ntxcnt + 1
      ntxkey = INDEXKEY(ntxcnt)
   ENDDO
   * Display menu of keys.
   DECLARE ntxarray[ntxcnt]
   maxntx = 0
   FOR i = 1 TO ntxcnt
      ntxarray[i] = INDEXKEY(i)
      maxntx = MAX(LEN(ntxarray[i]),maxntx)
   NEXT
   tr = 8
   lc = (80 - maxntx)/2
   br = 15
   rc = lc + maxntx
   ordscrn = SAVESCREEN((tr - 2),(lc - 1),;
      (br + 1), (rc + 1))
   @ 4,0
   Saycenter(4,"Select Order")
   @ (tr - 1),(lc - 1) TO (br + 1), (rc + 1)
   SCROLL(tr,lc,br,rc,0)
   subscrpt = ACHOICE(tr,lc,br,rc,ntxarray)
   IF subscrpt != 0
      SET ORDER TO subscrpt
      @ 23,0
      mstring = ""
   ENDIF
   RESTSCREEN((tr - 2),(lc - 1),(br + 1),;
      (rc + 1),ordscrn)
   retval = 2
ELSE
   Beep("BOZO")
   Err_msg("No index files are available.")
ENDIF
Idlestat()
RETURN(retval)


* Fil_pack()
* Remove deleted records from the file.
*
FUNCTION Fil_pack
Beep("NORM")
retval = 1
resp = "N"
@ 0,0
@ 0,0 SAY "Record removal is permanent. " + ;
   "Continue?(Y/N) ";
    GET resp PICTURE "@!" VALID(resp $ "Y/N")
READ
@ 0,0
IF resp = "Y"
   @ 24,0
   @ 24,0 SAY "Removing deleted records..."
   PACK
   retval =2
   @ 24,0
   Idlestat()
ENDIF
RETURN(retval)


* Fld_edit()
* Edit cell contents in table using
* memory variable.
*
FUNCTION Fld_edit
PRIVATE curfield,fld_ptr
PARAMETERS curfield,fld_ptr
@ 4,0
Saycenter(4,"EDIT MODE")
* Assume no screen refresh.
retval = 1

* Get controlling index key.
ntx_expr = INDEXKEY(0)
* Expand for comparison after edit to determine
* whether screen refresh is needed.
ntx_eval = &ntx_expr
SET CURSOR ON       && DBEDIT() turns
                    ** cursor off by default.

* Store field contents to memory variable.
get_data = &curfield.

* Allow up and down arrows to exit READ.
READEXIT(.T.)

* Prevent edits on Customer number field.
IF curfield != "CUST_NO"
   @ mrow,mcol GET get_data;
      PICTURE get_pic(curfield,fld_ptr)
   READ

   * Turn off up, down arrow key exiting.
   READEXIT(.F.)
   keystroke = LASTKEY()     && Save exit key.

   IF keystroke != 27 .AND. UPDATED()
      * Store changes to database.
      REPLACE &curfield. WITH get_data

      IF !EMPTY(ntx_expr)
         * File indexed..check for altered
         * key field.

         IF ntx_eval != (&ntx_expr)
            * key field altered..re-draw screen.
            retval = 2

      	ENDIF
      ENDIF

      IF retval <> 2
         * Certain keys move cursor after
         * edit if no refresh.

         IF keystroke = 5
            * Up arrow.
            KEYBOARD CHR(5)

         ELSEIF keystroke = 18
            * PgUp.
            KEYBOARD CHR(5)

         ELSEIF keystroke = 24
            * Down arrow.
            KEYBOARD CHR(24)

         ELSEIF keystroke = 3
            * PgDn.
            KEYBOARD CHR(24)

         ELSEIF keystroke = 13;
            .OR. keystroke > 32
            * Return or Typed past end.
            * Move right.
            KEYBOARD CHR(4)

         ENDIF
      ENDIF
   ENDIF
ELSE
   @ 0,0
   Beep("BOZO")
   @ 0,0 SAY "No Edits allowed on this field!"
   INKEY(1)
   @ 0,0
ENDIF
SET CURSOR OFF
RETURN(retval)


* Get_pic()
* Return matching picture string for
* specified field.
*
FUNCTION Get_pic

PRIVATE pstring, s,field,fld_ptr
PARAMETERS field,fld_ptr

DO CASE
CASE !EMPTY(pics[fld_ptr])
   * Check picture array for a picture string.
   pstring = pics[fld_ptr]

CASE TYPE(field) = "C"
   * Character field is bounded by window
   * width.
   pstring = "@KS" + ;
      LTRIM(STR(MIN(LEN(&field), 78)))

CASE TYPE(field) = "N"
   * Convert to character to
   * help format picture string.
   s = STR(&field.)

   IF "." $ s
      * Decimals in numeric.  Use the
      * form "9999.99".
      pstring = REPLICATE("9",;
         AT(".", s) - 1) + "."
      pstring = pstring + REPLICATE("9", LEN(s) - LEN(pstring))

   ELSE
      * No decimals.  Only need the
      * correct length.
      pstring = REPLICATE("9", LEN(s))

   ENDIF

OTHERWISE
   * No picture.
   pstring = ""

ENDCASE

RETURN(pstring)


* Incseek()
* Incremental seek of records.
*
FUNCTION Incseek
PRIVATE curfield,retval,keystroke
PARAMETERS curfield,keystroke
old_recnum = recno()
mstring = mstring + CHR(keystroke)
@ 23,16
@ 23,16 SAY mstring
IF UPPER(INDEXKEY(0)) != "CUST_NO"
   SEEK TRIM(mstring)
ELSE
   SEEK VAL(TRIM(mstring))
ENDIF

IF !FOUND()
   Beep("BOZO")
   Err_msg("Entry does not exist.")
   GO old_recnum
ENDIF
RETURN(2)


* Decseek()
* Decremental seek when <Backspace>
* is pressed.
*
FUNCTION Decseek
mstring = SUBSTR(mstring,1,(LEN(mstring)-1))
IF UPPER(INDEXKEY(0)) != "CUST_NO"
   SEEK TRIM(mstring)
ELSE
   SEEK VAL(TRIM(mstring))
ENDIF
@ 23,16   
@ 23,16 SAY mstring   
RETURN(2)


* Saycenter()
* Function to center a string on a given row.
* Usage: Saycenter(row#,expC)
*
FUNCTION Saycenter
PARAMETERS trow,in_string
IF LEN(in_string)>=80
   @ trow,0 SAY in_string
ELSE
   @ trow,(80 - LEN(in_string))/2 SAY in_string
ENDIF

RETURN (.T.)


* Not_yet()
* Prints option not available message.
*
FUNCTION Not_yet
@ 0,0
Beep("NORM")
@ 0,0 SAY "Option is not available yet." +;
          " Press any key to continue."
INKEY(0)
@ 0,0
RETURN(.T.)


* Beep()
* Sounds a tone to get user's attention.
* Usage: Beep("NORM") && Info or warning.
*        Beep("BOZO") && Error beep.
*
FUNCTION Beep
PARAMETER beeptype
IF beep_on
   IF UPPER(beeptype) = "BOZO"
      TONE(87.3,1)
      TONE(40,3.5)
   ELSE
      TONE(261.7,1)
      TONE(392,3.5)
   ENDIF
ENDIF
RETURN(.T.)


* Err_msg()
* Prints an error message or warning on row 0.
* Usage: Err_msg("Error or warning message")
*
FUNCTION Err_msg
PARAMETER e_msg
@ 0,0
err_scrn = SAVESCREEN(0,0,1,79)
@ 0,0 SAY e_msg + " Press a key to continue."
INKEY(0)
@ 0,0
RESTSCREEN(0,0,1,79,err_scrn)
RETURN(.T.)


* User_msg()
* Prints user messages on row 24 and waits for
* a key press.
* Usage: User_msg("Message string")
*
FUNCTION User_msg
PARAMETERS msg
@ 24,0
userscrn = SAVESCREEN(23,0,24,79)
@ 24,0 SAY msg + " Press a key to continue."
INKEY(0)
@ 24,0
RESTSCREEN(23,0,24,79,userscrn)
RETURN(.T.)

*EOP: Db_demo.prg
