
;============================================================================
;
; CDROMFA.ASM
; Some low-level routines to use the MSCDEX interface.
; This file is part of the
;
; PseudoCD package (version 02)
; Copyright (C) 1997  C.Kulms
;
;   This is free software; you can redistribute it and/or modify it
;   under the terms of the GNU General Public License as published by
;   the Free Software Foundation; version 2 of the License.
;
;   This software is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License
;   along with this software; if not, write to the Free Software
;   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;
;============================================================================*/

IDEAL
P386
LOCALS @@

INCLUDE "DRIVER.INC"	;device driver strucs/equs

MODEL SMALL
CODESEG

PUBLIC _MSCDEX_NumberOfDrives
PUBLIC _MSCDEX_GetCDDrives
PUBLIC _MSCDEX_GetCDDeviceList
PUBLIC _MSCDEX_DriverSendRequest

PROC _MSCDEX_NumberOfDrives
;check for MSCDEX and get number of cdrom-drives supported
;prototype: int MSCDEX_NumberOfDrives( void )
;return: number of cdrom-drives, 0 on error

	push	bx			;save bx

	mov		ax,1500h	;'get number of cdrom-drives'
	xor		bx,bx		;bx=0
	int		2Fh			;call MSCDEX
	or		bx,bx       ;check if MSCDEX installed
	jz		@@error		;
	mov		ax,bx		;return number of cdrom-drives
@@done:
	pop		bx			;restore bx
	ret

@@error:
	xor		ax,ax		;return error value 0
	jmp		@@done

ENDP _MSCDEX_NumberOfDrives

PROC _MSCDEX_GetCDDrives
; get drive numbers and basic data about cdrom-drives
; prototype: void MSCDEX_GetCDDrives( char far *fpc )
; return: 1
	ARG fpc:DWORD

	push	bp				;setup stack
	mov		bp,sp
	push	ds				;save ds
	push	bx				;save bx

	mov		ax,150Dh		;'get cdrom-drive letters'
	lds		bx,[fpc]		;ds:bx->buffer
	int		2Fh				;call MSCDEX

	pop		bx				;restore bx
	pop		ds				;restore ds
	pop		bp				;restore stack
	ret

ENDP _MSCDEX_GetCDDrives

PROC _MSCDEX_GetCDDeviceList
; get disk-letters and basic data about cdrom-drives
; prototype: void MSCDEX_GetCDDeviceList( t_CDDATA far *fptCDData )
; return: 1
	ARG fptCDData:DWORD

	push	bp				;setup stack
	mov		bp,sp
	push	ds				;save ds
	push	bx				;save bx

	mov		ax,1501h		;'get cdrom device list'
	lds		bx,[fptCDData]	;ds:bx->target buffer
	int		2FH				;call MSCDEX

	pop		bx				;restore bx
	pop		ds				;restore ds
	pop		bp				;restore stack
	ret

ENDP _MSCDEX_GetCDDeviceList

PROC _MSCDEX_DriverSendRequest
; call MSCDEX to build a driver request of given request data
; prototype: unsigned MSCDEX_DriverSendRequest( int iCDno, t_REQHDR *ptReqHdr )
; return: status word of request header
	ARG iCDno:WORD, ptReqHdr:DWORD

	push	bp				;setup stack
	mov		bp,sp

	push	ds				;save ds
	push	es				;save es
	push	bx				;save bx
	push	cx				;save cx

	lds		bx,[ptReqHdr]	;ds:bx->request header
	mov		ax,ds
	mov		es,ax			;es=ds
	mov		cx,[iCDno]		;cx=CDROM drive number
	mov		ax,1510h		;'Driver Send Request'
	int		2Fh				;call MSCDEX
	mov		ax,[(sREQHDR bx).rqStatus]	;get status

	pop		cx				;restore cx
	pop		bx				;restore bx
	pop		es				;restore es
	pop		ds				;restore ds

	pop		bp				;restore stack
	ret

ENDP _MSCDEX_DriverSendRequest

END	;of file 'CDROMFA.ASM'

