/*
ͻ
                     WordUp Graphics Toolkit Version 4.5                    
                            Demonstration Program 24                        
                                                                            
 Display special effects using wwipe command.                               
                                                                            
  PROJECT                                                             
 This program requires the file WGT45.LIB to be linked.          	     
                                                                            
  DATA FILES                                                          
 Make sure that you have WGT2.BLK and WGT1.PAL in your executable directory.
                                                                            
ͼ
*/

#include <conio.h>
#include <stdio.h>
#include <wgt45.h>


void main(void)
{
block screen1, screen2;			/* Two virtual screens */
color palette[256];			/* Our palette */
int i, j;				/* Loop counters */
int oldmode;				/* Stores initial video mode */

  printf ("WGT Example #24\n\n");
  printf ("The WWIPE command is used to show several different screen wipes.\n");
  printf ("Using WRETRACE keeps the speed constant on all computers. Try removing\n");
  printf ("all retraces to obtain maximum speed and notice the difference.\n");
  printf ("A keypress advances to the next wipe at each point.\n");
  printf ("\n\nPress any key to continue.\n");
  getch ();

  if (!vgadetected ())
    {
     printf ("Error - VGA card required for any WGT program.\n");
     exit (0);
    }

  oldmode = wgetmode ();		/* Preserve initial video mode */
  vga256 ();				/* Initialize graphics mode */

  screen1 = wloadblock ("wgt2.blk");	/* Load image file from disk */
  wtextcolor (15);			/* Use index 15 for text */

  /* Note: This text will be on our second screen - used for wipes */
  wouttextxy (0, 0, NULL, "SCREEN BUFFER #2");
  wouttextxy (0, 50, NULL, "This screen is one of our 2 screens");
  wouttextxy (0, 58, NULL, "used to perform the wipe effect.");
  wouttextxy (46, 100, NULL, "Press a key to perform wipe");

  screen2 = wnewblock (0, 0, 319, 199);	/* Allocate memory for screen2 */
  wnormscreen ();			/* Make sure we're drawing on default screen */
  wloadpalette ("wgt1.pal", palette);	/* Load palette file for image */
  wsetpalette (0, 255, palette);	/* Now use the palette */

  getch ();                              /* Get a keypress */

  for (i = 0; i < 200; i++)
    {
     wwipe (0, 0, 319, i, screen1);    		/* Wipe screen down from right */
     wwipe (319, 199,0, 199 - i, screen1);	/* Wipe screen up from left */
     wretrace ();
    }
  getch ();

  /* Now wipe on the black screen using horizontal lines meeting at middle */
  for (i = 0; i < 100; i++)
    {
     wwipe (0, i, 319, i, screen2);
     wwipe (0, 199 - i, 319, 199 - i, screen2);
     wretrace ();
    }

  getch ();

  /* Now perform a "circular" wipe, by going around the screen from center */
  for (i = 0; i < 320; i++)
    {
     wwipe (159, 99, i, 0, screen1);
     delay (1);
    }

  for (i = 0; i < 200; i++)
    {
     wwipe (159, 99, 319, i, screen1);
     delay (1);
    }

  for (i = 319; i >= 0; i--)
    {
     wwipe (159, 99, i, 199, screen1);
     delay (1);
    }

  for (i = 199; i >= 0; i--)
    {
     wwipe (159, 99, 0, i, screen1);
     delay (1);
    }
  getch ();

  /* Clear with black screen by wiping top to bottom */
  for (i = 0; i < 200; i++)
    {
     wwipe (0, i, 319, i, screen2);
     wretrace ();
    }
  getch ();

  wfreeblock (screen1);		/* Remember to free that memory */
  wfreeblock (screen2);
  wsetmode (oldmode);		/* Restore initial video mode */
}
