/* gaussjordan4.c                   freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"
/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void gjA()
{
fraction  a;
fraction  b;
fraction  c;
fraction  d;
fraction  L1;
fraction  InvL1;
fraction  amnsL1;
fraction  det;

double pbA    [2][2*TWOCOL];matrix mA   ={2,2*TWOCOL,&pbA   [0][0]};
double pbInvA [2][2*TWOCOL];matrix mInvA={2,2*TWOCOL,&pbInvA[0][0]};
double pbx1   [2][  TWOCOL];matrix mx1  ={2,  TWOCOL,&pbx1  [0][0]};
double pbAx1  [2][  TWOCOL];matrix mAx1 ={2,  TWOCOL,&pbAx1 [0][0]};
double pbL1x1 [2][  TWOCOL];matrix mL1x1={2,  TWOCOL,&pbL1x1[0][0]};
/*-------------------------------- PROGRAM ---------------------------------- */
    do
  {
    a =  rndF(9,1); b =  rndF(9,1); c =  rndF(9,1); d =  subF(addF(a,b),c);

   *(mA.pblock+0  *mA.cols+0) = a.numer; *(mA.pblock+0  *mA.cols+1) = a.denom;
   *(mA.pblock+0  *mA.cols+2) = b.numer; *(mA.pblock+0  *mA.cols+3) = b.denom;
   *(mA.pblock+1  *mA.cols+0) = c.numer; *(mA.pblock+1  *mA.cols+1) = c.denom;
   *(mA.pblock+1  *mA.cols+2) = d.numer; *(mA.pblock+1  *mA.cols+3) = d.denom;

    det = detF(&mA);

  }while(!det.numer);
                           L1 = subF(a,c);
                       amnsL1 = subF(a,L1);
  *(mx1.pblock+0 *mx1.cols+0) =     -b.numer;
  *(mx1.pblock+0 *mx1.cols+1) =      b.denom;
  *(mx1.pblock+1 *mx1.cols+0) = amnsL1.numer;
  *(mx1.pblock+1 *mx1.cols+1) = amnsL1.denom;

  clrscrn();
  printf("\n                                        The vector x :");
  printmI(&mx1);
  printf("\n                              is an eigenvector of A :");
  printmI(&mA);

  printf("\n      corresponding to the eigenvalue L = %.0f since :\n",
  L1.numer);

  printf("\n                                                  Ax :");
   multmF(&mA,&mx1,&mAx1);
  printmI(         &mAx1);
  printf("\n                                              %4.0f x :",
            L1.numer);
  smultmF(L1,&mx1,&mL1x1);
  printmI(        &mL1x1);
  getchar();

  clrscrn();
  printf("\n                                   The same vector x :");
  printmI(&mx1);
  printf("\n                           is an eigenvector of InvA :");
  inverseF(&mA,&mInvA);
   printmF(    &mInvA);

  InvL1 = invF(L1);
  printf("\n    corresponding to the eigenvalue 1/L = %.0f/%.0f since :\n",
  InvL1.numer, InvL1.denom);
  printf("\n                                               InvAx :");
   multmF(&mInvA,&mx1,&mAx1);
  printmF(            &mAx1);
  printf("\n                                           %4.0f/%.0f x :",
            InvL1.numer,InvL1.denom);
  smultmF(InvL1,&mx1,&mL1x1);
  printmF(           &mL1x1);



}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n                                                  ");
  printf("\n             The vector x                     \n\n");
  printf("\n        is an eigenvector of A                \n\n");
   printf("\n   corresponding to the eigenvalue L since : \n\n");
  printf("\n                Ax =  L   x                     \n");
  printf("\n             InvAx = (1/L)x                     \n");
  printf("\n                *******                         \n");
  printf("\n\n                                                ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                         ");
  printf("\n                                                  ");

  getchar();
}


/* --------------------------------- MAIN ----------------------------------- */
int main()
{
time_t t;

/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{


  gjA();


printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}

