/* gjid03.c                         freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"


/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
gjA(int n)
{
fraction InnProd;

double pbA     [MXR][MXC*TWOCOL];matrix mA      ={MXR,MXC*TWOCOL,&pbA   [0][0]};
double pbu     [MXR][MXC*TWOCOL];matrix mu      ={MXR,MXC*TWOCOL,&pbu   [0][0]};
double pbv     [MXR][MXC*TWOCOL];matrix mv      ={MXR,MXC*TWOCOL,&pbv   [0][0]};

                                   n = 3;
                     mA.rows= n;                     mA.cols= n*TWOCOL;
                     mu.rows= n;                     mu.cols=   TWOCOL;
                     mv.rows= n;                     mv.cols=   TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
  rndorth(&mA,3,2);

  clrscrn();
  printf("\n");
  printf(" A an n x n orthogonal matrix.\n\n");
  printf(" The column vectors of A form an orthonormal set in R**n\n");
  printf(" With the euclidean inner product.\n\n");

  printf("                                   mA :\n");
  printmF3(&mA);

  printf("\n\n");
          copycolF(&mA,0,&mu,0);
  InnProd = normP2(&mu);
  printf("  ||Ac1|| =  %.0lf/%-.0lf;   ",InnProd.numer,InnProd.denom);
          copycolF(&mA,1,&mu,0);
  InnProd = normP2(&mu);
  printf("  ||Ac2|| =  %.0lf/%-.0lf;   ",InnProd.numer,InnProd.denom);
          copycolF(&mA,2,&mu,0);
  InnProd = normP2(&mu);
  printf("  ||Ac3|| =  %.0lf/%-.0lf;  \n\n",InnProd.numer,InnProd.denom);


         copycolF(&mA,0,&mu,0);
         copycolF(&mA,1,&mv,0);
    InnProd = innerprod(&mu,&mv);
  printf("  Ac0.Ac1 =  %.0lf/%-.0lf;  ",
            InnProd.numer,
            InnProd.denom);

         copycolF(&mA,0,&mu,0);
         copycolF(&mA,2,&mv,0);
    InnProd = innerprod(&mu,&mv);
  printf("   Ac0.Ac2 =  %.0lf/%-.0lf;  ",
            InnProd.numer,
            InnProd.denom);

         copycolF(&mA,1,&mu,0);
         copycolF(&mA,2,&mv,0);
    InnProd = innerprod(&mu,&mv);
  printf("   Ac1.Ac2 =  %.0lf/%-.0lf;  \n\n",
            InnProd.numer,
            InnProd.denom);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n\n\n\n                                          \n");
  printf("         A an n x n orthogonal matrix.          \n\n");
  printf("            The column vectors of A               \n");
  printf("       form an orthonormal set in R**n            \n");
  printf("       with the euclidean inner product.          \n");
  printf("       ********************************           \n");
  printf("\n\n\n\n\n\n\n                                      ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                         ");
  printf("\n                                                  ");

  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;

/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 2 && atoi(argv[1]))
 {  n = atoi(argv[1]); if( n > 4){n=4;}}
else
 {  n = rndpI(4);}
if( n < 3){n=3;}


  gjA(n);


printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}

