/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
AB(
int n
)
{
fraction det;
int x;

fraction f1by4      = {1,4};

fraction Norm_uplsv;
fraction Norm_umnsv;
fraction Norm_f1by4uplsv;
fraction Norm_f1by4umnsv;
fraction Norm_f1by4uplsv_mns_f1by4umnsv;

fraction InnerProduct;

double pbA[MXR][MXC*TWOCOL];matrix mA={MXR,MXC*TWOCOL,&pbA[0][0]};
double pbu[MXR][MXC*TWOCOL];matrix mu={MXR,MXC*TWOCOL,&pbu[0][0]};
double pbv[MXR][MXC*TWOCOL];matrix mv={MXR,MXC*TWOCOL,&pbv[0][0]};
double puplsv[MXR][MXC*TWOCOL];matrix muplsv={MXR,MXC*TWOCOL,&puplsv[0][0]};
double pumnsv[MXR][MXC*TWOCOL];matrix mumnsv={MXR,MXC*TWOCOL,&pumnsv[0][0]};

       mA.rows = n;               mA.cols = n*TWOCOL;
       mu.rows = n;               mu.cols =   TWOCOL;
       mv.rows = n;               mv.cols =   TWOCOL;
   muplsv.rows = n;           muplsv.cols =   TWOCOL;
   mumnsv.rows = n;           mumnsv.cols =   TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
         x =   6;
 if(n<3){x = 100;}

  do
  {
               rndmF(&mA,x,2);
          det = detF(&mA);
  }while(!det.numer);

  rndmF(&mu,5,3);
  rndmF(&mv,5,3);

  clrscrn();
  printf("                  An invertible matrix : A \n");
  printmF(&mA);
  printf("\n                               (n x 1) : u \n");
  printmF(&mu);
  printf("\n                               (n x 1) : v \n");
  printmF(&mv);
  getchar();

  clrscrn();
  printf("\n                               (n x 1) : u ");
  printmF(&mu);
  printf("\n                               (n x 1) : v ");
  printmF(&mv);

  addmF(&mu,&mv,&muplsv);
  printf("\n                             u + v");
  printmF3(&muplsv);

  Norm_uplsv = norm_AP2(&mA,&muplsv);         /* It is the square of the norm.*/
  printf("\n         ||u + v||**2 = %.0lf/%-.0lf\n",
            Norm_uplsv.numer,
            Norm_uplsv.denom);
  getchar();

  clrscrn();
  printf("\n                               (n x 1) : u ");
  printmF(&mu);
  printf("\n                               (n x 1) : v ");
  printmF(&mv);

  submF(&mu,&mv,&mumnsv);
  printf("\n                             u - v");
  printmF3(&mumnsv);

  Norm_umnsv = norm_AP2(&mA,&mumnsv);         /* It is the square of the norm.*/
  printf("\n         ||u - v||**2 = %.0lf/%-.0lf\n",
            Norm_umnsv.numer,
            Norm_umnsv.denom);
  getchar();


  clrscrn();

  printf("                           ||u + v||**2 = %.0lf/%-.0lf\n\n",
            Norm_uplsv.numer,
            Norm_uplsv.denom);

  Norm_f1by4uplsv = multF(f1by4, Norm_uplsv);
  printf("                       1/4 ||u + v||**2 = %.0lf/%-.0lf\n\n\n",
            Norm_f1by4uplsv.numer,
            Norm_f1by4uplsv.denom);

  printf("                           ||u - v||**2 = %.0lf/%-.0lf\n\n",
            Norm_umnsv.numer,
            Norm_umnsv.denom);

  Norm_f1by4umnsv = multF(f1by4, Norm_umnsv);
  printf("                       1/4 ||u - v||**2 = %.0lf/%-.0lf\n\n\n",
            Norm_f1by4umnsv.numer,
            Norm_f1by4umnsv.denom);

  printf(" with  the Inner Product on R**n generated by A :\n\n");
  printf("    <u,v> = 1/4 ||u+v||**2  -  1/4 ||u-v||**2 \n\n\n");

  InnerProduct = innerprod_A(&mA,&mu,&mv);
  printf("                                  <u,v> = %.0lf/%-.0lf\n\n",
            InnerProduct.numer,
            InnerProduct.denom);

  Norm_f1by4uplsv_mns_f1by4umnsv = subF(Norm_f1by4uplsv, Norm_f1by4umnsv);
  printf("  1/4 ||u + v||**2  -  1/4 ||u - v||**2 = %.0lf/%-.0lf\n\n",
            Norm_f1by4uplsv_mns_f1by4umnsv.numer,
            Norm_f1by4uplsv_mns_f1by4umnsv.denom);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n\n\n                                              ");
  printf("\n With  the Inner Product on R**n generated by A :\n");
  printf("\n                                                  ");
  printf("\n   <u,v> = 1/4 ||u+v||**2  -  1/4 ||u-v||**2      ");
  printf("\n   ***************************************    \n\n");
  printf("\n                                                  ");
  printf("\n                                                  ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                         ");
  printf("\n                                                  ");
  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
int main(int argc, char *argv[])
{
time_t t;
int    n;
/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 2 && atoi(argv[1]) )
 {
  n = atoi(argv[1]); if( n > 5){n=5;}
  }
else
 {
  n=rndpI(5);
 }
   if(n<2){n=2;}


  AB(n);


  printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}












