/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
AB(
int n)
{
fraction InnerProduct_uv;
fraction InnerProduct_k_uv;
fraction InnerProduct_ku_v;
fraction k;

double pbu [MXR][MXC*TWOCOL];matrix mu ={MXR,MXC*TWOCOL,&pbu [0][0]};
double pbku[MXR][MXC*TWOCOL];matrix mku={MXR,MXC*TWOCOL,&pbku[0][0]};
double pbv [MXR][MXC*TWOCOL];matrix mv ={MXR,MXC*TWOCOL,&pbv [0][0]};

   mu.rows = n;           mu.cols = n*TWOCOL;
  mku.rows = n;          mku.cols = n*TWOCOL;
   mv.rows = n;           mv.cols = n*TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
       rndmF(&mu,5,3);
       rndmF(&mv,5,3);
  k =  rndF (    5,3);

  clrscrn();
  printf("                                 U");
  printmF3(&mu);
  printf("                                 V");
  printmF3(&mv);
  printf("\n    k = %.0lf/%-.0lf \n",k.numer,k.denom);

  smultmF(k,&mu,&mku);
  printf("                               kU\n");
  printmF3(&mku);

  InnerProduct_ku_v = innerprod_Mnm(&mku,&mv);
  printf("\n <kU,V> =  %.0lf/%-.0lf ",
            InnerProduct_ku_v.numer,
            InnerProduct_ku_v.denom);

  InnerProduct_uv = innerprod_Mnm(&mu,&mv);
  printf("\n k<U,V> = (%.0lf/%-.0lf) (%.0lf/%-.0lf)",
            k.numer,
            k.denom,
            InnerProduct_uv.numer,
            InnerProduct_uv.denom);
  getchar();

  clrscrn();
  printf("\n  Properties of inner product in Mnn :\n");
  printf("\n             (Homogeneity axiom)     \n\n");
  printf("\n               <kU,V>  =  k<U,V>   \n\n\n");
  printf("   <kU,V> =  %.0lf/%-.0lf\n\n",
            InnerProduct_ku_v.numer,
            InnerProduct_ku_v.denom);

  InnerProduct_k_uv = multF(k,InnerProduct_uv);
  printf("   k<U,V> =  %.0lf/%-.0lf\n\n",
            InnerProduct_k_uv.numer,
            InnerProduct_k_uv.denom);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.  ");
  printf("\n\n                                                ");
  printf("\n  Properties of inner product in Mnn :         \n");
  printf("\n             (Homogeneity axiom)                \n");
  printf("\n\n\n                                              ");
  printf("\n               <kU,V>  =  k<U,V>                  ");
  printf("\n               *****************                  ");
  printf("\n\n\n\n\n                                          ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                          ");
  printf("\n                                                  ");
  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
int main(int argc, char *argv[])
{
time_t t;
int    n;
/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 2 && atoi(argv[1]) )
 {n = atoi(argv[1]); if( n > 5){n=5;}}
else
 {    n=rndpI(5);}
   if(n<2){n=2;}


  AB(n);


  printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}











