/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
AB()
{
double pbA[2][2*TWOCOL]=
{
  -1,1,   0,1,
   0,1,   1,1,
};
matrix mA={2,2*TWOCOL,&pbA[0][0]};

double pbu[2][4*TWOCOL]=
{
  2,1,   6,1,   7,1,   2,1,
  2,1,   5,1,   3,1,   2,1,
};
matrix mu={2,4*TWOCOL,&pbu[0][0]};

double pbv[2][4*TWOCOL];matrix mv={2,4*TWOCOL,&pbv[0][0]};
/*-------------------------------- PROGRAM ---------------------------------- */

  clrscrn();

  printf("\n Reflection about the y-axis :                  \n");
  printf("\n                | -1  0 |                         ");
  printf("\n        v[n]  = |       |  u[n]                   ");
  printf("\n                |  0  1 |                         ");

  printf("\n\n                                          u = AB");
  printmF(&mu);
  gnpltvectcol2d("u",&mu);

  multmF(&mA,&mu,&mv);
  printf("\n\n                                          v = CD");
  printmF(&mv);
  gnpltvectcol2d("v",&mv);
  gnpltaxis(     "aa2d.plt");

  printf("\n\n To see the result in Gnuplot (gp373w32.exe) :           \n\n");
  printf("  * open the file aa2d.plt with Gnuplot. Gnuplot draw u and v. \n");
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.  ");
  printf("\n\n\n                                              ");
  printf("\n        Reflection about the y-axis :             ");
  printf("\n        ***************************               ");
  printf("\n\n                                                ");
  printf("\n               Triangle ABC.                      ");
  printf("\n\n                                                ");
  printf("\n                | -1  0 |                         ");
  printf("\n        v[n]  = |       |  u[n]                   ");
  printf("\n                |  0  1 |                         ");
  printf("\n\n\n\n\n                                          ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                        \n");
  getchar();
}


/* --------------------------------- MAIN ----------------------------------- */
int main()
{
/*-------------------------------- PROGRAM ---------------------------------- */
  hello();

  AB();


  printf("\n Press Return to stop\n");
  getchar();

  return 0;
}












