/****************************************************************************/
/*                                                                          */
/* START_2.C                                                                */
/*                                                                          */
/*     This C skeleton program was written to show you how to get up and    */
/* running quickly with the UltraWin library.  But first, allow me to       */
/* explain a little about the techniques we use.                            */
/*                                                                          */
/*     UltraWin was written with two "levels" in mind.  The first level     */
/* includes the routines that do all the down and dirty work of windowing.  */
/* The START_1.C file contains a demonstration showing how to use the       */
/* lowest level functions in an application.                                */
/*                                                                          */
/*     The second layer is what we call the window manager.  This is the    */
/* really slick part of UltraWin, as this provides capabilities to write    */
/* to any window at any time, regardless of overlap!  This layer is dealt   */
/* with in this skeleton program.                                           */
/*                                                                          */
/*     The main thing to remember when using the window manager is never    */
/* to call wn_destroy(), as the function remove_window() will call it for   */
/* you.                                                                     */
/*                                                                          */
/*                                                          Boyd Gafford    */
/*                                                          EnQue Software  */
/*                                                          12/18/90        */
/*                                                                          */
/****************************************************************************/
#include <ctype.h>
#include "uw.h"                            /* include the necessary headers */
#include "uw_globx.h"
#include "uw_keys.h"


#define   MAX_WINDOWS    8

/*----------------------- global window variables --------------------------*/
WINDOW    Desk_window;                    /* global window for "desktop"    */
WINDOW    Win_array[MAX_WINDOWS];         /* eight little windows to add    */

/*------------------------------ prototypes --------------------------------*/
int back_func();

/**************/
/* ~back_func */
/*            ***************************************************************/
/* This function is called during idle time.  If you wanted to do some      */
/* background processing, then put it here!!!                               */
/****************************************************************************/
int back_func()
{
  int i;

  for (i=0; i<MAX_WINDOWS; i++)
		wn_st("UltraWin ", &Win_array[i]);
	return(1);
}
/*** end of back_func ***/

/*********/
/* ~main */
/*       ********************************************************************/
/* This is the main routine, which does the simple skeleton demo!           */
/****************************************************************************/
int main()
{
  int i, x1, y1, x2, y2, width, height;


  init_video(80, 50);

  /* This function initializes the window library, and sets the screen to   */
  /* 80 columns and 50 rows.  After the function call, the global variables */
  /* V_cols will contain the actual number of columns on the screen, and    */
  /* V_rows will contain the actual number of rows.  If you have a VGA      */
  /* board, you will get V_cols = 80 and V_rows = 50.  If you have an EGA   */
  /* board, you will get V_cols = 80 and V_rows = 43.  If you just have CGA */
  /* you will get V_cols = 80 and V_rows = 25.  If you wanted to use the    */
  /* 80x25 screen on ANY board, just use init_video(80, 25).                */
  /* Also please note that if you want to use the mouse in this program,    */
  /* the call to init_mouse() would be next! (refer to START_1.C)           */


	init_clock(0x3333);

	/* This function takes over the PC clock, setting the timer interrupt to  */
	/* occur 91 times a second.  Once this call is made, you can use any of   */
	/* the UltraWin user timers, or the tone() function.  You do not have to  */
	/* call this if you are not going to use any of the UltraWin PC timer     */
	/* routines.                                                              */


	wn_create(0, 0, V_cols-1, V_rows-1, SLD_BDR, WN_NORMAL, &Desk_window);
  randomize();
  for (i=0; i<MAX_WINDOWS; i++)
  {
    width = random(30) + 15;
    height = random(16) + 5;
    x1 = random(V_cols - width);
    y1 = random(V_rows - height);
    x2 = x1 + width - 1;
    y2 = y1 + height - 1;
    wn_create(x1, y1, x2, y2, SLD_BDR, WN_NORMAL, &Win_array[i]);
  }

  /* Create the desktop window, and all the windows to be added.  Please    */
  /* note that we do not have to create ANY of the windows as WN_POPUP, as  */
  /* the window manager takes care of all window refresh/redraw!            */
  /* (WN_NORMAL windows also take less RAM, since what is behind them does  */
  /* not have to be saved.)                                                 */


  wn_color(WHITE, BLUE, &Desk_window);
  for (i=0; i<MAX_WINDOWS; i++)
    wn_color(WHITE, i % 8, &Win_array[i]);

  /* Set the color of all the windows in question.                          */


  wn_bdr_color(WHITE, BLUE, &Desk_window);
  for (i=0; i<MAX_WINDOWS; i++)
    wn_bdr_color((i % 8) + 8, i % 8, &Win_array[i]);

  /* Set the border color of all the windows in question.                   */


  wn_name("[ Desktop Window ]", &Desk_window);

  /* Set the title of the back window to something kind of descriptive.     */


  add_window(&Desk_window);

  /* this call will put the Desk_window on the screen!                      */


  for (i=0; i<MAX_WINDOWS; i++)
    add_window(&Win_array[i]);

  /* Add each of the windows to the linked list.  Notice that a call to     */
  /* the lower level wn_set() is not necessary! ( add_window() does it for  */
  /* you! )                                                                 */

  /* NOTE:  If you want to do a "popup" window with the window manager, all */
  /* you have to do is create it the size you wish with wn_create(), then   */
  /* set the colors with wn_color() and wn_bdr_color(), then call the       */
  /* add_window() function to place it on the screen!  When you are finished*/
  /* with the window, just call remove_window().  The screen will be updated*/
  /* and you don't have to worry about a thing.  Morover, you can create    */
  /* your popup window with the WN_NORMAL define!  You don't have to define */
  /* the window as a WN_POPUP type as you do with the lower level layer     */
  /* that employs wn_create/wn_set/wn_destroy.                              */


  set_idle_func(back_func);

  /* This tells UltraWin to do back_func() while waiting for an event,      */
  /* which gives you the ablilty to do some background tasks if you wish!   */
  /* In this case, were just outputting a string to all 8 windows.          */


  wait_event();

  /* Simply tells UltraWin to wait for an event (a keypress since we did    */
  /* not activate the mouse with init_mouse() after the init_video() call). */
  /* Please note that we could have just as easily substitued the           */
  /* "set_idle_func(back_func);wait_event();set_idle_func(NULL);" sequence  */
  /* with a simple "while (!event_pending()) back_func();".  As a matter of */
  /* fact, wait_event() is simply:                                          */
  /*                                                                        */
  /*  do                                                                    */
  /*  {                                                                     */
  /*    if( Idle_func != NULL )                                             */
  /*      (*Idle_func)();                                                   */
  /*  } while (!event_pending());                                           */


  set_idle_func(NULL);

  /* This tells UltraWin to not do any background calls to an idle func,    */
  /* which results in a "turning off" of the background tasks.              */


  for (i=(MAX_WINDOWS - 1); i>=0; i--)
    remove_window(&Win_array[i]);

  /* Take off each of the windows added, in reverse order for "nicety"!     */


  remove_window(&Desk_window);

  /* Remove the desktop window from the linked list as well, prior to       */
  /* exiting to DOS.                                                        */


  end_video();

  /* This cleans up and resets the video mode that was active when you      */
  /* first began the program.  Be sure to call this as the last function    */
  /* before you return to DOS!                                              */
}
/*** end of main ***/

/*** END OF FILE ***/
