comment ~
  This file contains code to
    1) determine the size of a LE-exe file image (when you've loaded the header)
    2) load in the LE-exe file image
    3) apply fixups so you can run it

Mucho greets go to Michael Tippach aka Wuschel (WDOSX, remember?),
since I got the original source from his debugger. I know, I'm lame,
but when the code is already there and you don't want to spend a
lot of your time learning the LE-exe file format inside-out, well,
it's certainly a bit easier to do some cut-n-paste...

This file is used by the main QDLL handler, and by QDLLFIX,
the program that generates dlls from exe files. See qdll.txt
for a description of how everything works (or see source :^))

- Sune Marcher, 03/28/98 (late night...02:18)
~

;DEBUG EQU 1

.data

LEHeader        struct    ;46 dwords total

LESignature	dd	?	; must be 0x454C since order is little endian
LEFormatLevel	dd	?	; not really needed
LECpuType	dw	?
LETargetSystem	dw	?	; should be 01 (OS/2)
LEModuleVersion	dd	?	; who cares...
LEModuleType	dd	?	; Must be flat
LENumberPages   dd      ?       ; # of physical pages
LEEntrySection	dd	?
LEEntryOffset	dd	?
LEStackSection	dd	?
LEInitialESP	dd	?
LEPageSize	dd	?
LEBytesLastPage	dd	?
LEFixupSize	dd	?
LEFixupChecks	dd	?
LELoaderSize	dd	?
LELoaderChecks	dd	?
LEObjectTable	dd	?
LEObjectEntries	dd	?
LEObjectPMTable	dd	?
LEIterateData	dd	?
LEResourceTable	dd	?
LEResources	dd	?
LEResNamesTable	dd	?
LEEntryTable	dd	?
LEModuleDirTab	dd	?
LEModuleDirs	dd	?
LEFixupPageTab	dd	?
LEFixupRecords	dd	?
LEWeDontNeed	dd	3 dup (?)	; getting bored
LEPPchecksumTab	dd	?
LEDataPages	dd	?
LEPreloadPages	dd	?
LEWeDontNeed2	dd	3 dup (?)
LEAutoData	dd	?
LEDebugStart	dd	?
LEDebugSize	dd	?
LEPrelInstPages	dd	?
LEDemdInstPages	dd	?
LEExtraHeap     dd      ?  
LEReserved      dd      3 dup (?)

LEHeader ends

ObjectTable     struct  ;24 bytes

OTVirtualSize	dd	?
OTRelocBase	dd	?
OTObjectFlags	dd	?
OTPageMapIndex	dd	?
OTPageMapSize	dd	?
OTReserved	dd	?

ObjectTable ends

ObjectPMTable   struct  ;4 bytes

OPMTUnknown	db	?
OPMTFixupTabIdx	dw	?	; big endian!
OPMTType	db	?	; 0 = no reloc 3 = reloc

ObjectPMTable ends

;Fixup type equates

ModSingle	equ	1000h
ModMultiple	equ	3000h

;only valid types listed here

ByteOffset	equ	0
WordOffset	equ	5
DwordOffset	equ	7
RelativeJMP	equ	8

OrdinalIsByte	equ	80h
OrdinalIs16	equ	40h
AddADword	equ	20h
SizeOverride	equ	10h
AddToDest	equ	4

;Single internal fixup

_FixupRecord    struct  ;7 bytes

FRType		dw	?	;only 6 and 7 supported
FROffset	dw	?
FRObject	db	?
FRItem		dw	?

_FixupRecord ends

counter         dd ?
filehandle      dw ?

.code

le_size proc header:dword
  push ebx
  push ecx
  push esi

  mov  esi,header

  mov  ecx,[esi].LEHeader.LEObjectEntries
  add  esi,[esi].LEHeader.LEObjectTable

  xor  eax,eax
@@les_loop:
  mov  ebx,[esi]             ; get size of page
  add  esi,24                ; next page
  add  ebx,4095              ; \ page-align the
  and  ebx,NOT 4095          ; / page size
  add  eax,ebx               ; add to totals counter

  dec  ecx
  jnz  @@les_loop

  pop  esi
  pop  ecx
  pop  ebx

  ret
le_size endp

le_load proc header:dword,hnd:word,buffer:dword
  xor  eax,eax                         ; by default, return false
  pushad

  mov  ax,hnd
  mov  filehandle,ax

  mov  edx,buffer                      ; where to load objects
  mov  ebp,header                      ; this is generally bad...


  mov  eax,LEHeader.LENumberPages[ebp]
  inc  eax
  mov  counter,eax

  mov  edi,LEHeader.LEObjectEntries[ebp]    ;# objects to load
  mov  esi,LEHeader.LEObjectTable[ebp]      ;offset of objects table

LoadObject:

  mov  ebx,ObjectTable.OTPageMapSize[ebp+esi]
  mov  eax,ObjectTable.OTPageMapIndex[ebp+esi]
  shl  eax,2
  add  eax,LEHeader.LEObjectPMTable[ebp]

; Use reserved field to store actual object load address

  mov  ObjectTable.OTReserved[ebp+esi],edx
  mov  ecx,LEHeader.LEPageSize[ebp]

  test ebx,ebx
  jz   ebxwaszero
ReadPage:

;check against Object Page Table (load or relocation only)
  
  cmp  byte ptr [eax+ebp-1],0
  jnz  AfterRead

  push eax
  push ebx

  mov  ah,3fh
  mov  bx,filehandle
  int  21h
  jc   file_error

  pop ebx
  pop eax

AfterRead:
  add  edx,ecx
  add  eax,4
  dec  counter
  jz   cnt_error
  dec  ebx
  jnz  ReadPage
ebxwaszero:
  add  esi,24
  dec  edi
  jnz  LoadObject

  popad
  ret

file_error:
cnt_error:
  popad
  dec  eax         ; return ERROR
  ret

le_load endp

exe_off dd ?
buf_off dd ?

le_fixup1 proc header:dword,buffer:dword
  xor  eax,eax
  pushad

;  mov  edx,buffer                      ; where to load objects
  xor  edx,edx
  mov  ebp,header

  mov  eax,LEHeader.LENumberPages[ebp]
  inc  eax
  mov  counter,eax

  mov  edi,LEHeader.LEObjectEntries[ebp]    ;# objects to load
  mov  esi,LEHeader.LEObjectTable[ebp]      ;offset of objects table

LoadObject:

  mov  ebx,ObjectTable.OTPageMapSize[ebp+esi]
  mov  eax,ObjectTable.OTPageMapIndex[ebp+esi]
  shl  eax,2
  add  eax,LEHeader.LEObjectPMTable[ebp]

; Use reserved field to store actual object load address
  mov  ObjectTable.OTReserved[ebp+esi],edx
  mov  ecx,LEHeader.LEPageSize[ebp]

  test ebx,ebx
  jz   ebxwaszero
ReadPage:

;check against Object Page Table (load or relocation only)
  
  cmp  byte ptr [eax+ebp-1],0
  jnz  AfterRead

AfterRead:
  add  edx,ecx
  add  eax,4
  dec  counter
  jz   cnt_error
  dec  ebx
  jnz  ReadPage
ebxwaszero:
  add  esi,24
  dec  edi
  jnz  LoadObject

  popad
  ret

cnt_error:
  popad
  dec  eax         ; return ERROR
  ret
le_fixup1 endp

le_fixup proc leheader:dword,exeimg:dword
  xor eax,eax
  pushad

  mov  eax,exeimg
  mov  exe_off,eax
  mov  ebp,leheader

  mov esi,LEHeader.LEObjectTable[ebp]
  mov edi,LEHeader.LEFixupPageTab[ebp]
  xor edx,edx
  mov ecx,LEHeader.LEFixupRecords[ebp]
  add ecx,ebp

FixupPage:
  mov ebx,[edi+ebp]
  cmp ebx,[edi+ebp+4]
  jnc FixupDone

FixupRecord:

  ; sort of an inner loop [ebx+ecx] = start of fixup record

  cmp byte ptr _FixupRecord.FRType[ebx+ecx+1],10h
  jnz check16bit

;-------------- 32 bit target ------------------------

  push edi
  movzx edi,_FixupRecord.FRObject[ecx+ebx]
  mov eax,dword ptr _FixupRecord.FRItem[ecx+ebx]
  lea edi,[edi*2+edi-3]
  lea edi,[edi*8+esi]      ; edi = (edi*3-3)*8 + esi
  cmp word ptr _FixupRecord.FRType[ebx+ecx],1002h
  jnz FuNoSel32

  test ObjectTable.OTObjectFlags[edi+ebp],4 ;executable?
  movsx edi,_FixupRecord.FROffset[ecx+ebx]   ;can be negative!
  push edx
  pushfd
  add edx,exe_off
  mov word ptr [edi+edx],ds
  popfd
  jz IsdataSel32
  mov word ptr [edi+edx],cs
IsdataSel32:
  pop edx
  pop edi
  add ebx,7
  cmp ebx,[edi+ebp+4]
  jc FixupRecord
  jmp FixupDone
FuNoSel32:

  add eax,ObjectTable.OTReserved[edi+ebp]
  push edi
  movsx edi,_FixupRecord.FROffset[ecx+ebx] ;can be negative!
  push edx
  cmp word ptr _FixupRecord.FRType[ebx+ecx],1008h
  jnz NoRel32
  sub eax,edx
  sub eax,edi
  sub eax,4
NoRel32:
  add edx,exe_off
  mov [edi+edx],ax
  cmp word ptr _FixupRecord.FRType[ebx+ecx],1005h
  jz Fu32_16
  mov [edi+edx],eax
Fu32_16:
  pop edx
  pop edi
;2do:
  cmp word ptr _FixupRecord.FRType[ebx+ecx],1007h
  jz Only32Ofs
  cmp word ptr _FixupRecord.FRType[ebx+ecx],1005h
  jz Only32Ofs
  cmp word ptr _FixupRecord.FRType[ebx+ecx],1008h
  jz Only32Ofs
  cmp word ptr _FixupRecord.FRType[ebx+ecx],1006h
  jnz format_error

;-------------- get section attributes -----------------

  push edi
  test ObjectTable.OTObjectFlags[edi+ebp],4 ;executable?
  movsx edi,_FixupRecord.FROffset[ecx+ebx]  ;can be negative!
  push edx
  pushfd
  add edx,exe_off
  mov [edi+edx+4],ds
  popfd
  jz Isdata32
  mov [edi+edx+4],cs
Isdata32:
  pop edx
  pop edi
Only32Ofs:
  pop edi
  add ebx,9
  cmp ebx,[edi+ebp+4]
  jc FixupRecord
  jmp FixupDone

;-------------- 16 bit target ------------------------

check16bit:
  cmp   byte ptr _FixupRecord.FRType[ebx+ecx+1],0
  jnz   format_error

  push  edi
  movzx edi,_FixupRecord.FRObject[ecx+ebx]
  movzx eax,_FixupRecord.FRItem[ecx+ebx]
  lea   edi,[edi*2+edi-3]
  lea   edi,[edi*8+esi]       ; edi = (edi*3-3)*8 + esi

  cmp   byte ptr _FixupRecord.FRType[ebx+ecx],2
  jnz   FuNoSel16
  test  ObjectTable.OTObjectFlags[edi+ebp],4 ;executable?
  movsx edi,_FixupRecord.FROffset[ecx+ebx]   ;can be negative!
  push  edx
  pushfd
  add   edx,exe_off
  mov   word ptr [edi+edx],ds
  popfd
  jz    IsdataSel16
  mov   word ptr [edi+edx],cs
IsdataSel16:
  pop   edx
  pop   edi
  add   ebx,5
  cmp   ebx,[edi+ebp+4]
  jc    FixupRecord
  jmp   FixupDone

FuNoSel16:
  add   eax,ObjectTable.OTReserved[edi+ebp]
  push  edi
  movsx edi,_FixupRecord.FROffset[ecx+ebx] ;can be negative!
  push  edx

  cmp   _FixupRecord.FRType[ebx+ecx],8
  jnz   NoRel16
  sub   eax,edx
  sub   eax,edi
  sub   eax,4
NoRel16:
  add   edx,exe_off
  mov   [edi+edx],ax
  cmp   word ptr _FixupRecord.FRType[ebx+ecx],5
  jz    Fu16_16
  mov   [edi+edx],eax
Fu16_16:
  pop   edx
  pop   edi
  cmp   word ptr _FixupRecord.FRType[ebx+ecx],7
  jz    OnlyOfs
  cmp   word ptr _FixupRecord.FRType[ebx+ecx],5
  jz    OnlyOfs
  cmp   word ptr _FixupRecord.FRType[ebx+ecx],8
  jz    OnlyOfs
  cmp   word ptr _FixupRecord.FRType[ebx+ecx],6
  jnz   format_error

  push  edi
  test  ObjectTable.OTObjectFlags[edi+ebp],4 ;executable?
  movsx edi,_FixupRecord.FROffset[ecx+ebx] ;can be negative!
  push  edx
  pushfd
  add   edx,exe_off
  mov   word ptr [edi+edx+4],ds
  popfd
  jz    Isdata16
  mov   word ptr [edi+edx+4],cs

Isdata16:
  pop   edx
  pop   edi

OnlyOfs:
  pop   edi
  add   ebx,7
  cmp   ebx,[edi+ebp+4]
  jc    FixupRecord

FixupDone:
  add   edi,4
  add   edx,LEHeader.LEPageSize[ebp]
  dec   LEHeader.LENumberPages[ebp]
  jnz   FixupPage

  popad
  ret

format_error:
  popad
  dec eax
  ret
le_fixup endp

; figure_bss_size:
;  this function is used by QDLLFIX to determine the size
;  of the le image BSS section. It is necessary to keep
;  the qdll format simple.
figure_bss_size proc img:dword,siz:dword
  pushad

  mov  esi,img               ; offset of image
  add  esi,siz               ; add size
  dec  esi                   ; ESI=last byte in image
  xor  eax,eax
@findloop:
  cmp  [esi],al              ; still a zero byte?
  jne  @split
  dec  esi                   ; index--
  cmp  esi,img               ; esi<=img should NEVER happen
  jne  @findloop

@split:
; calculate size of the BSS
  mov edi,esi
  sub edi,img
  mov eax,siz
  sub eax,edi
  dec eax                    ; so everything works out

  mov [esp].callstruct._eax,eax  ;Save EAX

  popad

  ret
figure_bss_size endp

le_fixup_cnv proc leheader:dword,outbuf:dword
  xor eax,eax
  pushad

  mov  eax,outbuf
  mov  buf_off,eax
  mov  ebp,leheader

  mov esi,LEHeader.LEObjectTable[ebp]
  mov edi,LEHeader.LEFixupPageTab[ebp]
  xor edx,edx
  mov ecx,LEHeader.LEFixupRecords[ebp]
  add ecx,ebp

FixupPage:
  mov ebx,[edi+ebp]
  cmp ebx,[edi+ebp+4]
  jnc FixupDone

FixupRecord:

  ; sort of an inner loop [ebx+ecx] = start of fixup record

  cmp byte ptr _FixupRecord.FRType[ebx+ecx+1],10h
  jnz check16bit

;-------------- 32 bit target ------------------------

  push  edi
  movzx edi,_FixupRecord.FRObject[ecx+ebx]
  mov   eax,dword ptr _FixupRecord.FRItem[ecx+ebx]
  lea   edi,[edi*2+edi-3]
  lea   edi,[edi*8+esi]      ; edi = (edi*3-3)*8 + esi

  cmp   word ptr _FixupRecord.FRType[ebx+ecx],1007h
  jne   format_error

;  add   eax,ObjectTable.OTReserved[edi+ebp]
  push  edi
  movsx edi,_FixupRecord.FROffset[ecx+ebx] ;can be negative!
  push  edx
;  add   edx,exe_off
;  mov   [edi+edx],ax ; 16bit only
;  mov [edi+edx],eax  ; 32bit

  add  edx,edi
  mov  edi,buf_off
  mov  [edi],edx       ; fixup location
  mov  [edi+4],eax     ; fixup
  add  edi,8
  mov  buf_off,edi

  pop  edx
  pop  edi

  pop  edi
  add  ebx,9
  cmp  ebx,[edi+ebp+4]
  jc   FixupRecord
  jmp FixupDone

;-------------- 16 bit target ------------------------

check16bit:
  cmp   byte ptr _FixupRecord.FRType[ebx+ecx+1],0
  jnz   format_error

  push  edi
  movzx edi,_FixupRecord.FRObject[ecx+ebx]
  movzx eax,_FixupRecord.FRItem[ecx+ebx]
  lea   edi,[edi*2+edi-3]
  lea   edi,[edi*8+esi]       ; edi = (edi*3-3)*8 + esi


  cmp   byte ptr _FixupRecord.FRType[ebx+ecx],7
  jne   format_error

;  add   eax,ObjectTable.OTReserved[edi+ebp]
  push  edi
  movsx edi,_FixupRecord.FROffset[ecx+ebx] ;can be negative!
  push  edx

;  add   edx,exe_off
;  mov   [edi+edx],ax   ; 16bit target
;  mov   [edi+edx],eax  ; 32bit target

  add  edx,edi
  mov  edi,buf_off
  mov  [edi],edx
  mov  [edi+4],eax
  add  edi,8
  mov  buf_off,edi

  pop   edx
  pop   edi

  pop   edi
  add   ebx,7
  cmp   ebx,[edi+ebp+4]
  jc    FixupRecord

FixupDone:
  add   edi,4
  add   edx,LEHeader.LEPageSize[ebp]
  dec   LEHeader.LENumberPages[ebp]
  jnz   FixupPage

  popad

  mov  eax,buf_off
  sub  eax,outbuf

  ret

format_error:
  popad
  dec eax
  ret
le_fixup_cnv endp

