/* gjid03.c                         freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* --------------------------------- MAIN ----------------------------------- */
 main()
{

double pb[3][4*TWOCOL]=
{
  14,1,  -16,1,  -19,1,  15,1,
  13,1,   13,1,   12,1, -14,1,
 -12,1,   17,1,  -13,2,  12,1,
};
matrix m={3,4*TWOCOL,&pb[0][0]};

double pbT3  [3][4*TWOCOL]; matrix mT3   ={3,4*TWOCOL,&pbT3  [0][0]};
double pbT4  [3][4*TWOCOL]; matrix mT4   ={3,4*TWOCOL,&pbT4  [0][0]};
double pbID  [3][3*TWOCOL]; matrix mID   ={3,3*TWOCOL,&pbID  [0][0]};
/*-------------------------------- PROGRAM ---------------------------------- */
 copymF(&m,&mT3);
 copymF(&m,&mT4);

 printf("\n");
 printf(" The matrix  mA \n");
 printmF(&m);
 getchar();

 printf(" Find mID (below the pivots) \n");
 idF4(&mID,&m);
 printmF(&mID);
 getchar();

 printf("  mID * mA  \n");
 multmF(&mID,&mT3,&m);
 printmF(&m);
 getchar();

 copymF(&m,&mT3);

 clrscrn();
 printf(" Find mID (above the pivots) \n");
 idF4a(&mID,&m);
 printmF(&mID);
 getchar();

 printf("  mID * mA  \n");
 multmF(&mID,&mT3,&m);
 printmF(&m);
 getchar();

 printf(" Verify with gaussjordanF(); \n");
 copymF(&mT4,&m);
 gaussjordanF(&m);
 printmF(&m);

 printf("\n Press a key to continue");
 getchar();

 return 0;
}



