/* mygauss.h                    freeware                   xhunga@tiscali.fr  */


/* ------------------------------ FUNCTION ---------------------- growminiF() */
/* Do   :                                                                     */
/* Call : fmod()                                                              */
/* -------------------------------------------------------------------------- */
void growminiF(
pmatrix m,
    int row)
{
     int j;
     int i;
  double t;
     int nb1er   = FIRSTNB1ER;
     int ttrue   = 1;

/* ************************************************************************** */
/* In this function 0 = 0/0. In other part 0 = 0/1.                           */
/* Why :  growminiF(1, 2, 4, 6, 8) = 1, 2, 4, 6, 8                             */
/*        growminiF(0, 2, 4, 6, 8) = 0, 1, 2, 3, 4                             */
/*        0 is a multiple of any numbers                                      */
/*        1 is a multiple of 1                                                */
/* ************************************************************************** */
for (j = 0;  j < m->cols ; j++, j++)
{
 t = *(m->pblock + row *m->cols + j);
 if(!t)
 {
 *(m->pblock + row *m->cols + j + 1 ) = 0;
 }
}
/* ************************************************************************** */


for(i = 0; i < 2 ; i++)         /* i = 0 -> numerators, i = 1 -> denominators */
{
nb1er = FIRSTNB1ER;
while(nb1er < LASTNB1ER)
 {
  ttrue  = 1;                             /* ttrue = 1 try tnb1er[nb1er     ] */
       j = i ;                            /*    the first column of the row n */

/* ========================================================================== */
     while((j < m->cols) && (ttrue))      /*     all the columns of the row n */
      {
      t = *(m->pblock + row *m->cols + j);
/* -------------------------------- true = 0 ? ------------------------------ */
      if( (fmod(t,tnb1er[nb1er]) != 0) )
         {
/*                                 printf(" %.1f / %d \n\n",t,tnb1er[nb1er]); */
           ttrue = 0; /* a value of the row n is not multiple of tnb1er[nb1er]*/
           j = m->cols;
         }

      if(t)
      {
      if( (tnb1er[nb1er]) > fabs(t))
        {
          nb1er = LASTNB1ER-1;
          ttrue = 0; /* a value of the row n is not multiple of tnb1er[nb1er] */
              j = m->cols;
        }
      }
/* -------------------------------- true = 0 ? ------------------------------ */
       j++; j++;
      }
/* ========================================================================== */


/* ########################################################################## */
/* -------------------------------- true = 1 -------------------------------- */
     if(ttrue)
       {
/*                                            divide the row by tnb1er[nb1er] */
        for (j = i;  j < m->cols ; j++, j++)
         {
          *(m->pblock + row *m->cols + j) = \
          *(m->pblock + row *m->cols + j) / tnb1er[nb1er];

         }
       }
/* -------------------------------- true = 1 -------------------------------- */
/* ########################################################################## */

  nb1er++;
 }
}


/* ************************************************************************** */
/* In this function   0 = 0/0.                                                */
/* In other part      0 = 0/1.                                                */
/* Now you must write 0 = 0/1.                                                */
/* ************************************************************************** */
for (j = 0;  j < m->cols ; j++, j++)
{
 t = *(m->pblock + row *m->cols + j);
 if(!t)
 {
 *(m->pblock + row *m->cols + j + 1 ) = 1;
 }
}
/* ************************************************************************** */
}

/* ------------------------------ FUNCTION --------------------- pivotbestF() */
/*                                                                            */
/* -------------------------------------------------------------------------- */
int gausspivotbestF(
pmatrix m,
    int row,
    int col)
{
   int  sign =       1;
   int  row2 = row + 1;
 double pivotN;
 double pivotD;
 double belowpivotN;
 double belowpivotD;

      frowminiF(m,row);
       growminiF(m,row);

       pivotN = fabs(*(m->pblock + row *m->cols + col  * TWOCOL    ));
       pivotD = fabs(*(m->pblock + row *m->cols + col  * TWOCOL + 1));

   while(row2 < m->rows)
   {
     growminiF(m,row2);
    frowminiF(m,row2);
    belowpivotN = *(m->pblock + row2 *m->cols + col * TWOCOL    );
    belowpivotD = *(m->pblock + row2 *m->cols + col * TWOCOL + 1);

       if(fabs(belowpivotN) < fabs(pivotN))
         {
          if(belowpivotN)
            {
             swaprowF(m,row,row2);
             pivotN = belowpivotN;
             pivotD = belowpivotD;
              sign *= -1;
            }
         }

       if(fabs(belowpivotN) == fabs(pivotN))
         {
           if(fabs(belowpivotD) < fabs(pivotD))
            {
             swaprowF(m,row,row2);
             pivotN = belowpivotN;
             pivotD = belowpivotD;
             sign *= -1;
            }
         }
    row2++;
   }

return(sign);
}

/*------------------------------- FUNCTION -------------------------- gauss() */
/*                                                                            */
/* -------------------------------------------------------------------------- */
void gaussF(
pmatrix m)
{
   int row1;
   int row2;
double coefnulldoNothing = 1;

/*--------------------------------------------------------------------  gauss */
for (row1 = 0 ; row1 < m->rows-1 ; row1++)
{
     pivotntzeroF(m,row1, row1);
  gausspivotbestF(m,row1, row1);
  for (row2 = row1 + 1 ; row2 < m->rows ; row2++)
    {
     coefnulldoNothing = *(m->pblock + row2 *m->cols + row1*TWOCOL);
     if(coefnulldoNothing)
      {
        frowminiF(m,row2);
         growminiF(m,row2);
       pivotworkF(m,row1,row2);
        frowminiF(m,row2);
         growminiF(m,row2);
      }
    }
}
pivotminiF(m);
}

/*------------------------------- FUNCTION -------------------- gaussjordan() */
/*   printmF(m);  getchar();                                                                */
/* -------------------------------------------------------------------------- */
void gaussjordanF(
pmatrix m)
{
int row1;
int row2;
double coefnulldoNothing =1;

/*--------------------------------------------------------------------  gauss */
for (row1 = 0 ; row1 < m->rows-1 ; row1++)
{
     pivotntzeroF(m,row1, row1);
  gausspivotbestF(m,row1, row1);
  for (row2 = row1 + 1 ; row2 < m->rows ; row2++)
    {
     coefnulldoNothing = *(m->pblock + row2 *m->cols + row1*TWOCOL);
     if(coefnulldoNothing)
      {
        frowminiF(m,row2);
         growminiF(m,row2);
       pivotworkF(m,row1,row2);
        frowminiF(m,row2);
         growminiF(m,row2);
      }
     }
}

/*-------------------------------------------------------------------- jordan */
for (row1 = m->rows-1 ; row1>0 ; row1--)
{
         frowminiF(m,row1);
         growminiF(m,row1);
   for (row2 = 0 ; row2 < row1 ; row2++)
      {
        frowminiF(m,row2);
         growminiF(m,row2);
       pivotworkF(m,row1,row2);
        frowminiF(m,row2);
         growminiF(m,row2);
      }
}
pivotminiF(m);
}


