/* conic01.c                       freeware                    xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* --------------------------------- MAIN ----------------------------------- */
 main()
{
fraction fx;
fraction fy;

double pbpxy[4][2*TWOCOL]=
{
   1,1,   -8,1,
   2,1,    2,1,
   3,1,    1,1,
   4,1,    2,1,
};
matrix mpxy={4,2*TWOCOL,&pbpxy[0][0]};

double pb[5][6*TWOCOL];matrix m={5,6*TWOCOL,&pb[0][0]};

/*-------------------------------- PROGRAM ---------------------------------- */
  printf("\n");
  printf(" Find the coefficients a, b, c, d, e, of the curve        \n\n");
  printf("     ax**2 + by**2 + cx + dy + e  = 0 \n\n");
  printf(" that passes through these four points.                   \n\n");

  printf("     x            y \n");
  printmF4(&mpxy);

  printf("\n");
  printf(" Using the given points, we obtain this matrix.\n");
  printf("  (a = 1/1. This is my choice)\n\n");
  printf("  (a)x**2      (b)y**2      (c)x         ");
  printf("(d)y           (e)              \n");
  mofconicA(&mpxy,&m);
  printmF4(      &m);
  getchar();

  clrscrn();
  printf("The Gauss Jordan process will reduce this matrix to : \n");
  gaussjordanF(&m);
  printmF4(&m);
  getchar();

  printf("\n\n");
  printf(" The coefficients a, b, c, d, e, of the curve are :  \n\n");
  conicresultis(&m);
  getchar();

   printf("     x            y   The given point.\n");
   printmF4(&mpxy);
   printf("\n\n");

  printf(" If you have changed the value of x,y.            \n");
  printf(" You must write here, the good value by hand.   \n\n");

fx.numer = 1;fx.denom = 1; fy.numer = -8;fy.denom = 1;calculate_conic(&m,fx,fy);
fx.numer = 2;fx.denom = 1; fy.numer =  2;fy.denom = 1;calculate_conic(&m,fx,fy);
fx.numer = 3;fx.denom = 1; fy.numer =  1;fy.denom = 1;calculate_conic(&m,fx,fy);
fx.numer = 4;fx.denom = 1; fy.numer =  2;fy.denom = 1;calculate_conic(&m,fx,fy);

  gnpltconicresultis("geom2d.plt",&m);
  gnpltvectrow2d(    "points",     &mpxy);

  printf("\n\n To see the result in Gnuplot (gp373w32.exe) : \n\n");
  printf("  * open the file \"geom2d.plt\" with Gnuplot.  \n");

  printf("\n\n Press return to continue");
  getchar();
}



