/* gjid03.c                         freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* --------------------------------- FUNCTION ------------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
invb(int n)
{
int x;

double pbA   [MXR][MXC*TWOCOL];matrix mA   ={MXR,MXC*TWOCOL,&pbA   [0][0]};
double pbA_b1[MXR][MXC*TWOCOL];matrix mA_b1={MXR,MXC*TWOCOL,&pbA_b1[0][0]};
double pbA_b2[MXR][MXC*TWOCOL];matrix mA_b2={MXR,MXC*TWOCOL,&pbA_b2[0][0]};
double pbA_bn[MXR][MXC*TWOCOL];matrix mA_bn={MXR,MXC*TWOCOL,&pbA_bn[0][0]};
double pbb1  [MXR][    TWOCOL];matrix mb1  ={MXR,    TWOCOL,&pbb1  [0][0]};
double pbb2  [MXR][    TWOCOL];matrix mb2  ={MXR,    TWOCOL,&pbb2  [0][0]};


                     mA.rows=n;                   mA.cols= n   *TWOCOL;
                  mA_b1.rows=n;                mA_b1.cols=(n+1)*TWOCOL;
                  mA_b2.rows=n;                mA_b2.cols=(n+1)*TWOCOL;
                  mA_bn.rows=n;                mA_bn.cols=(n+2)*TWOCOL;
                    mb1.rows=n;                  mb1.cols=      TWOCOL;
                    mb2.rows=n;                  mb2.cols=      TWOCOL;

/*-------------------------------- PROGRAM ---------------------------------- */
         x =  6;
 if(n<3){x = 10;}

  rndmF(&mA, x,2);  rndmF(&mb1,x,2); rndmF(&mb2,x,2);

  copymF(  &mA,   &mA_b1    );  copycolF(&mb1,0,&mA_b1,n  );
  copymF(  &mA,   &mA_b2    );  copycolF(&mb2,0,&mA_b2,n  );
  copymF(  &mA,   &mA_bn    );  copycolF(&mb1,0,&mA_bn,n  );
                                copycolF(&mb2,0,&mA_bn,n+1);

  clrscrn();
  printf("\n Linear systems with a common coefficient matrix : Ax = A|b1|b2 \n");
  printf("\n                                              A  :\n");
  printmF4(&mA);
  printf("\n                                              b1 :\n");
  printmF4(&mb1);
  printf("\n                                              b2 :\n");
  printmF4(&mb2);
  getchar();

  clrscrn();
  printf("\n                                         A|b1|b2 :\n");
  printmF4(     &mA_bn);
  gaussjordanF(&mA_bn);
  printf("\n      Gauss Jordan elimination of matrix A|b1|b2 :\n");
  printmF4(     &mA_bn);
  getchar();

  clrscrn();
  printf("\n      Gauss Jordan elimination of matrix A|b1|b2 :");
  printmF4(     &mA_bn);
  printf("\n                                            A|b1 :");
  printmF4(     &mA_b1);
  printf("\n         Gauss Jordan elimination of matrix A|b1 :");
  gaussjordanF(&mA_b1);
  printmF4(     &mA_b1);
  getchar();

  clrscrn();
  printf("\n      Gauss Jordan elimination of matrix A|b1|b2 :");
  printmF4(     &mA_bn);
  printf("\n                                            A|b2 :");
  printmF4(     &mA_b2);
  printf("\n         Gauss Jordan elimination of matrix A|b2 :");
  gaussjordanF(&mA_b2);
  printmF4(     &mA_b2);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n                                                  ");
  printf("\n            GaussJordan : A|b1|b2                 ");
  printf("\n            *********************               \n");
  printf("\n The size of mA : 2x2 ... 4x4.                  \n");
  printf("\n           ex : \"gausx2f.exe\"                 \n");
  printf("\n You can choose the size :                      \n");
  printf("\n           ex : \"gausx2f.exe 2\" -> mA 2x2       ");
  printf("\n                \"gausx2f.exe 3\" -> mA 3x3       ");
  printf("\n                \"gausx2f.exe 4\" -> mA 4x4       ");
  printf("\n                                                  ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");

  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;
/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 2 && atoi(argv[1]) )
 {n = atoi(argv[1]); if( n > 4){n=4;} }
else
 {    n=rndpI(4);  }
   if(n<2){n=2;}


  invb(n);


printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}

