/* gjid03.c                         freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xahfile.h"

/* ------------------------------ FUNCTION -------------------------  */
/* Do    :                                      */
/*                             */
/* Call  :                                                            */
/* Debug :
/* -------------------------------------------------------------------------- */
invb(int n)
{
int x;
int m = n + 3;
int p = n + 1;

double pbA    [n][n*TWOCOL]; matrix mA    ={n,n*TWOCOL,&pbA   [0][0]};
double pbb1   [n][  TWOCOL]; matrix mb1   ={n,  TWOCOL,&pbb1  [0][0]};
double pbb2   [n][  TWOCOL]; matrix mb2   ={n,  TWOCOL,&pbb2  [0][0]};
double pbb3   [n][  TWOCOL]; matrix mb3   ={n,  TWOCOL,&pbb3  [0][0]};
double pbA_bn [n][m*TWOCOL]; matrix mA_bn ={n,m*TWOCOL,&pbA_bn[0][0]};
double pbA_b1 [n][p*TWOCOL]; matrix mA_b1 ={n,p*TWOCOL,&pbA_b1[0][0]};
double pbA_b2 [n][p*TWOCOL]; matrix mA_b2 ={n,p*TWOCOL,&pbA_b2[0][0]};
double pbA_b3 [n][p*TWOCOL]; matrix mA_b3 ={n,p*TWOCOL,&pbA_b3[0][0]};

/*-------------------------------- PROGRAM ---------------------------------- */
         x =  6;
 if(n<3){x = 10;}

  randmF(&mA, x,5);
  randmF(&mb1,x,5);
  randmF(&mb2,x,5);
  randmF(&mb3,x,5);

  copymF(&mA, &mA_b1 );  copycolF(&mb1,0,&mA_b1,n  );
  copymF(&mA, &mA_b2 );  copycolF(&mb2,0,&mA_b2,n  );
  copymF(&mA, &mA_b3 );  copycolF(&mb3,0,&mA_b3,n  );
  copymF(&mA, &mA_bn );  copycolF(&mb1,0,&mA_bn,n  );
                         copycolF(&mb2,0,&mA_bn,n+1);
                         copycolF(&mb3,0,&mA_bn,n+2);
  clrscrn();
  printf("\n Linear systems with a common coefficient matrix : Ax = A|b1|b2|b3 \n");
  printf("\n                                              A  :\n");
  printmF4(&mA);
  getchar();

  clrscrn();
  printf("\n                                              b1 :\n");
  printmF4(&mb1);
  printf("\n                                              b2 :\n");
  printmF4(&mb2);
  printf("\n                                              b3 :\n");
  printmF4(&mb3);
  getchar();

  clrscrn();
  printf("\n                                      A|b1|b2|b3 :\n");
  printmF4(    &mA_bn);
  gaussjordanF(&mA_bn);
  printf("\n   Gauss Jordan elimination of matrix A|b1|b2|b3 :\n");
  printmF4(    &mA_bn);
  getchar();

  clrscrn();
  printf("\n   Gauss Jordan elimination of matrix A|b1|b2|b3 :\n");
  printmF4(    &mA_bn);
  printf("\n                                            A|b1 :\n");
  printmF4(    &mA_b1);
  printf("\n         Gauss Jordan elimination of matrix A|b1 :\n");
  gaussjordanF(&mA_b1);
  printmF4(    &mA_b1);
  getchar();

  clrscrn();
  printf("\n   Gauss Jordan elimination of matrix A|b1|b2|b3 :\n");
  printmF4(    &mA_bn);
  printf("\n                                            A|b2 :\n");
  printmF4(    &mA_b2);
  printf("\n         Gauss Jordan elimination of matrix A|b2 :\n");
  gaussjordanF(&mA_b2);
  printmF4(    &mA_b2);
  getchar();

  clrscrn();
  printf("\n   Gauss Jordan elimination of matrix A|b1|b2|b3 :\n");
  printmF4(    &mA_bn);
  printf("\n                                            A|b3 :\n");
  printmF4(    &mA_b3);
  printf("\n         Gauss Jordan elimination of matrix A|b3 :\n");
  gaussjordanF(&mA_b3);
  printmF4(    &mA_b3);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n                                                  ");
  printf("\n            GaussJordan : A|b1|b2|b3              ");
  printf("\n            ************************            \n");
  printf("\n The size of mA : 2x2 ... 4x4.                  \n");
  printf("\n           ex : \"gausx3f.exe\"                 \n");
  printf("\n You can choose the size :                      \n");
  printf("\n           ex : \"gausx3f.exe 2\" -> mA 2x2       ");
  printf("\n                \"gausx3f.exe 3\" -> mA 3x3       ");
  printf("\n                \"gausx3f.exe 4\" -> mA 4x4       ");
  printf("\n                                                  ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");

  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;
int    i;

  srand(time(&t));

  hello();

do
{
  if(argc ==2 && atoi(argv[1]))
    {
    n = atoi(argv[1]);
    if( n< 2){n=2;}
    if( n> 4){n=4;}
    }
  else
    {
    n = (int) fabs(randF(5));
    if(n<2){n=2;}
    }

  invb(n);
  printf("\n Press 'X' Return to stop\n");

} while(toupper(getchar())!='X');

  return 0;
}

