/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* --------------------------------- FUNCTION ------------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
A_BplsC(int n,int p)
{
int      i;
int      j;
fraction a;

double pbB    [MXR][MXC*TWOCOL];matrix mB     ={MXR,MXC*TWOCOL,&pbB    [0][0]};
double pbC    [MXR][MXC*TWOCOL];matrix mC     ={MXR,MXC*TWOCOL,&pbC    [0][0]};
double pbaB   [MXR][MXC*TWOCOL];matrix maB    ={MXR,MXC*TWOCOL,&pbaB   [0][0]};
double pbaC   [MXR][MXC*TWOCOL];matrix maC    ={MXR,MXC*TWOCOL,&pbaC   [0][0]};
double pbBplsC[MXR][MXC*TWOCOL];matrix mBplsC ={MXR,MXC*TWOCOL,&pbBplsC[0][0]};

double pa_BplsC              [MXR][MXC*TWOCOL];
matrix ma_BplsC             ={MXR, MXC*TWOCOL,&pa_BplsC            [0][0]};
double paBplsaC              [MXR][MXC*TWOCOL];
matrix maBplsaC =            {MXR, MXC*TWOCOL,&paBplsaC            [0][0]};
double pa_BplsC_mns_aBplsaC  [MXR][MXC*TWOCOL];
matrix ma_BplsC_mns_aBplsaC ={MXR, MXC*TWOCOL,&pa_BplsC_mns_aBplsaC[0][0]};


                     mB.rows=n;                   mB.cols=p*TWOCOL;
                     mC.rows=n;                   mC.cols=p*TWOCOL;
                    maB.rows=n;                  maB.cols=p*TWOCOL;
                    maC.rows=n;                  maC.cols=p*TWOCOL;
                 mBplsC.rows=n;               mBplsC.cols=p*TWOCOL;
               ma_BplsC.rows=n;             ma_BplsC.cols=p*TWOCOL;
               maBplsaC.rows=n;             maBplsaC.cols=p*TWOCOL;

               ma_BplsC_mns_aBplsaC.rows=n;
               ma_BplsC_mns_aBplsaC.cols=p*TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
  a = rndF(9,5);

  rndmF(&mB,10,9);
  rndmF(&mC,10,9);

  clrscrn();
  printf("                                                      ");
  printf("a = %.0f/%.0f\n\n",
          a.numer,
          a.denom);
  printf("                                                      B  :");
  printmF4(&mB);
  printf("                                                      C  :");
  printmF4(&mC);
  getchar();

  clrscrn();
  printf("                                                      B  :");
  printmF4(&mB);
  printf("                                                      C  :");
  printmF4(&mC);
  printf("\n                                                   (B+C) :");
   addmF(&mB,&mC,&mBplsC);
  printmF4(      &mBplsC);
  getchar();

  clrscrn();
  printf("                                                      ");
  printf("a = %.0f/%.0f\n\n",
          a.numer,
          a.denom);
  printf("                                                   (B+C) :");
  printmF4(      &mBplsC);
  printf("\n                                                  a(B+C) :\n");
  smultmF(a,  &mBplsC,&ma_BplsC);
  printmF4(           &ma_BplsC);
  getchar();

  clrscrn();
  printf("                                                      ");
  printf("a = %.0f/%.0f\n\n",
          a.numer,
          a.denom);
  printf("                                                       B :");
  printmF4( &mB);
  printf("                                                      aB :\n");
  smultmF(a,&mB,&maB);
  printmF4(     &maB);
  getchar();

  clrscrn();
  printf("                                                      ");
  printf("a = %.0f/%.0f\n\n",
          a.numer,
          a.denom);
  printf("                                                       C :");
  printmF4( &mC);
  printf("                                                      aC :\n");
  smultmF(a,&mC,&maC);
  printmF4(     &maC);
  getchar();

  clrscrn();
  printf("                                                     aB  :");
  printmF4(&maB);
  printf("                                                     aC  :");
  printmF4(&maC);
  printf("\n                                                 (aB+aC) :");
  addmF(&maB,&maC,&maBplsaC);
  printmF4(        &maBplsaC);
  getchar();

  clrscrn();
  printf("                                                  a(B+C) :");
  printmF4(&ma_BplsC);
  printf("\n                                                 (aB+aC) :");
  printmF4(&maBplsaC);
  printf("\n                                        a(B+C) - (aB+aC) :");
  submF(&ma_BplsC,&maBplsaC,&ma_BplsC_mns_aBplsaC);
  printmF4(&ma_BplsC_mns_aBplsaC);
}


void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n                                                  ");
  printf("\n            a(B+C) = aB+aC                        ");
  printf("\n            **************                      \n");
  printf("\n The size of mB, mC      : 1x1 ... 5x5.         \n");
  printf("\n     ex : \"phf.exe\"                           \n");
  printf("\n You can choose the size :                      \n");
  printf("\n     ex : \"phf.exe 2 3\" -> 2x3                  ");
  printf("\n          \"phf.exe 1 5\" -> 1x5                  ");
  printf("\n          \"phf.exe 4 2\" -> 4x2                  ");
  printf("\n          \"phf.exe 5 5\" -> 5x5                  ");
  printf("\n\n                                                ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press a key to continue                          ");
  printf("\n                                                  ");
  getchar();
}


/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;
int    p;

/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 4 && atoi(argv[1])&& atoi(argv[2]) && atoi(argv[3]) )
 {n = atoi(argv[1]); if( n > 5){n=5;}
  p = atoi(argv[2]); if( p > 5){p=5;}   }
else
 {    n=rndpI(5);       p=rndpI(5); }
   if(n<1){n=1;}     if(p<1){p=1;}


  A_BplsC(n,p);


printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}












