/* myelemerowop.h               freeware                   xhunga@tiscali.fr  */



/* ------------------------------ FUNCTION ------------------------- addrow() */
/* returns a copy of the matrix m in which row r2 is replaced  by (s*r1 + r2) */
/* -------------------------------------------------------------------------- */
void addrowF(
pmatrix m,
int     row1,
int     row2,
double  numer,
double  denom)
{
  int j;
  double t;

 for ( j = 0 ; j < m->cols ; j++,j++ )
    {
/* ---------------------------------------------------------------- numerator */
      *(m->pblock + row2 *m->cols + j) =\
                       (
                       numer * *(m->pblock + row1 *m->cols + j    )\
                               * \
                               *(m->pblock + row2 *m->cols + j + 1)\
                        )
                        + \
                        (
                             *(m->pblock + row2 *m->cols + j    )\
                             * \
                       denom * *(m->pblock + row1 *m->cols + j + 1 )
                         );
/* -------------------------------------------------------------- denominator */
      *(m->pblock + row2 *m->cols + j + 1) = \
                denom * *(m->pblock + row1 *m->cols + j + 1) * \
                        *(m->pblock + row2 *m->cols + j + 1);
/* -------------- denominator = 1 if numerator = 0. This is my choise 0 = 0/1 */
                t = *(m->pblock + row2 *m->cols + j);
            if(!t){ *(m->pblock + row2 *m->cols + j + 1) = 1; }
    }
}


/* ------------------------------ FUNCTION ------------------------- addrow() */
/* returns a copy of the matrix m in which row r2 is replaced  by (s*r1 + r2) */
/* -------------------------------------------------------------------------- */
void addrowautoF(
pmatrix m,
int     row1,
int     row2)
{
  int j;
  double t;
  double numer = -(*(m->pblock + row2 *m->cols + row1 ));
  double denom = *(m->pblock + row2 *m->cols + row1 + 1);

 for ( j = 0 ; j < m->cols ; j++,j++ )
    {
/* ---------------------------------------------------------------- numerator */
      *(m->pblock + row2 *m->cols + j) =\
                       (
                       numer * *(m->pblock + row1 *m->cols + j    )\
                               * \
                               *(m->pblock + row2 *m->cols + j + 1)\
                        )
                        + \
                        (
                             *(m->pblock + row2 *m->cols + j    )\
                             * \
                       denom * *(m->pblock + row1 *m->cols + j + 1 )
                         );
/* -------------------------------------------------------------- denominator */
      *(m->pblock + row2 *m->cols + j + 1) = \
                denom * *(m->pblock + row1 *m->cols + j + 1) * \
                        *(m->pblock + row2 *m->cols + j + 1);
/* -------------- denominator = 1 if numerator = 0. This is my choise 0 = 0/1 */
                t = *(m->pblock + row2 *m->cols + j);
            if(!t){ *(m->pblock + row2 *m->cols + j + 1) = 1; }
    }
}

