/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* --------------------------------- MAIN ----------------------------------- */
int main(void)
{
fraction InnerProduct;

double pbu[1][2*TWOCOL];matrix mu={1,2*TWOCOL,&pbu[0][0]};
double pbv[1][2*TWOCOL];matrix mv={1,2*TWOCOL,&pbv[0][0]};
/*-------------------------------- PROGRAM ---------------------------------- */
do
{
  clrscrn();

  rndmF(&mu,9,1);
  rndmF(&mv,9,1);

  InnerProduct = innerprod_uDotv_uvT(&mu,&mv);
  printf(" Inner Product =  %6.0f/%-6.0f\n\n",
            InnerProduct.numer,
            InnerProduct.denom);


  InnerProduct = innerprod(&mu,&mv);
  printf(" Inner Product =  %6.0f/%-6.0f ",
            InnerProduct.numer,
            InnerProduct.denom);

  printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

 return 0;
}












