/* mcofactor2.c                      freeware                  xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include <stdio.h>
#include <math.h>
#include "mydefine.h"
#include "mydata.h"
#include "myprint.h"     /* printm printrow printcol                          */
#include "mycopy.h"      /*  copym  copyrow  copycol                          */
#include "myspecm.h"     /* identity, zero matrix                             */
#include "myfmint.h"     /* rownmini divide a row by a integer if possible    */
#include "myelemrowop.h" /* Elementary row operations. swaprow multrow addrow */
#include "myfmop.h"      /* add, multiply two matrices. transpose             */
#include "myfpivot.h"    /* pivotntzero pivotwork                             */
#include "myfdet.h"      /* det, minor, cofactor, mcofactor, adjoint          */
#include "mygauss.h"     /* gauss gaussjordan                                 */

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
 main()
{
     int row;
     int col;
fraction f;

double pblockA[4][4*TWOCOL]=
{
1,9, 3,2, 3,9, 4,4,
9,1, 8,4, 3,6, 1,2,
2,3, 8,5, 4,4, 6,9,
3,1, 4,8, 1,2, 9,8
};
matrix mA={4,4*TWOCOL,&pblockA[0][0]};

double pblockT[3][3*TWOCOL];
matrix mT = {  3, 3*TWOCOL,&pblockT[0][0]};

double pblockCofactor[4][4*TWOCOL];
matrix mCofactor = {  4, 4*TWOCOL,&pblockCofactor[0][0]};

/*-------------------------------- PROGRAM ---------------------------------- */
 printf("\n\nMatrix A\n");
 printmF(&mA);

 mcofactorF(&mA, &mT, &mCofactor);
 printmF(&mCofactor);

 printf("\n Press a key to continue");
 getchar();
}

