

/***************************************
	definitions
***************************************/

#define QCENTDAYS	(365l * 400l + 100l - 3l)
					/* = 146097 = days in 4 centuries       */
#define CENTDAYS	(365l * 100l + 24l)
					/* = 36524 = days in 1 non-leap century */
#define QUADDAYS	(365l * 4l + 1l)
					/* = 1461 = days in leap quad           */
#define YEARDAYS	365l
					/* = days in 1 non-leap year	        */
#define AVYRDAYS	(QCENTDAYS / 400.0)
					/* = 365.2425							*/
#define MAXYY		50
					/* used to interpret 2 digit years	*/

#define BADDATE		-1
#define BADYEAR		-2
#define BADMONTH	-3
#define BADDAY		-4
#define AUTODATE	0

#define	FALSE	0
#define	TRUE	!FALSE


/****************************************

	function prototypes and typedef

****************************************/


typedef struct gregorian
{
	int month, day, year;
} GDATE;


/* Gregorian to Julian */
long   gregtojday(GDATE);		/* gregdate to julian day		*/
double gregtojear(GDATE);		/* gregdate to pseudoyear		*/
int	   gregtoyday(GDATE);		/* gregdate to julian year day	*/

/* Julian to Gregorian */
GDATE  jdaytogreg(long);		/* julian day to gregdate		*/
GDATE  jdaytoyday(long);		/* julian day to year			*/
GDATE  ydaytogreg(int day,
		 int year);				/* yearday and year to grgedate */
GDATE  jeartogreg(double jear);	/* pseudoyear to gregdate		*/

/* input/output */
GDATE  mmddyyyytogreg(char *str, int nearyear);
								/* string to gregdate			*/
char   *gregtommddyyyy(char *str, GDATE gdate, int nearyear);
								/* gredgate to string			*/
int    yytoyear(char *str, int nearyear);
								/* translate 2 digit ascii year to int  */

/* miscellaneous */
int	   isleap(int year);        /* leap year or not				*/
int	   dayofweek(long);			/* jday to day of week: 1 to 7	*/
