/* Copyright 1995-96 Jon Griffiths.  See the file "jlib.doc" for details. */

#include <stdio.h>
#include <stdlib.h>
#include <jlib.h>

/* Demonstrates screen_blit_buff_to() */

int main(void)
{
 buffer_rec *offscreen;
 int xpos,ypos,buttons;
 int xpos2=0,ypos2=0;

 JLIB_DEBUG_OFF
 screen_set_video_mode();
 
 if(!MOUSE_AVAILABLE){
    jlib_exit("No Mouse Support.");
 }

 mouse_present(); 
 mouse_hide_pointer();

 /* set 3 shades of gray */
 screen_put_pal(15,255,255,255);
 screen_put_pal(16,128,128,128);
 screen_put_pal(17,0,0,0);
 
 /* Create and draw the buffer to move */
 offscreen=buff_init(SCREEN_WIDTH/2,SCREEN_HEIGHT/4);

 buff_fill(offscreen,16);

 buff_draw_box(offscreen,0,0,B_MAX_X(offscreen),B_MAX_Y(offscreen),15);
 buff_draw_h_line(offscreen,0,B_MAX_Y(offscreen),B_MAX_X(offscreen),17);
 buff_draw_v_line(offscreen,B_MAX_X(offscreen),0,B_MAX_Y(offscreen),17);
 buff_draw_h_line(offscreen,1,B_Y_SIZE(offscreen)/3,B_MAX_X(offscreen)-1,17);
 buff_draw_h_line(offscreen,1,(B_Y_SIZE(offscreen)/3)+1,B_MAX_X(offscreen)-1,15);
 buff_draw_stringNC(offscreen,"This is a Small Buffer On Screen",3,3,17);
 buff_draw_stringNC(offscreen,"This is a Small Buffer On Screen",2,2,15);
 buff_filled_circleNC(offscreen,B_MAX_X(offscreen)-(B_MAX_X(offscreen)/20),(B_Y_SIZE(offscreen)/6),(B_Y_SIZE(offscreen)/13),15);

 /* move it around screen with the mouse */
 do{
    mouse_get_status(&xpos,&ypos,&buttons);

    if((xpos!=xpos2) || (ypos!=ypos2)){
       screen_fill(55);
       screen_blit_buff_to(xpos,ypos,offscreen,0,0,B_MAX_X(offscreen),B_MAX_Y(offscreen));
       xpos2=xpos;
       ypos2=ypos;
    }
 }while(!BUTTON_DOWN(buttons));

 mouse_closedown();
 
 /* return to text mode and exit */
 screen_restore_video_mode();
 return(0);
}
