/* Copyright 1995-96 Jon Griffiths.  See the file "jlib.doc" for details. */

#include <stdio.h>
#include <stdlib.h>
#include <jlib.h>

#define ONE_SECOND 1*UCLOCK_TICKS_PER_SECOND

/* This demo shows how to load and display image files,  how to fade the
** screen in and out and how to use an offscreen buffer.
*/

/* fade in and then out from 2 palettes */
#define PAL_OPS \
 screen_fade_to_pal(pal1,pal2,ONE_SECOND); \
 fgetc(stdin); \
 screen_fade_to_pal(pal2,pal1,ONE_SECOND); \
 fgetc(stdin); \
 pal_copy(pal1,pal2);


int main(void)
{
 image *pcx_pic;
 buffer_rec *buff;
 UBYTE *pal1,*pal2;
 image *jlb_pic;

 JLIB_DEBUG_OFF;
 
 /* initialise screen sized buffer */
 buff = buff_init(SCREEN_WIDTH,SCREEN_HEIGHT);

 /* load pcx */
 pcx_pic=image_load_pcx("demo1.pcx");

 /* check that load was OK */
 if(pcx_pic == NULL){
    jlib_exit("PCX load failed.");
 }

 /* set pal to point to the images palette */
 pal1 = IMG_PALETTE(pcx_pic);
 
 /* set up the screen */
 if(!screen_set_video_mode()){
    jlib_exit("Screen Setup failed.");
 }

 screen_blank_pal();

 /* copy the image->buffer->screen */
 buff_blit_img_to(buff,0,0,pcx_pic,0,0,IMG_MAX_X(pcx_pic),IMG_MAX_Y(pcx_pic));
 screen_blit_fs_buffer(buff);

 /* fade in the palette and wait for a keypress */
 screen_fade_in_pal(pal1,ONE_SECOND*10); /* take 10 seconds to fade in */
 fgetc(stdin);

  
 /* fade out the palette and wait for a keypress */
 screen_fade_out_pal(pal1,ONE_SECOND);
 fgetc(stdin);

 screen_blank_pal();
 image_free(pcx_pic);

 /* load jlb */
 jlb_pic = image_load_jlb("demo1.jlb");

 /* check that load was OK */
 if(jlb_pic == NULL){
    jlib_exit("JLB load failed.");
 }

 /* set pal to point to the images palette */
 pal1 = IMG_PALETTE(jlb_pic);

 /* copy the image->buffer->screen */
 buff_blit_img_to(buff,0,0,jlb_pic,0,0,IMG_MAX_X(jlb_pic),IMG_MAX_Y(jlb_pic));
 screen_blit_fs_buffer(buff);


 /* fade the palette to different colours and back */
 screen_fade_in_pal(pal1,ONE_SECOND*4);
 fgetc(stdin);

 /* get a copy of the palette */
 pal2=pal_init();
 pal_copy(pal1,pal2);

 pal_to_grey(pal2);
 PAL_OPS;
 pal_to_red(pal2);
 PAL_OPS;
 pal_to_green(pal2);
 PAL_OPS;
 pal_to_blue(pal2);
 PAL_OPS;

 fgetc(stdin);

 screen_restore_video_mode();
 return(0);
}
