; memcmp_dss
;   AAA=str
;   BBB=018
;   F=0
;   O=2
; str01802.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_memcmp_dss:FN_CALL PTR
p_fn_memcmp_dss P_FN_CALL memcmp_dss
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF

;memcmp_dss() -- Compare memory blocks
;int fn_call memcmp_dss(const void __near * const, const void __near * const, const int);
;GIVEN:
;   p_m1	near pointer, (dest) offset from ss
;   p_m2	near pointer, (source) offset from ds
;   cnt 	number of characters to compare
;RETURNS: (int)
;   <0		m1 < m2
;   0		m1 = m2
;   >0		m1 > m2
BEGIN_CODE_SEGMENT <STRING>
memcmp_dss PROC FN_CALL C uses es si di,
		p_m1:NEAR16 PTR, p_m2:NEAR16 PTR, cnt:WORD

	    mov cx, ss
	    mov es, cx
	    mov bx, ds

	    mov di, [p_m1]	    ;es:di = p_m1, dest
	    mov si, [p_m2]	    ;ds:si = p_m2, src

	    xor ax, ax
	    cmp cx, bx
	    jne @@cont
	    cmp si,di		    ;Equal?
	    jne @@cont
	    jmp @@done		    ; Yes
@@cont:
	    mov cx, [cnt]	   ;CX = count
	    jcxz @@done
	    repe cmps BYTE PTR ds:[si], es:[di]	    ;Compare memory
	    ; if ZF, then success
	    je @@done
	    ja @@above
	    ; below (p_m2<p_m1, or p_m1<p_m2)
	    inc ax
	    jmp @@done
@@above:
	    ; above (p_m2>p_m1, or p_m1<p_m2)
	    dec ax
@@done:
	    ret
memcmp_dss ENDP
END_CODE_SEGMENT <STRING>
END
