; @strncpy_dss
;   AAA=str
;   BBB=014
;   F=1
;   O=2
; str01412.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_fc_strncpy_dss:FN_CALL PTR
p_fn_fc_strncpy_dss P_FN_CALL @strncpy_dss
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF

;strncpy_dss() -- Copy n characters of a string to another
;char __near * __fastcall fn_call strncpy_dss(char __near * const, const char __near * const, const size_t);
; __fastcall
; GIVEN:
;    BX    p_str1, (dest) offset from ss
;    AX    p_str2, (source) offset from ds
;    DX    num
;RETURNS:
;   AX	   near pointer, offset from ss (p_str1)
;NOTES:
;   str1 should be at least n+1 bytes
;   str1 is always null terminated
BEGIN_CODE_SEGMENT <STRING>
@strncpy_dss PROC FN_CALL USES es si di cx dx
	    mov di, bx		;es:di = p_str1
	    mov si, ax		;ds:si = p_str2
	    mov cx, dx		;cx = max length

	    mov ax, ss
	    mov es, ax


	    mov dx, ds
	    cmp ax, dx
	    jne @@cont
	    cmp si, di
	    jne @@cont
	    mov ax, di
	    jmp @@exit
@@cont:

@@loop:
	    jcxz @@addnull
	    dec cx
	    lods BYTE PTR ds:[si]   ;Load char
	    stos BYTE PTR es:[di]   ;Store char
	    test al,al		    ;Loop while not zero
	    jz @@done
	    jmp	@@loop
@@addnull:
	    ; not part of specs
	    ; add terminating null
	    mov BYTE PTR es:[di], 0
@@done:
	    mov ax, bx
@@exit:
	    ret
@strncpy_dss ENDP
END_CODE_SEGMENT <STRING>
END
