; strlwr
;   AAA=str
;   BBB=012
;   F=0
;   O=0
; str01200.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_strlwr:FN_CALL PTR
p_fn_strlwr P_FN_CALL strlwr
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF


;strlwr() -- Convert string to lowercase
;char __near * fn_call strlwr(char __near * const);
; GIVEN;
;   p_str	near pointer, (source) offset from ds
; RETURNS: (char __near *)
;   pointer	near pointer, offset from ds (p_str)
BEGIN_CODE_SEGMENT <STRING>
strlwr PROC FN_CALL C uses es di si, p_str:NEAR16 PTR BYTE

	    mov ax, ds
	    mov es, ax

	    mov si, [p_str]	    ;ds:si = p_str
	    mov di, si		    ;es:di = p_str

@@loop:	    lodsb BYTE PTR ds:[si]  ;load al with char
	    cmp al,'A'		    ;Check for uppercase
	    jb @F
            cmp al,'Z'
	    ja @F
	    add al,20h		    ;Convert to lowercase
@@:
	    stos BYTE PTR es:[di]
	    test al,al		    ;Check for null
	    jnz @@loop

	    mov ax, [p_str]
	    ret
strlwr ENDP
END_CODE_SEGMENT <STRING>
END
