; strcat_dss
;   AAA=str
;   BBB=004
;   F=0
;   O=2
; str00402.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_strcat_dss:FN_CALL PTR
p_fn_strcat_dss P_FN_CALL strcat_dss
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF

;strcat_dss() -- Concatenate strings
; appends string2 to end of string1
; GIVEN:
;   p_str1	near pointer, (destination) offset from ss
;   p_str2	near pointer, (source) offset from ds
; RETURNS: (char __near *)
;   pointer	near pointer, offset from ss (p_str1)
; NOTES:
;   if p_str1 == p_str2, then just returns p_str1
;char __near * fn_call strcat_dss(char __near * const, const char __near * const);
BEGIN_CODE_SEGMENT <STRING>
strcat_dss PROC FN_CALL C uses es si di, p_str1:NEAR16 PTR BYTE, p_str2:NEAR16 PTR BYTE

	    mov ax, ss
	    mov es, ax
	    mov bx, ds

	    mov si, [p_str2]	    ; ds:si = source
	    mov di, [p_str1]	    ;es:di = destination

	    cmp ax, bx
	    jne @@cont
	    cmp si, di	    ; equal strings?
	    jne @@cont

	    mov ax, di
	    jmp @@exit


@@cont:
	    mov bx, di		    ; save destination pointer
	    ; find end of p_str1
	    xor ax, ax		    ; compare with zero
	    mov cx, ax
	    dec cx		    ; cx = -1

	    repne scas BYTE PTR es:[di]	;check for zero
	    dec di		    ; [es]:di = null of p_str1


@@loop:     lods BYTE PTR ds:[si]   ;Load char
	    stos BYTE PTR es:[di]   ;Store char
	    test al,al		    ;Loop while not zero
	    jnz @@loop

	    mov ax, bx
@@exit:
	    ret
strcat_dss ENDP
END_CODE_SEGMENT <STRING>
END
