; @strcpy_sss
;   AAA=str
;   BBB=000
;   F=1
;   O=1
; str00011.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_fc_strcpy_sss:FN_CALL PTR
p_fn_fc_strcpy_sss P_FN_CALL @strcpy_sss
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF

;strcpy() -- Copies string 2 to string 1, including null term char
;char __near * __fastcall fn_call strcpy_sss(char const __near *, const char __near * const);
; __fastcall
; GIVEN:
;   BX		p_str1
;   AX		p_str2
; RETURNS:
;   AX		p_str1
BEGIN_CODE_SEGMENT <STRING>
@strcpy_sss PROC FN_CALL USES bx si di es ds
	    mov di, bx	    ;es:DI = p_str1 = destination
	    mov si, ax	    ;ds:SI = p_str2 = source

	    mov ax, ds
	    mov es, ax

	    mov bx, ss
	    mov ds, bx

	    cmp ax, bx	    ; check to see if ds==es
	    jne @@cont
	    cmp si,di
	    jne @@cont
	    mov ax, di
	    jmp @@exit	    ; they are equal, so done
@@cont:
	    mov bx, di		    ; save destination offset

@@loop:	    lods BYTE PTR ds:[si]   ;Load char
	    stos BYTE PTR es:[di]   ;Store char
	    test al,al		    ;Loop while not zero
	    jnz @@loop
@@done:
	    mov ax, bx
@@exit:
	    ret 		    ;Return AX points to copied string
@strcpy_sss ENDP
END_CODE_SEGMENT <STRING>
END
