; isxdigit
;   AAA=mis
;   BBB=010
;   F=0
;   O=0
; str01000.asm

.xlist
CLIBC_16_MODULE EQU MISC
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_isxdigit:FN_CALL PTR
p_fn_isxdigit P_FN_CALL isxdigit
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF

;isxdigit() - Hexadecimal digit ('A'-'F', 'a'-'f', '0'-'9')
;int fn_call isxdigit(const int);
;RETURNS:
;   0	    if NOT a hex digit
;   1	    if	   a hex digit
BEGIN_CODE_SEGMENT <MISC>
isxdigit PROC FN_CALL C, num:WORD
    xor ax, ax
    mov bx, num

    cmp bl, '0' ; digit?
    jb @@done
    cmp bl, '9'
    jbe @@yes

    cmp bl, 'A' ; Hex letter?
    jb @@done
    cmp bl, 'F'
    jbe @@yes

    cmp bl, 'a' ; Hex letter?
    jb @@done
    cmp bl, 'f'
    ja @@done
@@yes:
    inc ax
@@done:
    ret
isxdigit ENDP
END_CODE_SEGMENT <MISC>
END
