/* string.h, clibc_16.lib */

#ifndef _SIZE_T_DEFINED
typedef unsigned int size_t;
#define _SIZE_T_DEFINED
#endif

#ifndef DEBUG_YES
# define DEBUG_YES 1
#endif

#ifndef DEBUG_NO
# define DEBUG_NO 0
#endif

#ifndef CLIBC_16_FARCALL
# define CLIBC_16_FARCALL 1
#endif

#ifndef CLIBC_16_NEARCALL
# define CLIBC_16_NEARCALL 0
#endif

#ifndef CLIBC_16_FC_EXT_PTRS_YES
# define  CLIBC_16_FC_EXT_PTRS_YES 1
#endif

#ifndef CLIBC_16_FC_EXT_PTRS_NO
# define CLIBC_16_FC_EXT_PTRS_NO 0
#endif

/* defaults */
#ifndef CLC16_C
# define CLC16_C CLIBC_16_NEARCALL
#endif

#ifndef CLIBC_16_FC_EXT_PTRS
# define CLIBC_16_FC_EXT_PTRS CLIBC_16_FC_PTRS_NO
#endif

/* more */
#if CLC16_C == CLIBC_16_NEARCALL
# ifndef fn_call
#  define fn_call __near __based(__segname("_TEXT"))
# endif
# ifndef CLIBC_16_CS
#  define CLIBC_16_CS code_seg("_TEXT","CODE")
# endif
# ifndef fn_call_dist
#  define fn_call_dist __near
# endif
# ifndef CLIBC_16_CS_NAME
#  define CLIBC_16_CS_NAME "_TEXT"
# endif
#else
# ifndef fn_call
#  define fn_call __far __based(__segname("CLIBC_16"))
# endif
# ifndef CLIBC_16_CS
#  define CLIBC_16_CS code_seg("CLIBC_16","CODE")
# endif
# ifndef fn_call_dist
#  define fn_call_dist __far
# endif
# ifndef CLIBC_16_CS_NAME
#  define CLIBC_16_CS_NAME "CLIBC_16"
# endif
#endif

#ifdef FASTCALL_STRING_ALL
# define FASTCALL_STRCPY
# define FASTCALL_STRCPY_SSS
# define FASTCALL_STRCPY_DSS
# define FASTCALL_STRLEN
# define FASTCALL_STRLEN_SSS
# define FASTCALL_SKIPSP
# define FASTCALL_SKIPSP_SSS
# define FASTCALL_SKIPTOSP
# define FASTCALL_SKIPTOSP_SSS
# define FASTCALL_STRCAT
# define FASTCALL_STRCAT_SSS
# define FASTCALL_STRCAT_DSS
# define FASTCALL_STRCMP
# define FASTCALL_STRCMP_SSS
# define FASTCALL_STRCMP_DSS
# define FASTCALL_STRCHR
# define FASTCALL_STRCHR_SSS
# define FASTCALL_STRSTR
# define FASTCALL_STRSTR_SSS
# define FASTCALL_STRSTR_DSS
# define FASTCALL_STRRCHR
# define FASTCALL_STRRCHR_SSS
# define FASTCALL_STRICMP
# define FASTCALL_SKIPSPR
# define FASTCALL_SKIPSPR_SSS
# define FASTCALL_SKIPTOSR
# define FASTCALL_SKIPTOSR_SSS
# define FASTCALL_STRLWR
# define FASTCALL_STRLWR_SSS
# define FASTCALL_STRUPR
# define FASTCALL_STRUPR_SSS
# define FASTCALL_STRNCPY
# define FASTCALL_STRNCPY_SSS
# define FASTCALL_STRNCPY_DSS
# define FASTCALL_STRNCAT
# define FASTCALL_STRNCAT_SSS
# define FASTCALL_STRNCAT_DSS
# define FASTCALL_MEMMOVE
# define FASTCALL_MEMMOVE_SSS
# define FASTCALL_MEMMOVE_DSS
# define FASTCALL_MEMSET
# define FASTCALL_MEMSET_SSS
# define FASTCALL_MEMCMP
# define FASTCALL_MEMCMP_SSS
# define FASTCALL_MEMCMP_DSS
#endif

/* strcpy */
#ifdef FASTCALL_STRCPY
char __near * __fastcall fn_call strcpy(char __near * const, const char __near * const);
#else
char __near * fn_call strcpy(char __near * const, const char __near * const);
#endif

#ifndef DEFINED_P_FN_STRCPY
# define DEFINED_P_FN_STRCPY
  typedef char __near *	(fn_call_dist * P_FN_STRCPY)(char __near * const, const char __near * const);
#endif

#ifndef DEFINED_P_FN_FC_STRCPY
# define DEFINED_P_FN_FC_STRCPY
  typedef char __near *	(fn_call_dist __fastcall * P_FN_FC_STRCPY)(char __near * const, const char __near * const);
#endif

#if CLIBC_16_FC_EXT_PTRS==CLIBC_16_FC_EXT_PTRS_YES
# ifndef DEFINED_EXTERN_P_FN_FC_STRCPY
#  define DEFINED_EXTERN_P_FN_FC_STRCPY
   extern P_FN_FC_STRCPY const p_fn_fc_strcpy[3];
# endif
#endif

#ifdef FASTCALL_STRCPY_SSS
char __near * __fastcall fn_call strcpy_sss(char __near * const, const char __near * const);
#else
char __near * fn_call strcpy_sss(char __near * const, const char __near * const);
#endif

#ifdef FASTCALL_STRCPY_DSS
char __near * __fastcall fn_call strcpy_dss(char __near * const, const char __near * const);
#else
char __near * fn_call strcpy_dss(char __near * const, const char __near * const);
#endif

/* strlen */
#ifdef FASTCALL_STRLEN
size_t __fastcall fn_call strlen(const char __near * const);
#else
size_t fn_call strlen(const char __near * const);
#endif

#ifndef DEFINED_P_FN_STRLEN
# define DEFINED_P_FN_STRLEN
  typedef size_t (fn_call_dist * P_FN_STRLEN)(const char __near * const);
#endif

#ifndef DEFINED_P_FN_FC_STRLEN
# define DEFINED_P_FN_FC_STRLEN
  typedef size_t (fn_call_dist __fastcall * P_FN_FC_STRLEN)(const char __near * const);
#endif

#if CLIBC_16_FC_EXT_PTRS==CLIBC_16_FC_EXT_PTRS_YES
# ifndef DEFINED_EXTERN_P_FN_FC_STRLEN
#  define DEFINED_EXTERN_P_FN_FC_STRLEN
   extern P_FN_FC_STRLEN const p_fn_fc_strlen[2];
# endif
#endif

#ifdef FASTCALL_STRLEN_SSS
size_t __fastcall fn_call strlen_sss(const char __near * const);
#else
size_t fn_call strlen_ssss(const char __near * const);
#endif

/* skipsp */
#ifdef FASTCALL_SKIPSP
char __near * __fastcall fn_call skipsp(const char __near * const);
#else
char __near * fn_call skipsp(const char __near * const);
#endif

#ifndef DEFINED_P_FN_SKIPSP
# define DEFINED_P_FN_SKIPSP
  typedef char __near *	(fn_call_dist * P_FN_SKIPSP)(const char __near * const);
#endif

#ifndef DEFINED_P_FN_FC_SKIPSP
# define DEFINED_P_FN_FC_SKIPSP
  typedef char __near * (fn_call_dist __fastcall * P_FN_FC_SKIPSP)(const char __near * const);
#endif

#if CLIBC_16_FC_EXT_PTRS==CLIBC_16_FC_EXT_PTRS_YES
# ifndef DEFINED_EXTERN_P_FN_FC_SKIPSP
#  define DEFINED_EXTERN_P_FN_FC_SKIPSP
   extern P_FN_FC_SKIPSP const p_fn_fc_skipsp[2];
# endif
#endif

#ifdef FASTCALL_SKIPSP_SSS
char __near * __fastcall fn_call skipsp_sss(const char __near * const);
#else
char __near * fn_call skipsp_sss(const char __near * const);
#endif

/* skiptosp */
#ifdef FASTCALL_SKIPTOSP
char __near * __fastcall fn_call skiptosp(const char __near * const);
#else
char __near * fn_call skiptosp(const char __near * const);
#endif

#ifndef DEFINED_P_FN_SKIPTOSP
# define DEFINED_P_FN_SKIPTOSP
  typedef char __near * (fn_call_dist * P_FN_SKIPTOSP)(const char __near * const);
#endif

#ifndef DEFINED_P_FN_FC_SKIPTOSP
# define DEFINED_P_FN_FC_SKIPTOSP
  typedef char __near * (fn_call_dist __fastcall * P_FN_FC_SKIPTOSP)(const char __near * const);
#endif

#if CLIBC_16_FC_EXT_PTRS==CLIBC_16_FC_EXT_PTRS_YES
# ifndef DEFINED_EXTERN_P_FN_FC_SKIPTOSP
#  define DEFINED_EXTERN_P_FN_FC_SKIPTOSP
   extern P_FN_FC_SKIPTOSP const p_fn_fc_skiptosp[2];
# endif
#endif

#ifdef FASTCALL_SKIPTOSP_SSS
char __near * __fastcall fn_call skiptosp_sss(const char __near * const);
#else
char __near * fn_call skiptosp_sss(const char __near * const);
#endif

/* strcat */
#ifdef FASTCALL_STRCAT
char __near * __fastcall fn_call strcat(char __near * const, const char __near * const);
#else
char __near * fn_call strcat(char __near * const, const char __near * const);
#endif

#ifndef DEFINED_P_FN_STRCAT
# define DEFINED_P_FN_STRCAT
  typedef char __near * (fn_call_dist * P_FN_STRCAT)(const char __near * const);
#endif

#ifndef DEFINED_P_FN_FC_STRCAT
# define DEFINED_P_FN_FC_STRCAT
  typedef char __near * (fn_call_dist __fastcall * P_FN_FC_STRCAT)(const char __near * const);
#endif

#if CLIBC_16_FC_EXT_PTRS==CLIBC_16_FC_EXT_PTRS_YES
# ifndef DEFINED_EXTERN_P_FN_FC_STRCAT
#  define DEFINED_EXTERN_P_FN_FC_STRCAT
   extern P_FN_FC_STRCAT const p_fn_fc_strcat[3];
# endif
#endif

#ifdef FASTCALL_STRCAT_SSS
char __near * __fastcall fn_call strcat_sss(char __near * const, const char __near * const);
#else
char __near * fn_call strcat_sss(char __near * const, const char __near * const);
#endif

#ifdef FASTCALL_STRCAT_DSS
char __near * __fastcall fn_call strcat_dss(char __near * const, const char __near * const);
#else
char __near * fn_call strcat_dss(char __near * const, const char __near * const);
#endif

/* strcmp */
#ifdef FASTCALL_STRCMP
int __fastcall fn_call strcmp(const char __near * const, char __near * const);
#else
int fn_call strcmp(const char __near * const, char __near * const);
#endif

#ifndef DEFINED_P_FN_STRCMP
# define DEFINED_P_FN_STRCMP
  typedef int (fn_call_dist * P_FN_STRCMP)(const char __near * const, char __near * const);
#endif

#ifndef DEFINED_P_FN_FC_STRCMP
# define DEFINED_P_FN_FC_STRCMP
  typedef int (fn_call_dist __fastcall * P_FN_FC_STRCMP)(const char __near * const, char __near * const);
#endif

#if CLIBC_16_FC_EXT_PTRS==CLIBC_16_FC_EXT_PTRS_YES
# ifndef DEFINED_EXTERN_P_FN_FC_STRCMP
#  define DEFINED_EXTERN_P_FN_FC_STRCMP
   extern P_FN_FC_STRCMP const p_fn_fc_strcmp[3];
# endif
#endif

#ifdef FASTCALL_STRCMP_SSS
int __fastcall fn_call strcmp_sss(const char __near * const, char __near * const);
#else
int fn_call strcmp_sss(const char __near * const, char __near * const);
#endif

#ifdef FASTCALL_STRCMP_DSS
int __fastcall fn_call strcmp_dss(const char __near * const, char __near * const);
#else
int fn_call strcmp_dss(const char __near * const, char __near * const);
#endif

/* strchr */
#ifdef FASTCALL_STRCHR
char __near * __fastcall fn_call strchr(const char __near * const,const int);
#else
char __near *	fn_call strchr(const char __near * const,const int);
#endif

#ifndef DEFINED_P_FN_STRCHR
# define DEFINED_P_FN_STRCHR
  typedef char __near * (fn_call_dist * P_FN_STRCHR)(const char __near * const,const int);
#endif

#ifndef DEFINED_P_FN_FC_STRCHR
# define DEFINED_P_FN_FC_STRCHR
  typedef char __near * (fn_call_dist __fastcall * P_FN_FC_STRCHR)(const char __near * const,const int);
#endif

#if CLIBC_16_FC_EXT_PTRS==CLIBC_16_FC_EXT_PTRS_YES
# ifndef DEFINED_EXTERN_P_FN_FC_STRCHR
#  define DEFINED_EXTERN_P_FN_FC_STRCHR
   extern P_FN_FC_STRCHR const p_fn_fc_strchr[2];
# endif
#endif

#ifdef FASTCALL_STRCHR_SSS
char __near * __fastcall fn_call strchr_sss(const char __near * const,const int);
#else
char __near *	fn_call strchr_sss(const char __near * const,const int);
#endif

/* strstr */
#ifdef FASTCALL_STRSTR
char __near * __fastcall fn_call strstr(const char __near * const, const char __near * const);
#else
char __near *	fn_call strstr(const char __near * const, const char __near * const);
#endif

#ifndef DEFINED_P_FN_STRSTR
# define DEFINED_P_FN_STRSTR
  typedef char __near * (fn_call_dist * P_FN_STRSTR)(const char __near * const, const char __near * const);
#endif

#ifndef DEFINED_P_FN_FC_STRSTR
# define DEFINED_P_FN_FC_STRSTR
  typedef char __near * (fn_call_dist __fastcall * P_FN_FC_STRSTR)(const char __near * const, const char __near * const);
#endif

#if CLIBC_16_FC_EXT_PTRS==CLIBC_16_FC_EXT_PTRS_YES
# ifndef DEFINED_EXTERN_P_FN_FC_STRSTR
#  define DEFINED_EXTERN_P_FN_FC_STRSTR
   extern P_FN_FC_STRSTR const p_fn_fc_strstr[3];
# endif
#endif

#ifdef FASTCALL_STRSTR_SSS
char __near * __fastcall fn_call strstr_sss(const char __near * const, const char __near * const);
#else
char __near *	fn_call strstr_sss(const char __near * const, const char __near * const);
#endif

#ifdef FASTCALL_STRSTR_DSS
char __near * __fastcall fn_call strstr_sss(const char __near * const, const char __near * const);
#else
char __near *	fn_call strstr_sss(const char __near * const, const char __near * const);
#endif

/* strrchr */
#ifdef FASTCALL_STRRCHR
char __near * __fastcall fn_call strrchr(const char __near * const, const int);
#else
char __near * fn_call strrchr(const char __near * const, const int);
#endif

#ifndef DEFINED_P_FN_STRRCHR
# define DEFINED_P_FN_STRRCHR
  typedef char __near * (fn_call_dist * P_FN_STRRCHR)(const char __near * const, const int);
#endif

#ifndef DEFINED_P_FN_FC_STRRCHR
# define DEFINED_P_FN_FC_STRRCHR
  typedef char __near * (fn_call_dist __fastcall * P_FN_FC_STRRCHR)(const char __near * const, const int);
#endif

#if CLIBC_16_FC_EXT_PTRS==CLIBC_16_FC_EXT_PTRS_YES
# ifndef DEFINED_EXTERN_P_FN_FC_STRRCHR
#  define DEFINED_EXTERN_P_FN_FC_STRRCHR
   extern P_FN_FC_STRRCHR const p_fn_fc_strrchr[2];
# endif
#endif

#ifdef FASTCALL_STRRCHR_SSS
char __near * __fastcall fn_call strrchr_sss(const char __near * const, const int);
#else
char __near * fn_call strrchr_sss(const char __near * const, const int);
#endif

/* stricmp */
#ifdef FASTCALL_STRICMP
int __fastcall fn_call stricmp(const char __near * const, const char __near * const);
#else
int fn_call stricmp(const char __near * const, const char __near * const);
#endif

#ifndef DEFINED_P_FN_STRICMP
# define DEFINED_P_FN_STRICMP
  typedef int (fn_call_dist * P_FN_STRICMP)(const char __near * const, const char __near * const);
#endif

#ifndef DEFINED_P_FN_FC_STRICMP
# define DEFINED_P_FN_FC_STRICMP
  typedef int (fn_call_dist __fastcall * P_FN_FC_STRICMP)(const char __near * const, const char __near * const);
#endif

#if CLIBC_16_FC_EXT_PTRS==CLIBC_16_FC_EXT_PTRS_YES
# ifndef DEFINED_EXTERN_P_FN_FC_STRICMP
#  define DEFINED_EXTERN_P_FN_FC_STRICMP
   extern P_FN_FC_STRICMP const p_fn_fc_stricmp[3];
# endif
#endif

#ifdef FASTCALL_STRICMP_SSS
int __fastcall fn_call stricmp_sss(const char __near * const, const char __near * const);
#else
int fn_call stricmp_sss(const char __near * const, const char __near * const);
#endif

#ifdef FASTCALL_STRICMP_DSS
int __fastcall fn_call stricmp_dss(const char __near * const, const char __near * const);
#else
int fn_call stricmp_dss(const char __near * const, const char __near * const);
#endif

/* skipspr */
#ifdef FASTCALL_SKIPSPR
char __near * __fastcall fn_call skipspr(const char __near * const);
#else
char __near * fn_call skipspr(const char __near * const);
#endif

#ifndef DEFINED_P_FN_SKIPSPR
# define DEFINED_P_FN_SKIPSPR
  typedef char __near * (fn_call_dist * P_FN_SKIPSPR)(const char __near * const);
#endif

#ifndef DEFINED_P_FN_FC_SKIPSPR
# define DEFINED_P_FN_FC_SKIPSPR
  typedef char __near * (fn_call_dist __fastcall * P_FN_FC_SKIPSPR)(const char __near * const);
#endif

#if CLIBC_16_FC_EXT_PTRS==CLIBC_16_FC_EXT_PTRS_YES
# ifndef DEFINED_EXTERN_P_FN_FC_SKIPSPR
#  define DEFINED_EXTERN_P_FN_FC_SKIPSPR
   extern P_FN_FC_SKIPSPR const p_fn_fc_skipspr[2];
# endif
#endif

#ifdef FASTCALL_SKIPSPR_SSS
char __near * __fastcall fn_call skipspr_sss(const char __near * const);
#else
char __near * fn_call skipspr_sss(const char __near * const);
#endif

/* skiptosr */
#ifdef FASTCALL_SKIPTOSR
char __near * __fastcall fn_call skiptosr(const char __near * const);
#else
char __near * fn_call skiptosr(const char __near * const);
#endif

#ifndef DEFINED_P_FN_SKIPTOSR
# define DEFINED_P_FN_SKIPTOSR
  typedef char __near * (fn_call_dist * P_FN_SKIPTOSR)(const char __near * const);
#endif

#ifndef DEFINED_P_FN_FC_SKIPTOSR
# define DEFINED_P_FN_FC_SKIPTOSR
  typedef char __near * (fn_call_dist __fastcall * P_FN_FC_SKIPTOSR)(const char __near * const);
#endif

#if CLIBC_16_FC_EXT_PTRS==CLIBC_16_FC_EXT_PTRS_YES
# ifndef DEFINED_EXTERN_P_FN_FC_SKIPTOSR
#  define DEFINED_EXTERN_P_FN_FC_SKIPTOSR
   extern P_FN_FC_SKIPTOSR const p_fn_fc_skiptosr[2];
# endif
#endif

#ifdef FASTCALL_SKIPTOSR_SSS
char __near * __fastcall fn_call skiptosr_sss(const char __near * const);
#else
char __near * fn_call skiptosr_sss(const char __near * const);
#endif

/* strlwr */
#ifdef FASTCALL_STRLWR
char __near * __fastcall fn_call strlwr(char __near * const);
#else
char __near * fn_call strlwr(char __near * const);
#endif

#ifndef DEFINED_P_FN_STRLWR
# define DEFINED_P_FN_STRLWR
  typedef char __near * (fn_call_dist * P_FN_STRLWR)(char __near * const);
#endif

#ifndef DEFINED_P_FN_FC_STRLWR
# define DEFINED_P_FN_FC_STRLWR
  typedef char __near * (fn_call_dist __fastcall * P_FN_FC_STRLWR)(char __near * const);
#endif

#if CLIBC_16_FC_EXT_PTRS==CLIBC_16_FC_EXT_PTRS_YES
# ifndef DEFINED_EXTERN_P_FN_FC_STRLWR
#  define DEFINED_EXTERN_P_FN_FC_STRLWR
   extern P_FN_FC_STRLWR const p_fn_fc_strlwr[2];
# endif
#endif

#ifdef FASTCALL_STRLWR_SSS
char __near * __fastcall fn_call strlwr_sss(char __near * const);
#else
char __near * fn_call strlwr_sss(char __near * const);
#endif

/* strupr */
#ifdef FASTCALL_STRUPR
char __near * __fastcall fn_call strupr(char __near * const);
#else
char __near * fn_call strupr(char __near * const);
#endif

#ifndef DEFINED_P_FN_STRUPR
# define DEFINED_P_FN_STRUPR
  typedef char __near * (fn_call_dist * P_FN_STRUPR)(char __near * const);
#endif

#ifndef DEFINED_P_FN_FC_STRUPR
# define DEFINED_P_FN_FC_STRUPR
  typedef char __near * (fn_call_dist __fastcall * P_FN_FC_STRUPR)(char __near * const);
#endif

#if CLIBC_16_FC_EXT_PTRS==CLIBC_16_FC_EXT_PTRS_YES
# ifndef DEFINED_EXTERN_P_FN_FC_STRUPR
#  define DEFINED_EXTERN_P_FN_FC_STRUPR
   extern P_FN_FC_STRUPR const p_fn_fc_strupr[2];
# endif
#endif

#ifdef FASTCALL_STRUPR_SSS
char __near * __fastcall fn_call strupr_sss(char __near * const);
#else
char __near * fn_call strupr_sss(char __near * const);
#endif

/* strncpy */
#ifdef FASTCALL_STRNCPY
char __near * __fastcall fn_call strncpy(char __near * const, const char __near * const, const size_t);
#else
char __near * fn_call strncpy(char __near * const, const char __near * const, const size_t);
#endif

#ifndef DEFINED_P_FN_STRNCPY
# define DEFINED_P_FN_STRNCPY
  typedef char __near * (fn_call_dist * P_FN_STRNCPY)(char __near * const, const char __near * const, const size_t);
#endif

#ifndef DEFINED_P_FN_FC_STRNCPY
# define DEFINED_P_FN_FC_STRNCPY
  typedef char __near * (fn_call_dist __fastcall * P_FN_FC_STRNCPY)(char __near * const, const char __near * const, const size_t);
#endif

#if CLIBC_16_FC_EXT_PTRS==CLIBC_16_FC_EXT_PTRS_YES
# ifndef DEFINED_EXTERN_P_FN_FC_STRNCPY
#  define DEFINED_EXTERN_P_FN_FC_STRNCPY
   extern P_FN_FC_STRNCPY const p_fn_fc_strncpy[3];
# endif
#endif

#ifdef FASTCALL_STRNCPY_SSS
char __near * __fastcall fn_call strncpy_sss(char __near * const, const char __near * const, const size_t);
#else
char __near * fn_call strncpy_sss(char __near * const, const char __near * const, const size_t);
#endif

#ifdef FASTCALL_STRNCPY_DSS
char __near * __fastcall fn_call strncpy_dss(char __near * const, const char __near * const, const size_t);
#else
char __near * fn_call strncpy_dss(char __near * const, const char __near * const, const size_t);
#endif

/* strncat */
#ifdef FASTCALL_STRNCAT
char __near * __fastcall fn_call strncat(char __near * const, const char __near * const, const int);
#else
char __near * fn_call strncat(char __near * const, const char __near * const, const int);
#endif

#ifndef DEFINED_P_FN_STRNCAT
# define DEFINED_P_FN_STRNCAT
  typedef char __near * (fn_call_dist * P_FN_STRNCAT)(char __near * const, const char __near * const, const int);
#endif

#ifndef DEFINED_P_FN_FC_STRNCAT
# define DEFINED_P_FN_FC_STRNCAT
  typedef char __near * (fn_call_dist __fastcall * P_FN_FC_STRNCAT)(char __near * const, const char __near * const, const int);
#endif

#if CLIBC_16_FC_EXT_PTRS==CLIBC_16_FC_EXT_PTRS_YES
# ifndef DEFINED_EXTERN_P_FN_FC_STRNCAT
#  define DEFINED_EXTERN_P_FN_FC_STRNCAT
   extern P_FN_FC_STRNCAT const p_fn_fc_strncat[3];
# endif
#endif

#ifdef FASTCALL_STRNCAT_SSS
char __near * __fastcall fn_call strncat_sss(char __near * const, const char __near * const, const int);
#else
char __near * fn_call strncat_sss(char __near * const, const char __near * const, const int);
#endif

#ifdef FASTCALL_STRNCAT_DSS
char __near * __fastcall fn_call strncat_dss(char __near * const, const char __near * const, const int);
#else
char __near * fn_call strncat_dss(char __near * const, const char __near * const, const int);
#endif

/* memmove */
#ifdef FASTCALL_MEMMOVE
void __near * __fastcall fn_call memmove(void __near * const, void __near * const, const int);
#else
void __near * fn_call memmove(void __near * const, void __near * const, const int);
#endif

#ifndef DEFINED_P_FN_MEMMOVE
# define DEFINED_P_FN_MEMMOVE
  typedef void __near * (fn_call_dist * P_FN_MEMMOVE)(void __near * const, void __near * const, const int);
#endif

#ifndef DEFINED_P_FN_FC_MEMMOVE
# define DEFINED_P_FN_FC_MEMMOVE
  typedef void __near * (fn_call_dist __fastcall * P_FN_FC_MEMMOVE)(void __near * const, void __near * const, const int);
#endif

#if CLIBC_16_FC_EXT_PTRS==CLIBC_16_FC_EXT_PTRS_YES
# ifndef DEFINED_EXTERN_P_FN_FC_MEMMOVE
#  define DEFINED_EXTERN_P_FN_FC_MEMMOVE
   extern P_FN_FC_MEMMOVE const p_fn_fc_memmove[2];
# endif
#endif

#ifdef FASTCALL_MEMMOVE_SSS
void __near * __fastcall fn_call memmove_sss(void __near * const, void __near * const, const int);
#else
void __near * fn_call memmove_sss(void __near * const, void __near * const, const int);
#endif

#ifdef FASTCALL_MEMMOVE_DSS
void __near * __fastcall fn_call memmove_dss(void __near * const, void __near * const, const int);
#else
void __near * fn_call memmove_dss(void __near * const, void __near * const, const int);
#endif

/* memset */
#ifdef FASTCALL_MEMSET
void __near * __fastcall fn_call memset(void __near * const, const int, const int);
#else
void __near * fn_call memset(void __near * const, const int, const int);
#endif

#ifndef DEFINED_P_FN_MEMSET
# define DEFINED_P_FN_MEMSET
  typedef void __near * (fn_call_dist * P_FN_MEMSET)(void __near * const, const int, const int);
#endif

#ifndef DEFINED_P_FN_FC_MEMSET
# define DEFINED_P_FN_FC_MEMSET
  typedef int (fn_call_dist __fastcall * P_FN_FC_MEMSET)(int);
#endif

#if CLIBC_16_FC_EXT_PTRS==CLIBC_16_FC_EXT_PTRS_YES
# ifndef DEFINED_EXTERN_P_FN_FC_MEMSET
#  define DEFINED_EXTERN_P_FN_FC_MEMSET
   extern P_FN_FC_MEMSET const p_fn_fc_memset[2];
# endif
#endif

#ifdef FASTCALL_MEMSET_SSS
void __near * __fastcall fn_call memset_sss(void __near * const, const int, const int);
#else
void __near * fn_call memset_sss(void __near * const, const int, const int);
#endif

/* memcmp */
#ifdef FASTCALL_MEMCMP
int __fastcall fn_call memcmp(const void __near * const, const void __near * const, const int);
#else
int fn_call memcmp(const void __near * const, const void __near * const, const int);
#endif

#ifndef DEFINED_P_FN_MEMCMP
# define DEFINED_P_FN_MEMCMP
  typedef int (fn_call_dist * P_FN_MEMCMP)(const void __near * const, const void __near * const, const int);
#endif

#ifndef DEFINED_P_FN_FC_MEMCMP
# define DEFINED_P_FN_FC_MEMCMP
  typedef int (fn_call_dist __fastcall * P_FN_FC_MEMCMP)(const void __near * const, const void __near * const, const int);
#endif

#if CLIBC_16_FC_EXT_PTRS==CLIBC_16_FC_EXT_PTRS_YES
# ifndef DEFINED_EXTERN_P_FN_FC_MEMCMP
#  define DEFINED_EXTERN_P_FN_FC_MEMCMP
   extern P_FN_FC_MEMCMP const p_fn_fc_memcmp[3];
# endif
#endif

#ifdef FASTCALL_MEMCMP_SSS
int __fastcall fn_call memcmp_sss(const void __near * const, const void __near * const, const int);
#else
int fn_call memcmp_sss(const void __near * const, const void __near * const, const int);
#endif

#ifdef FASTCALL_MEMCMP_DSS
int __fastcall fn_call memcmp_dss(const void __near * const, const void __near * const, const int);
#else
int fn_call memcmp_dss(const void __near * const, const void __near * const, const int);
#endif
