INCLUDE CLIBC_16.INC

IFDEF CLIBC_16_FC_EXT_PTRS
 IF CLIBC_16_FC_EXT_PTRS EQ CLIBC_16_FC_EXT_PTRS_YES

_DATA SEGMENT
EXTERNDEF C p_fn_fc_isalpha:FN_CALL PTR
p_fn_fc_isalpha P_FN_CALL @isalpha
_DATA ENDS

 ENDIF
ENDIF

;isalpha() - Letter('A'-'Z' or 'a'-'z')
;int fn_call isalpha(const int);

;RETURNS:
;   0	    if is NOT a letter
;   1	    if is     a letter

CLIBC_16_CS SEGMENT
isalpha PROC FN_CALL C, num:WORD
    xor ax, ax
    mov bx, [num]

    cmp bl, 'A' ; uppercase
    jb @@done
    cmp bl, 'Z'
    jbe @@yes

    cmp bl, 'a' ; lowercase
    jb @@done
    cmp bl, 'z'
    ja @@done
@@yes:
    inc ax
@@done:
    ret
isalpha ENDP

; __fastcall
;   AX	    nchar
;int__fastcall fn_call isalpha(const int);
@isalpha PROC FN_CALL USES bx
    mov bx, ax
    xor ax, ax

    cmp bl, 'A' ; uppercase
    jb @@done
    cmp bl, 'Z'
    jbe @@yes

    cmp bl, 'a' ; lowercase
    jb @@done
    cmp bl, 'z'
    ja @@done
@@yes:
    inc ax
@@done:
    ret
@isalpha ENDP
CLIBC_16_CS ENDS
END
